/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostalCarrier;
import forestry.core.config.SessionVars;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiTextBox;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.Widget;
import forestry.core.render.ColourProperties;
import forestry.core.utils.NetworkUtil;
import forestry.mail.carriers.PostalCarriers;
import forestry.mail.gui.AddresseeSlot;
import forestry.mail.gui.ContainerLetter;
import forestry.mail.inventory.ItemInventoryLetter;
import forestry.mail.network.packets.PacketLetterInfoRequest;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

public class GuiLetter
extends GuiForestry<ContainerLetter> {
    private final ItemInventoryLetter itemInventory;
    private final boolean isProcessedLetter;
    private boolean checkedSessionVars;
    private EditBox address;
    private GuiTextBox text;
    private boolean addressFocus;
    private boolean textFocus;
    private final ArrayList<Widget> tradeInfoWidgets;

    public GuiLetter(ContainerLetter container, Inventory inv, Component title) {
        super("textures/gui/letter.png", container, inv, title);
        this.f_96541_ = Minecraft.m_91087_();
        this.itemInventory = (ItemInventoryLetter)container.getItemInventory();
        this.f_97726_ = 194;
        this.f_97727_ = 227;
        this.isProcessedLetter = container.getLetter().isProcessed();
        this.widgetManager.add(new AddresseeSlot(this.widgetManager, 16, 12, container));
        this.tradeInfoWidgets = new ArrayList();
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.address = new EditBox(this.f_96541_.f_91062_, this.f_97735_ + 46, this.f_97736_ + 13, 93, 13, null);
        this.address.m_94186_(!this.isProcessedLetter);
        IMailAddress recipient = ((ContainerLetter)this.f_97732_).getRecipient();
        if (recipient != null) {
            this.address.m_94144_(recipient.getName());
        }
        this.text = new GuiTextBox(this.f_96541_.f_91062_, this.f_97735_ + 17, this.f_97736_ + 31, 122, 57);
        this.text.m_94199_(128);
        this.text.m_94186_(!this.isProcessedLetter);
        if (!((ContainerLetter)this.f_97732_).getText().isEmpty()) {
            this.text.m_94144_(((ContainerLetter)this.f_97732_).getText());
        }
        this.m_7787_((GuiEventListener)this.address);
        this.m_7787_((GuiEventListener)this.text);
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (this.isProcessedLetter) {
            return super.m_7933_(key, scanCode, modifiers);
        }
        if (this.address.m_93696_()) {
            if (key == 257 || key == 256) {
                this.address.m_93692_(false);
            } else if (key == 258) {
                String currentValue = this.address.m_94155_().toLowerCase(Locale.ENGLISH);
                Minecraft.m_91087_().m_91403_().m_105142_().stream().map(info -> info.m_105312_().getName()).filter(name -> name.toLowerCase(Locale.ENGLISH).contains(currentValue)).findFirst().ifPresent(name -> this.address.m_94144_(name));
            } else {
                this.address.m_7933_(key, scanCode, modifiers);
            }
            return true;
        }
        if (this.text.m_93696_()) {
            if (key == 257 || key == 256) {
                if (GuiLetter.m_96638_() && key != 256) {
                    this.text.m_94144_(this.text.m_94155_() + "\n");
                } else {
                    this.text.m_93692_(false);
                }
            } else if (key == 264) {
                this.text.advanceLine();
            } else if (key == 265) {
                this.text.regressLine();
            } else if (this.text.moreLinesAllowed() || key == 261 || key == 92) {
                this.text.m_7933_(key, scanCode, modifiers);
            }
            return true;
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (super.m_6375_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        this.address.m_6375_(mouseX, mouseY, mouseButton);
        this.text.m_6375_(mouseX, mouseY, mouseButton);
        return true;
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseY, int mouseX) {
        IPostalCarrier carrier;
        String recipient;
        if (!this.isProcessedLetter && !this.checkedSessionVars) {
            this.checkedSessionVars = true;
            this.setFromSessionVars();
            recipient = this.address.m_94155_();
            carrier = ((ContainerLetter)this.f_97732_).getCarrier();
            this.setRecipient(recipient, carrier);
        }
        if (this.addressFocus != this.address.m_93696_()) {
            recipient = this.address.m_94155_();
            carrier = ((ContainerLetter)this.f_97732_).getCarrier();
            if (StringUtils.isNotBlank((CharSequence)recipient)) {
                this.setRecipient(recipient, carrier);
            }
        }
        this.addressFocus = this.address.m_93696_();
        if (this.textFocus != this.text.m_93696_()) {
            this.setText();
        }
        this.textFocus = this.text.m_93696_();
        super.m_7286_(graphics, partialTicks, mouseY, mouseX);
        if (this.isProcessedLetter) {
            graphics.m_280488_(this.f_96547_, this.address.m_94155_(), this.f_97735_ + 49, this.f_97736_ + 16, ColourProperties.INSTANCE.get("gui.mail.lettertext"));
            graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237113_((String)this.text.m_94155_()), this.f_97735_ + 20, this.f_97736_ + 34, 119, ColourProperties.INSTANCE.get("gui.mail.lettertext"));
        } else {
            this.clearTradeInfoWidgets();
            this.address.m_88315_(graphics, mouseX, mouseY, partialTicks);
            if (((ContainerLetter)this.f_97732_).getCarrier().equals(PostalCarriers.TRADER.get())) {
                this.drawTradePreview(graphics, 18, 32);
            } else {
                this.text.m_88315_(graphics, mouseX, mouseY, partialTicks);
            }
        }
    }

    private void drawTradePreview(GuiGraphics graphics, int x, int y) {
        MutableComponent infoString = null;
        if (((ContainerLetter)this.f_97732_).getTradeInfo() == null) {
            infoString = Component.m_237115_((String)"for.gui.mail.no.trader");
        } else if (((ContainerLetter)this.f_97732_).getTradeInfo().tradegood().m_41619_()) {
            infoString = Component.m_237115_((String)"for.gui.mail.nothing.to.trade");
        } else if (!((ContainerLetter)this.f_97732_).getTradeInfo().state().isOk()) {
            infoString = ((ContainerLetter)this.f_97732_).getTradeInfo().state().getDescription();
        }
        if (infoString != null) {
            graphics.m_280554_(this.f_96547_, (FormattedText)infoString, this.f_97735_ + x, this.f_97736_ + y, 119, ColourProperties.INSTANCE.get("gui.mail.lettertext"));
            return;
        }
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"for.gui.mail.pleasesend"), this.f_97735_ + x, this.f_97736_ + y, ColourProperties.INSTANCE.get("gui.mail.lettertext"));
        this.addTradeInfoWidget(new ItemStackWidget(this.widgetManager, x, y + 10, ((ContainerLetter)this.f_97732_).getTradeInfo().tradegood()));
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"for.gui.mail.foreveryattached"), this.f_97735_ + x, this.f_97736_ + y + 28, ColourProperties.INSTANCE.get("gui.mail.lettertext"));
        for (int i = 0; i < ((ContainerLetter)this.f_97732_).getTradeInfo().required().size(); ++i) {
            this.addTradeInfoWidget(new ItemStackWidget(this.widgetManager, x + i * 18, y + 38, ((ContainerLetter)this.f_97732_).getTradeInfo().required().get(i)));
        }
    }

    private void addTradeInfoWidget(Widget widget) {
        this.tradeInfoWidgets.add(widget);
        this.widgetManager.add(widget);
    }

    private void clearTradeInfoWidgets() {
        for (Widget widget : this.tradeInfoWidgets) {
            this.widgetManager.remove(widget);
        }
        this.tradeInfoWidgets.clear();
    }

    @Override
    public void m_7379_() {
        String recipientName = this.address.m_94155_();
        IPostalCarrier carrier = ((ContainerLetter)this.f_97732_).getCarrier();
        this.setRecipient(recipientName, carrier);
        this.setText();
        super.m_7379_();
    }

    private void setFromSessionVars() {
        if (SessionVars.getStringVar("mail.letter.recipient") == null) {
            return;
        }
        String recipient = SessionVars.getStringVar("mail.letter.recipient");
        String typeName = SessionVars.getStringVar("mail.letter.carrier");
        ResourceLocation carrierId = ResourceLocation.m_135820_((String)typeName);
        IPostalCarrier carrier = (IPostalCarrier)PostalCarriers.REGISTRY.get().getValue(carrierId);
        if (StringUtils.isNotBlank((CharSequence)recipient) && carrier != null) {
            this.address.m_94144_(recipient);
            ((ContainerLetter)this.f_97732_).setCarrier(carrier);
        }
        SessionVars.clearStringVar("mail.letter.recipient");
        SessionVars.clearStringVar("mail.letter.carrier");
    }

    private void setRecipient(String recipientName, IPostalCarrier carrier) {
        if (this.isProcessedLetter || StringUtils.isBlank((CharSequence)recipientName)) {
            return;
        }
        PacketLetterInfoRequest packet = new PacketLetterInfoRequest(recipientName, carrier);
        NetworkUtil.sendToServer(packet);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setText() {
        if (this.isProcessedLetter) {
            return;
        }
        ((ContainerLetter)this.f_97732_).setText(this.text.m_94155_());
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger(this.itemInventory);
        this.addHintLedger("letter");
    }
}

