/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.carriers.trading;

import com.mojang.authlib.GameProfile;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.ITradeStation;
import forestry.mail.IWatchable;
import forestry.mail.MailAddress;
import forestry.mail.carriers.PostalCarriers;
import forestry.mail.carriers.trading.TradeStation;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class TradeStationRegistry
extends SavedData
implements IWatchable.Watcher {
    private static final String SAVE_NAME = "forestry_trade_stations";
    public static final Pattern TRADE_STATION_NAME_REGEX = Pattern.compile("^[a-zA-Z0-9]+$");
    private final Map<IMailAddress, ITradeStation> cachedTradeStations = new HashMap<IMailAddress, ITradeStation>();

    public boolean isValidTradeAddress(IMailAddress address) {
        return address.getCarrier().equals(PostalCarriers.TRADER.get()) && TRADE_STATION_NAME_REGEX.matcher(address.getName()).matches();
    }

    public boolean isAvailableTradeAddress(IMailAddress address) {
        return this.getTradeStation(address) == null;
    }

    public void registerTradeStation(IMailAddress address, ITradeStation station) {
        this.cachedTradeStations.put(address, station);
        station.registerUpdateWatcher(this);
        this.m_77762_();
    }

    @Nullable
    public ITradeStation getTradeStation(IMailAddress address) {
        if (this.cachedTradeStations.containsKey(address)) {
            return this.cachedTradeStations.get(address);
        }
        return null;
    }

    public ITradeStation getOrCreateTradeStation(GameProfile owner, IMailAddress address) {
        ITradeStation trade = this.getTradeStation(address);
        if (trade == null) {
            trade = new TradeStation(owner, address);
            this.registerTradeStation(address, trade);
            trade.setDirty();
        }
        return trade;
    }

    public void deleteTradeStation(IMailAddress address) {
        ITradeStation trade = this.getTradeStation(address);
        if (trade == null) {
            return;
        }
        trade.invalidate();
        trade.unregisterUpdateWatcher(this);
        this.cachedTradeStations.remove(address);
        this.m_77762_();
    }

    public Map<IMailAddress, ITradeStation> getActiveTradeStations() {
        return this.cachedTradeStations;
    }

    @Override
    public void onWatchableUpdate() {
        this.m_77762_();
    }

    private static TradeStationRegistry create() {
        return new TradeStationRegistry();
    }

    private static TradeStationRegistry load(CompoundTag compoundTag) {
        TradeStationRegistry registry = new TradeStationRegistry();
        ListTag tradeStations = compoundTag.m_128437_("tradeStations", 10);
        for (int i = 0; i < tradeStations.size(); ++i) {
            CompoundTag stationTag = tradeStations.m_128728_(i);
            MailAddress address = new MailAddress(stationTag.m_128469_("address"));
            TradeStation station = new TradeStation(stationTag.m_128469_("station"));
            registry.registerTradeStation(address, station);
        }
        return registry;
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        ListTag tradeStations = new ListTag();
        for (Map.Entry<IMailAddress, ITradeStation> entry : this.cachedTradeStations.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128365_("address", (Tag)entry.getKey().write(new CompoundTag()));
            entryTag.m_128365_("station", (Tag)entry.getValue().write(new CompoundTag()));
            tradeStations.add((Object)entryTag);
        }
        compoundTag.m_128365_("tradeStations", (Tag)tradeStations);
        return compoundTag;
    }

    public static TradeStationRegistry getOrCreate(ServerLevel level) {
        return (TradeStationRegistry)level.m_8895_().m_164861_(TradeStationRegistry::load, TradeStationRegistry::create, SAVE_NAME);
    }
}

