/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.lepidopterology.entities.EntityButterfly;

public enum EnumButterflyState {
    FLYING(true),
    GLIDING(true),
    RISING(true),
    RESTING(false),
    HOVER(false);

    public static final EnumButterflyState[] VALUES;
    public final boolean doesMovement;

    private EnumButterflyState(boolean doesMovement) {
        this.doesMovement = doesMovement;
    }

    public float getWingFlap(EntityButterfly entity, long offset, float partialTicktime) {
        if (this == RESTING || this == HOVER) {
            long systemTime = System.currentTimeMillis();
            long flapping = systemTime + offset;
            float flap = (float)(flapping % 1000L) / 1000.0f;
            return EnumButterflyState.getIrregularWingYaw(flapping, flap);
        }
        return (float)entity.f_19797_ + partialTicktime;
    }

    public static float getIrregularWingYaw(long flapping, float flap) {
        float wingYaw;
        long irregular = flapping / 1024L;
        if (irregular % 11L == 0L) {
            wingYaw = 0.75f;
        } else {
            if (irregular % 7L == 0L) {
                flap *= 4.0f;
                flap %= 1.0f;
            } else if (irregular % 19L == 0L) {
                flap *= 6.0f;
                flap %= 1.0f;
            }
            wingYaw = EnumButterflyState.getRegularWingYaw(flap);
        }
        return wingYaw;
    }

    private static float getRegularWingYaw(float flap) {
        return (double)flap < 0.5 ? 0.75f + flap : 1.75f - flap;
    }

    static {
        VALUES = EnumButterflyState.values();
    }
}

