/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.farmables;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.crops.CropChorusFlower;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public enum FarmableChorus implements IFarmable
{
    INSTANCE;

    private final ItemStack germling = new ItemStack((ItemLike)Blocks.f_50491_);
    private final ItemStack fruit = new ItemStack((ItemLike)Items.f_42730_);

    @Override
    public boolean isSaplingAt(Level level, BlockPos pos, BlockState state) {
        return state.m_60734_() == Blocks.f_50491_;
    }

    @Override
    @Nullable
    public ICrop getCropAt(Level level, BlockPos pos, BlockState state) {
        if (state.m_60734_() != Blocks.f_50491_) {
            return null;
        }
        if ((Integer)state.m_61143_((Property)ChorusFlowerBlock.f_51647_) < 5) {
            return null;
        }
        return new CropChorusFlower(level, pos);
    }

    @Override
    public boolean isGermling(ItemStack stack) {
        return ItemStack.m_41656_((ItemStack)this.germling, (ItemStack)stack);
    }

    @Override
    public void addGermlings(Consumer<ItemStack> accumulator) {
        accumulator.accept(this.germling);
    }

    @Override
    public void addProducts(Consumer<ItemStack> accumulator) {
        accumulator.accept(this.germling);
        accumulator.accept(this.fruit);
    }

    @Override
    public boolean isWindfall(ItemStack stack) {
        return ItemStack.m_41656_((ItemStack)this.fruit, (ItemStack)stack);
    }

    @Override
    public boolean plantSaplingAt(Player player, ItemStack germling, Level level, BlockPos pos) {
        if (!this.canPlace(level, pos)) {
            return false;
        }
        return BlockUtil.setBlockWithPlaceSound(level, pos, Blocks.f_50491_.m_49966_());
    }

    private boolean canPlace(Level world, BlockPos position) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos offsetPosition = position.m_7918_(x, 0, z);
                BlockState state = world.m_8055_(offsetPosition);
                if (state.m_60734_() != Blocks.f_50491_ && state.m_60734_() != Blocks.f_50490_) continue;
                return false;
            }
        }
        return true;
    }
}

