/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.ForestryError;
import forestry.api.core.IErrorLogic;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.IFermenterRecipe;
import forestry.api.recipes.IVariableFermentable;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.FluidRecipeFilter;
import forestry.core.fluids.TankManager;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.RecipeUtils;
import forestry.factory.features.FactoryTiles;
import forestry.factory.gui.ContainerFermenter;
import forestry.factory.inventory.InventoryFermenter;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileFermenter
extends TilePowered
implements WorldlyContainer,
ILiquidTankTile {
    private final FilteredTank resourceTank;
    private final FilteredTank productTank;
    private final TankManager tankManager;
    @Nullable
    private IFermenterRecipe currentRecipe;
    private float currentResourceModifier;
    private int fermentationTime = 0;
    private int fermentationTotalTime = 0;
    private int fuelBurnTime = 0;
    private int fuelTotalTime = 0;
    private int fuelCurrentFerment = 0;

    public TileFermenter(BlockPos pos, BlockState state) {
        super(FactoryTiles.FERMENTER.tileType(), pos, state, 2000, 80000);
        this.setEnergyPerWorkCycle(4200);
        this.setInternalInventory(new InventoryFermenter(this));
        this.resourceTank = new FilteredTank(10000, true, true).setFilter(FluidRecipeFilter.FERMENTER_INPUT);
        this.productTank = new FilteredTank(10000, false, true).setFilter(FluidRecipeFilter.FERMENTER_OUTPUT);
        this.tankManager = new TankManager(this, this.resourceTank, this.productTank);
    }

    @Override
    public void m_183515_(CompoundTag compoundNBT) {
        super.m_183515_(compoundNBT);
        compoundNBT.m_128405_("FermentationTime", this.fermentationTime);
        compoundNBT.m_128405_("FermentationTotalTime", this.fermentationTotalTime);
        compoundNBT.m_128405_("FuelBurnTime", this.fuelBurnTime);
        compoundNBT.m_128405_("FuelTotalTime", this.fuelTotalTime);
        compoundNBT.m_128405_("FuelCurrentFerment", this.fuelCurrentFerment);
        this.tankManager.write(compoundNBT);
    }

    @Override
    public void m_142466_(CompoundTag compoundNBT) {
        super.m_142466_(compoundNBT);
        this.fermentationTime = compoundNBT.m_128451_("FermentationTime");
        this.fermentationTotalTime = compoundNBT.m_128451_("FermentationTotalTime");
        this.fuelBurnTime = compoundNBT.m_128451_("FuelBurnTime");
        this.fuelTotalTime = compoundNBT.m_128451_("FuelTotalTime");
        this.fuelCurrentFerment = compoundNBT.m_128451_("FuelCurrentFerment");
        this.tankManager.read(compoundNBT);
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(FriendlyByteBuf data) {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (Container)this, 4);
            FluidStack fluidStack = this.productTank.getFluid();
            if (fluidStack != null) {
                FluidHelper.fillContainers(this.tankManager, (Container)this, 3, 2, fluidStack.getFluid(), true);
            }
        }
    }

    @Override
    public boolean workCycle() {
        if (this.currentRecipe == null) {
            return false;
        }
        int fermented = Math.min(this.fermentationTime, this.fuelCurrentFerment);
        int productAmount = Math.round((float)fermented * this.currentRecipe.getModifier() * this.currentResourceModifier);
        this.productTank.fillInternal(new FluidStack(this.currentRecipe.getOutput(), productAmount), IFluidHandler.FluidAction.EXECUTE);
        --this.fuelBurnTime;
        this.resourceTank.drain(fermented, IFluidHandler.FluidAction.EXECUTE);
        this.fermentationTime -= fermented;
        if (this.fermentationTime > 0) {
            return false;
        }
        this.currentRecipe = null;
        return true;
    }

    private void checkRecipe() {
        if (this.currentRecipe != null) {
            return;
        }
        ItemStack resource = this.m_8020_(0);
        FluidStack fluid = this.resourceTank.getFluid();
        if (!fluid.isEmpty()) {
            this.currentRecipe = RecipeUtils.getFermenterRecipe(this.f_58857_.m_7465_(), resource, fluid);
        }
        this.fermentationTime = this.currentRecipe == null ? 0 : this.currentRecipe.getFermentationValue();
        this.fermentationTotalTime = this.fermentationTime;
        if (this.currentRecipe != null) {
            this.currentResourceModifier = TileFermenter.determineResourceMod(resource);
            this.m_7407_(0, 1);
        }
    }

    private void checkFuel() {
        FermenterFuel fermenterFuel;
        ItemStack fuel;
        if (this.fuelBurnTime <= 0 && !(fuel = this.m_8020_(1)).m_41619_() && (fermenterFuel = FuelManager.fermenterFuel.get(fuel)) != null) {
            this.fuelBurnTime = this.fuelTotalTime = fermenterFuel.burnDuration();
            this.fuelCurrentFerment = fermenterFuel.fermentPerCycle();
            this.m_7407_(1, 1);
        }
    }

    private static float determineResourceMod(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IVariableFermentable) {
            IVariableFermentable fermentable = (IVariableFermentable)item;
            return fermentable.getFermentationModifier(stack);
        }
        return 1.0f;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        ItemStack fermentationStack = this.m_8020_(0);
        if (fermentationStack.m_41619_()) {
            return false;
        }
        return (float)fermentationStack.m_41613_() / (float)fermentationStack.m_41741_() > percentage;
    }

    @Override
    public boolean hasFuelMin(float percentage) {
        ItemStack fuelStack = this.m_8020_(1);
        if (fuelStack.m_41619_()) {
            return false;
        }
        return (float)fuelStack.m_41613_() / (float)fuelStack.m_41741_() > percentage;
    }

    @Override
    public boolean hasWork() {
        this.checkRecipe();
        this.checkFuel();
        int fermented = Math.min(this.fermentationTime, this.fuelCurrentFerment);
        boolean hasRecipe = this.currentRecipe != null;
        boolean hasFuel = this.fuelBurnTime > 0;
        boolean hasResource = this.fermentationTime > 0 || !this.m_8020_(0).m_41619_();
        FluidStack drained = this.resourceTank.drain(fermented, IFluidHandler.FluidAction.SIMULATE);
        boolean hasFluidResource = !drained.isEmpty() && drained.getAmount() == fermented;
        boolean hasFluidSpace = true;
        if (hasRecipe) {
            int productAmount = Math.round((float)fermented * this.currentRecipe.getModifier() * this.currentResourceModifier);
            Fluid output = this.currentRecipe.getOutput();
            FluidStack fluidStack = new FluidStack(output, productAmount);
            hasFluidSpace = this.productTank.fillInternal(fluidStack, IFluidHandler.FluidAction.SIMULATE) == fluidStack.getAmount();
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasRecipe, ForestryError.NO_RECIPE);
        errorLogic.setCondition(!hasFuel, ForestryError.NO_FUEL);
        errorLogic.setCondition(!hasResource, ForestryError.NO_RESOURCE);
        errorLogic.setCondition(!hasFluidResource, ForestryError.NO_RESOURCE_LIQUID);
        errorLogic.setCondition(!hasFluidSpace, ForestryError.NO_SPACE_TANK);
        return hasRecipe && hasFuel && hasResource && hasFluidResource && hasFluidSpace;
    }

    public int getBurnTimeRemainingScaled(int i) {
        if (this.fuelTotalTime == 0) {
            return 0;
        }
        return this.fuelBurnTime * i / this.fuelTotalTime;
    }

    public int getFermentationProgressScaled(int i) {
        if (this.fermentationTotalTime == 0) {
            return 0;
        }
        return this.fermentationTime * i / this.fermentationTotalTime;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank);
    }

    @Override
    public TankRenderInfo getProductTankInfo() {
        return new TankRenderInfo((IFluidTank)this.productTank);
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.fuelBurnTime = j;
                break;
            }
            case 1: {
                this.fuelTotalTime = j;
                break;
            }
            case 2: {
                this.fermentationTime = j;
                break;
            }
            case 3: {
                this.fermentationTotalTime = j;
            }
        }
    }

    public void sendGUINetworkData(AbstractContainerMenu container, ContainerListener iCrafting) {
        iCrafting.m_142153_(container, 0, this.fuelBurnTime);
        iCrafting.m_142153_(container, 1, this.fuelTotalTime);
        iCrafting.m_142153_(container, 2, this.fermentationTime);
        iCrafting.m_142153_(container, 3, this.fermentationTotalTime);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ContainerFermenter(windowId, inv, this);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(() -> this.tankManager).cast();
        }
        return super.getCapability(capability, facing);
    }
}

