/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy;

import forestry.api.client.IClientModuleHandler;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.EngineCopperFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.modules.ForestryModule;
import forestry.api.modules.ForestryModuleIds;
import forestry.core.features.CoreItems;
import forestry.core.fluids.ForestryFluids;
import forestry.core.utils.datastructures.FluidMap;
import forestry.core.utils.datastructures.ItemStackMap;
import forestry.energy.client.EnergyClientHandler;
import forestry.modules.BlankForestryModule;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeMod;

@ForestryModule
public class ModuleEnergy
extends BlankForestryModule {
    @Override
    public ResourceLocation getId() {
        return ForestryModuleIds.ENERGY;
    }

    @Override
    public void setupApi() {
        FuelManager.biogasEngineFuel = new FluidMap<EngineBronzeFuel>();
        FuelManager.peatEngineFuel = new ItemStackMap<EngineCopperFuel>();
        Fluid biomass = ForestryFluids.BIOMASS.getFluid();
        FuelManager.biogasEngineFuel.put(biomass, new EngineBronzeFuel(biomass, 50, 2500, 1));
        FuelManager.biogasEngineFuel.put((Fluid)Fluids.f_76193_, new EngineBronzeFuel((Fluid)Fluids.f_76193_, 10, 1000, 3));
        Fluid milk = (Fluid)ForgeMod.MILK.get();
        FuelManager.biogasEngineFuel.put(milk, new EngineBronzeFuel(milk, 10, 10000, 3));
        Fluid seedOil = ForestryFluids.SEED_OIL.getFluid();
        FuelManager.biogasEngineFuel.put(seedOil, new EngineBronzeFuel(seedOil, 30, 2500, 1));
        Fluid honey = ForestryFluids.HONEY.getFluid();
        FuelManager.biogasEngineFuel.put(honey, new EngineBronzeFuel(honey, 20, 2500, 1));
        Fluid juice = ForestryFluids.JUICE.getFluid();
        FuelManager.biogasEngineFuel.put(juice, new EngineBronzeFuel(juice, 10, 2500, 1));
        ItemStack peat = CoreItems.PEAT.stack();
        FuelManager.peatEngineFuel.put(peat, new EngineCopperFuel(peat, 20, 2500));
        ItemStack bituminousPeat = CoreItems.BITUMINOUS_PEAT.stack();
        FuelManager.peatEngineFuel.put(bituminousPeat, new EngineCopperFuel(bituminousPeat, 40, 3000));
    }

    @Override
    public void registerClientHandler(Consumer<IClientModuleHandler> registrar) {
        registrar.accept(new EnergyClientHandler());
    }
}

