/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation.gui;

import forestry.core.features.CoreItems;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.widgets.TankWidget;
import forestry.cultivation.gui.ContainerPlanter;
import forestry.cultivation.gui.widgets.GhostItemStackWidget;
import forestry.cultivation.inventory.InventoryPlanter;
import forestry.cultivation.tiles.TilePlanter;
import forestry.farming.gui.FarmLedger;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class GuiPlanter
extends GuiForestryTitled<ContainerPlanter> {
    private final TilePlanter tile;

    public GuiPlanter(ContainerPlanter container, Inventory playerInventory, Component title) {
        super("textures/gui/planter.png", container, playerInventory, title);
        int index;
        int j;
        int i;
        this.tile = (TilePlanter)container.getTile();
        this.f_97726_ = 202;
        this.f_97727_ = 192;
        List<ItemStack> resourceStacks = this.tile.createResourceStacks();
        List<ItemStack> germlingStacks = this.tile.createGermlingStacks();
        List<ItemStack> productionStacks = this.tile.createProductionStacks();
        this.widgetManager.add(new TankWidget(this.widgetManager, 178, 44, 0).setOverlayOrigin(this.f_97726_, 18));
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 2; ++j) {
                index = j + i * 2;
                if (resourceStacks.size() != 4) continue;
                this.widgetManager.add(new GhostItemStackWidget(this.widgetManager, 11 + j * 18, 65 + i * 18, resourceStacks.get(index), ((ContainerPlanter)this.m_6262_()).m_38853_(36 + InventoryPlanter.CONFIG.resourcesStart + index)));
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 2; ++j) {
                index = j + i * 2;
                if (germlingStacks.size() != 4) continue;
                this.widgetManager.add(new GhostItemStackWidget(this.widgetManager, 71 + j * 18, 65 + i * 18, germlingStacks.get(index), ((ContainerPlanter)this.m_6262_()).m_38853_(36 + InventoryPlanter.CONFIG.germlingsStart + index)));
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 2; ++j) {
                index = j + i * 2;
                if (productionStacks.size() != 4) continue;
                this.widgetManager.add(new GhostItemStackWidget(this.widgetManager, 131 + j * 18, 65 + i * 18, productionStacks.get(index), ((ContainerPlanter)this.m_6262_()).m_38853_(36 + InventoryPlanter.CONFIG.productionStart + j + i * 2)));
            }
        }
        this.widgetManager.add(new GhostItemStackWidget(this.widgetManager, 83, 22, CoreItems.FERTILIZER_COMPOUND.stack(), ((ContainerPlanter)this.m_6262_()).m_38853_(36 + InventoryPlanter.CONFIG.fertilizerStart)));
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger(this.tile);
        this.addClimateLedger(this.tile);
        this.ledgerManager.add(new FarmLedger(this.ledgerManager, this.tile.getFarmLedgerDelegate()));
        this.addOwnerLedger(this.tile);
        this.addPowerLedger(this.tile.getEnergyManager());
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseY, int mouseX) {
        super.m_7286_(graphics, partialTicks, mouseY, mouseX);
        int fertilizerRemain = this.tile.getStoredFertilizerScaled(16);
        if (fertilizerRemain > 0) {
            graphics.m_280218_(this.textureFile, this.f_97735_ + 101, this.f_97736_ + 21 + 17 - fertilizerRemain, this.f_97726_, 17 - fertilizerRemain, 4, fertilizerRemain);
        }
    }
}

