/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.Forestry;
import forestry.api.ForestryCapabilities;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.IRegistryChromosome;
import forestry.core.utils.ModUtil;
import forestry.modules.features.FeatureItem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class JeiUtil {
    public static final String DESCRIPTION_KEY = "for.jei.description.";
    static final DecimalFormat FORMATTER = new DecimalFormat();

    public static void addDescription(IRecipeRegistration registry, String itemKey, FeatureItem<?> ... items) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (FeatureItem<?> item : items) {
            itemStacks.add(item.stack());
        }
        registry.addIngredientInfo(itemStacks, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)(DESCRIPTION_KEY + itemKey))});
    }

    public static void addDescription(IRecipeRegistration registry, Block ... blocks) {
        for (Block block : blocks) {
            Item item = block.m_5456_();
            if (item != Items.f_41852_) {
                JeiUtil.addDescription(registry, item);
                continue;
            }
            Forestry.LOGGER.error("No item for block {}", (Object)block);
        }
    }

    public static void addDescription(IRecipeRegistration registry, FeatureItem<?> ... items) {
        for (FeatureItem<?> item : items) {
            JeiUtil.addDescription(registry, item.get());
        }
    }

    public static void addDescription(IRecipeRegistration registry, Item ... items) {
        for (Item item : items) {
            JeiUtil.addDescription(registry, item);
        }
    }

    public static void addDescription(IRecipeRegistration registry, Item item) {
        ResourceLocation registryName = ModUtil.getRegistryName(item);
        String resourcePath = registryName.m_135815_();
        JeiUtil.addDescription(registry, item, resourcePath);
    }

    public static void addDescription(IRecipeRegistration registry, Item item, String itemKey) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        registry.addIngredientInfo((Object)itemStack, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)(DESCRIPTION_KEY + itemKey))});
    }

    public static List<IRecipeSlotBuilder> layoutSlotGrid(IRecipeLayoutBuilder builder, RecipeIngredientRole role, int width, int height, int xOffset, int yOffset, int slotSpacing) {
        ArrayList<IRecipeSlotBuilder> craftingSlots = new ArrayList<IRecipeSlotBuilder>();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                IRecipeSlotBuilder slot = builder.addSlot(role, xOffset + x * slotSpacing, yOffset + y * slotSpacing);
                craftingSlots.add(slot);
            }
        }
        return craftingSlots;
    }

    public static void setCraftingItems(List<IRecipeSlotBuilder> craftingSlots, CraftingRecipe craftingGridRecipe, ICraftingGridHelper craftingGridHelper) {
        int width = 0;
        int height = 0;
        if (craftingGridRecipe instanceof IShapedRecipe) {
            IShapedRecipe shapedRecipe = (IShapedRecipe)craftingGridRecipe;
            width = shapedRecipe.getRecipeWidth();
            height = shapedRecipe.getRecipeHeight();
        }
        JeiUtil.setCraftingItems(craftingSlots, (List<Ingredient>)craftingGridRecipe.m_7527_(), width, height, craftingGridHelper);
    }

    public static void setCraftingItems(List<IRecipeSlotBuilder> craftingSlots, List<Ingredient> ingredients, int width, int height, ICraftingGridHelper craftingGridHelper) {
        List<List> itemStacks = ingredients.stream().map(ingredient -> List.of(ingredient.m_43908_())).toList();
        craftingGridHelper.setInputs(craftingSlots, (IIngredientType)VanillaTypes.ITEM_STACK, itemStacks, width, height);
    }

    public static NonNullList<ItemStack> getFirstItemStacks(IRecipeSlotsView recipeSlots) {
        List slotViews = recipeSlots.getSlotViews(RecipeIngredientRole.INPUT);
        NonNullList result = NonNullList.m_122779_();
        for (IRecipeSlotView slot : slotViews) {
            if (slot.isEmpty()) {
                result.add((Object)ItemStack.f_41583_);
                continue;
            }
            slot.getDisplayedIngredient().filter(ingredient -> ingredient.getType() == VanillaTypes.ITEM_STACK).ifPresent(ingredient -> result.add((Object)((ItemStack)ingredient.getIngredient()).m_41777_()));
        }
        return result;
    }

    public static <S extends ISpecies<?>> void registerItemSubtypes(ISubtypeRegistration registry, IRegistryChromosome<S> species, ISpeciesType<S, ?> type) {
        IIngredientSubtypeInterpreter interpreter = (stack, context) -> stack.getCapability(ForestryCapabilities.INDIVIDUAL_HANDLER_ITEM).map(individual -> ((ISpecies)individual.getIndividual().getGenome().getActiveValue(species)).getBinomial()).orElse("");
        for (ILifeStage stage : type.getLifeStages()) {
            registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)stage.getItemForm(), interpreter);
        }
    }

    public static void drawCenteredMulti(GuiGraphics graphics, Component component, float x, float y, int color) {
        Font font = Minecraft.m_91087_().f_91062_;
        String[] split = component.getString().split(" ");
        for (int i = 0; i < split.length; ++i) {
            String line = split[i];
            Objects.requireNonNull(font);
            JeiUtil.drawCentered(graphics, font, line, x, y + (float)(i * 9), color);
        }
    }

    private static void drawCentered(GuiGraphics graphics, Font font, String line, float x, float y, int color) {
        int width = font.m_92895_(line);
        graphics.drawString(font, line, x - (float)width / 2.0f, y, color, false);
    }

    public static Component formatChance(double probability) {
        return Component.m_237110_((String)"for.jei.chance", (Object[])new Object[]{JeiUtil.formatPercentage(probability)}).m_130940_(ChatFormatting.GRAY);
    }

    public static String formatPercentage(double probability) {
        return FORMATTER.format(probability * 100.0);
    }

    static {
        FORMATTER.setMinimumFractionDigits(0);
        FORMATTER.setMaximumFractionDigits(3);
    }
}

