/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import forestry.Forestry;
import forestry.api.ForestryConstants;
import forestry.api.climate.IClimateProvider;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.IErrorSource;
import forestry.core.config.ForestryConfig;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.IGuiSizable;
import forestry.core.gui.TextLayoutHelper;
import forestry.core.gui.ledgers.ClimateLedger;
import forestry.core.gui.ledgers.HintLedger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.gui.ledgers.OwnerLedger;
import forestry.core.gui.ledgers.PowerLedger;
import forestry.core.gui.widgets.TankWidget;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.owner.IOwnedTile;
import forestry.core.render.ColourProperties;
import forestry.energy.ForestryEnergyStorage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public abstract class GuiForestry<C extends AbstractContainerMenu>
extends AbstractContainerScreen<C>
implements IGuiSizable {
    public static final LinkedListMultimap<String, String> HINTS = GuiForestry.readDefaultHints();
    public final ResourceLocation textureFile;
    protected final WidgetManager widgetManager = new WidgetManager(this);
    protected final LedgerManager ledgerManager = new LedgerManager(this);
    protected TextLayoutHelper textLayout;

    protected GuiForestry(String texture, C menu, Inventory inv, Component title) {
        this(ForestryConstants.forestry(texture), menu, inv, title);
    }

    protected GuiForestry(ResourceLocation texture, C menu, Inventory inv, Component title) {
        super(menu, inv, title);
        this.textureFile = texture;
    }

    public void m_7856_() {
        super.m_7856_();
        int maxLedgerWidth = (this.f_96543_ - this.f_97726_) / 2;
        this.ledgerManager.setMaxWidth(maxLedgerWidth);
        this.ledgerManager.clear();
        this.textLayout = new TextLayoutHelper(this, ColourProperties.INSTANCE);
        this.addLedgers();
    }

    public void m_6574_(Minecraft mc, int width, int height) {
        super.m_6574_(mc, width, height);
    }

    public void m_181908_() {
        super.m_181908_();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected abstract void addLedgers();

    protected final void addErrorLedger(IErrorSource errorSource) {
        this.ledgerManager.add(errorSource);
    }

    protected final void addErrorLedger(IErrorLogicSource errorSource) {
        this.ledgerManager.add(errorSource.getErrorLogic());
    }

    protected final void addClimateLedger(IClimateProvider climatised) {
        this.ledgerManager.add(new ClimateLedger(this.ledgerManager, climatised));
    }

    protected final void addPowerLedger(ForestryEnergyStorage energyStorage) {
        this.ledgerManager.add(new PowerLedger(this.ledgerManager, energyStorage));
    }

    protected final void addHintLedger(String hintsKey) {
        if (((Boolean)ForestryConfig.CLIENT.enableHints.get()).booleanValue()) {
            List hints = HINTS.get((Object)hintsKey);
            this.addHintLedger(hints);
        }
    }

    protected final void addHintLedger(List<String> hints) {
        if (((Boolean)ForestryConfig.CLIENT.enableHints.get()).booleanValue() && !hints.isEmpty()) {
            this.ledgerManager.add(new HintLedger(this.ledgerManager, hints));
        }
    }

    protected final void addOwnerLedger(IOwnedTile ownedTile) {
        this.ledgerManager.add(new OwnerLedger(this.ledgerManager, ownedTile));
    }

    public void m_7379_() {
        super.m_7379_();
        this.ledgerManager.onClose();
    }

    public ColourProperties getFontColor() {
        return ColourProperties.INSTANCE;
    }

    public Font font() {
        return this.f_96547_;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this.ledgerManager.handleMouseClicked(mouseX, mouseY, mouseButton);
        this.widgetManager.handleMouseClicked(mouseX, mouseY, mouseButton);
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        if (this.widgetManager.handleMouseRelease(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    @Nullable
    public TankWidget getTankAtPosition(double mouseX, double mouseY) {
        for (Widget widget : this.widgetManager.getWidgets()) {
            if (!(widget instanceof TankWidget)) continue;
            TankWidget tankWidget = (TankWidget)widget;
            if (!widget.isMouseOver(mouseX - (double)this.f_97735_, mouseY - (double)this.f_97736_)) continue;
            return tankWidget;
        }
        return null;
    }

    @Nullable
    protected Slot getSlotAtPosition(double mouseX, double mouseY) {
        for (int k = 0; k < this.f_97732_.f_38839_.size(); ++k) {
            Slot slot = (Slot)this.f_97732_.f_38839_.get(k);
            if (!this.isMouseOverSlot(slot, mouseX, mouseY)) continue;
            return slot;
        }
        return null;
    }

    private boolean isMouseOverSlot(Slot par1Slot, double mouseX, double mouseY) {
        return this.m_6774_(par1Slot.f_40220_, par1Slot.f_40221_, 16, 16, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        this.ledgerManager.drawTooltips(graphics, mouseX, mouseY);
        if (this.f_97732_.m_142621_().m_41619_()) {
            GuiUtil.drawToolTips(graphics, this, this.widgetManager.getWidgets(), mouseX, mouseY);
            GuiUtil.drawToolTips(graphics, this, this.f_169369_, mouseX, mouseY);
            GuiUtil.drawToolTips(graphics, this, this.f_97732_.f_38839_, mouseX, mouseY);
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.drawBackground(graphics);
        this.widgetManager.updateWidgets(mouseX - this.f_97735_, mouseY - this.f_97736_);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        PoseStack transform = graphics.m_280168_();
        transform.m_85836_();
        transform.m_252880_((float)this.f_97735_, (float)this.f_97736_, 0.0f);
        this.drawWidgets(graphics);
        transform.m_85849_();
        this.bindTexture(this.textureFile);
    }

    protected void drawBackground(GuiGraphics transform) {
        transform.m_280218_(this.textureFile, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void drawWidgets(GuiGraphics graphics) {
        this.ledgerManager.drawLedgers(graphics);
        this.widgetManager.drawWidgets(graphics);
    }

    protected void bindTexture(ResourceLocation texturePath) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texturePath);
    }

    @Override
    public int getSizeX() {
        return this.f_97726_;
    }

    @Override
    public int getSizeY() {
        return this.f_97727_;
    }

    @Override
    public Minecraft getGameInstance() {
        return (Minecraft)Preconditions.checkNotNull((Object)this.f_96541_);
    }

    public List<Rect2i> getExtraGuiAreas() {
        return this.ledgerManager.getLedgerAreas();
    }

    public TextLayoutHelper getTextLayout() {
        return this.textLayout;
    }

    private static LinkedListMultimap<String, String> readDefaultHints() {
        LinkedListMultimap map = LinkedListMultimap.create();
        Properties prop = new Properties();
        try {
            InputStream hintStream = GuiForestry.class.getResourceAsStream("/config/forestry/hints.properties");
            prop.load(hintStream);
        }
        catch (IOException | NullPointerException e) {
            Forestry.LOGGER.error("Failed to load hints file.", (Throwable)e);
        }
        for (String key : prop.stringPropertyNames()) {
            String list = prop.getProperty(key);
            if (list.isEmpty()) continue;
            for (String parsedHint : list.split(";+")) {
                map.put((Object)key, (Object)parsedHint);
            }
        }
        return map;
    }
}

