/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.factory.features.FactoryRecipeTypes;
import forestry.factory.recipes.RecipeSerializers;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;

public class FabricatorSmeltingRecipeBuilder {
    private int meltingPoint;
    private Ingredient resource;
    private FluidStack product;

    public FabricatorSmeltingRecipeBuilder setMeltingPoint(int meltingPoint) {
        this.meltingPoint = meltingPoint;
        return this;
    }

    public FabricatorSmeltingRecipeBuilder setResource(Ingredient resource) {
        this.resource = resource;
        return this;
    }

    public FabricatorSmeltingRecipeBuilder setProduct(FluidStack product) {
        this.product = product;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.meltingPoint, this.resource, this.product));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final int meltingPoint;
        private final Ingredient resource;
        private final FluidStack product;

        public Result(ResourceLocation id, int meltingPoint, Ingredient resource, FluidStack product) {
            this.id = id;
            this.meltingPoint = meltingPoint;
            this.resource = resource;
            this.product = product;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("melting", (Number)this.meltingPoint);
            json.add("resource", this.resource.m_43942_());
            json.add("product", (JsonElement)RecipeSerializers.serializeFluid(this.product));
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return FactoryRecipeTypes.FABRICATOR_SMELTING.serializer();
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

