/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data;

import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.arboriculture.blocks.BlockDecorativeLeaves;
import forestry.arboriculture.blocks.BlockDefaultLeaves;
import forestry.arboriculture.blocks.BlockForestryDoor;
import forestry.arboriculture.blocks.ForestryLeafType;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.features.ArboricultureItems;
import forestry.arboriculture.features.CharcoalBlocks;
import forestry.arboriculture.loot.CountBlockFunction;
import forestry.core.features.CoreBlocks;
import forestry.core.features.CoreItems;
import forestry.core.loot.OrganismFunction;
import forestry.core.utils.SpeciesUtil;
import forestry.lepidopterology.features.LepidopterologyBlocks;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureBlockGroup;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import thedarkcolour.modkit.MKUtils;

public class ForestryBlockLootTables
extends BlockLootSubProvider {
    private final LinkedHashSet<Block> added = new LinkedHashSet();

    protected ForestryBlockLootTables() {
        super(Set.of(), FeatureFlags.f_244332_);
    }

    protected void m_245660_() {
        MKUtils.forModRegistry((ResourceKey)Registries.f_256747_, (String)"forestry", (id, block) -> {
            if (block.m_60589_() != BuiltInLootTables.f_78712_) {
                this.m_245724_((Block)block);
            }
        });
        for (BlockDecorativeLeaves blockDecorativeLeaves : ArboricultureBlocks.LEAVES_DECORATIVE.getBlocks()) {
            this.m_246481_(blockDecorativeLeaves, block -> this.droppingWithChances((Block)block, blockDecorativeLeaves.getType(), f_244509_));
        }
        for (BlockDefaultLeaves blockDefaultLeaves : ArboricultureBlocks.LEAVES_DEFAULT.getBlocks()) {
            this.m_246481_((Block)blockDefaultLeaves, block -> this.droppingWithChances((Block)block, blockDefaultLeaves.getType(), f_244509_));
        }
        for (Map.Entry entry : ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.getFeatureByType().entrySet()) {
            FeatureBlock defaultLeaves = (FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get((ForestryLeafType)entry.getKey());
            Object defaultLeavesBlock = defaultLeaves.block();
            Object fruitLeavesBlock = ((FeatureBlock)entry.getValue()).block();
            this.m_246481_((Block)fruitLeavesBlock, block -> this.droppingWithChances((Block)defaultLeavesBlock, (ForestryLeafType)entry.getKey(), f_244509_));
        }
        for (BlockForestryDoor blockForestryDoor : ArboricultureBlocks.DOORS.getBlocks()) {
            this.m_247577_((Block)blockForestryDoor, this.m_247398_((Block)blockForestryDoor));
        }
        this.registerLootTable(CharcoalBlocks.ASH, block -> LootTable.m_79147_().m_79165_(LootContextParamSets.f_81421_).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(CoreItems.ASH)).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)2, (float)0.33333334f)))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42414_)).m_79078_(CountBlockFunction.builder()).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.575f, (int)2))));
        this.registerLootTable(CoreBlocks.PEAT, block -> LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Blocks.f_50493_))).m_79161_(LootPool.m_79043_().m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)CoreItems.PEAT.item()))));
        this.registerDropping(CoreBlocks.HUMUS, (ItemLike)Blocks.f_50493_);
        this.registerEmptyTables(ArboricultureBlocks.PODS);
        this.registerEmptyTables(ArboricultureBlocks.SAPLING_GE);
        this.registerEmptyTables(ArboricultureBlocks.LEAVES);
        this.registerEmptyTables(LepidopterologyBlocks.COCOON);
        this.registerEmptyTables(LepidopterologyBlocks.COCOON_SOLID);
        this.registerLootTable(CoreBlocks.APATITE_ORE, this::createApatiteOreDrops);
        this.registerLootTable(CoreBlocks.DEEPSLATE_APATITE_ORE, this::createApatiteOreDrops);
        this.registerLootTable(CoreBlocks.TIN_ORE, block -> this.m_246109_((Block)block, CoreItems.RAW_TIN.item()));
        this.registerLootTable(CoreBlocks.DEEPSLATE_TIN_ORE, block -> this.m_246109_((Block)block, CoreItems.RAW_TIN.item()));
        this.m_245724_(CoreBlocks.RAW_TIN_BLOCK.block());
    }

    private LootTable.Builder createApatiteOreDrops(Block block) {
        return ForestryBlockLootTables.m_247502_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)CoreItems.APATITE.item()).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)7.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)2)))));
    }

    public LootTable.Builder droppingWithChances(Block block, ForestryLeafType definition, float ... chances) {
        return ForestryBlockLootTables.m_246160_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootItem.m_79579_(ArboricultureItems.SAPLING).m_79078_(OrganismFunction.fromId(((ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get()).id(), definition.getSpeciesId())))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])chances)));
    }

    public void registerLootTable(FeatureBlock<?, ?> featureBlock, Function<Block, LootTable.Builder> builderFunction) {
        this.m_246481_((Block)featureBlock.block(), builderFunction);
    }

    public void registerDropping(FeatureBlock<?, ?> featureBlock, ItemLike drop) {
        this.m_246125_((Block)featureBlock.block(), drop);
    }

    public void registerEmptyTables(FeatureBlockGroup<?, ?> blockGroup) {
        this.registerEmptyTables(blockGroup.blockArray());
    }

    public void registerEmptyTables(FeatureBlock<?, ?> featureBlock) {
        this.registerEmptyTables(new Block[]{featureBlock.block()});
    }

    public void registerEmptyTables(Block ... blocks) {
        for (Block block : blocks) {
            this.m_247577_(block, ForestryBlockLootTables.m_246386_());
        }
    }

    protected void m_247577_(Block block, LootTable.Builder builder) {
        super.m_247577_(block, builder);
        this.added.add(block);
    }

    protected Iterable<Block> getKnownBlocks() {
        return this.added;
    }
}

