/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.entities;

import forestry.arboriculture.ForestryWoodType;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.features.ArboricultureEntities;
import forestry.arboriculture.features.ArboricultureItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ForestryBoat
extends Boat {
    private static final EntityDataAccessor<Integer> DATA_ID_WOOD_TYPE = SynchedEntityData.m_135353_(ForestryBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ForestryBoat(EntityType<? extends Boat> type, Level level) {
        super(type, level);
    }

    public ForestryBoat(Level level, double x, double y, double z) {
        this(ArboricultureEntities.BOAT.entityType(), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_WOOD_TYPE, (Object)ForestryWoodType.ACACIA_DESERT.ordinal());
    }

    public double m_6048_() {
        return -0.1;
    }

    public Item m_38369_() {
        return ArboricultureItems.BOAT.item(this.getWoodType());
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
        this.f_38281_ = this.m_20184_().f_82480_;
        if (!this.m_20159_()) {
            Level level = this.m_9236_();
            if (onGround) {
                if (this.f_19789_ > 3.0f) {
                    if (this.f_38279_ != Boat.Status.ON_LAND) {
                        this.m_183634_();
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, this.m_269291_().m_268989_());
                    if (!level.f_46443_ && !this.m_213877_()) {
                        this.m_6074_();
                        if (level.m_46469_().m_46207_(GameRules.f_46137_)) {
                            for (int i = 0; i < 3; ++i) {
                                this.m_19998_((ItemLike)ArboricultureBlocks.PLANKS.get(this.getWoodType()));
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.m_19998_((ItemLike)Items.f_42398_);
                            }
                        }
                    }
                }
                this.m_183634_();
            } else if (!this.canBoatInFluid(level.m_6425_(this.m_20183_().m_7495_())) && y < 0.0) {
                this.f_19789_ -= (float)y;
            }
        }
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128359_("type", this.getWoodType().name());
    }

    protected void m_7378_(CompoundTag nbt) {
        if (nbt.m_128425_("type", 8)) {
            try {
                this.setWoodType(ForestryWoodType.valueOf(nbt.m_128461_("type")));
            }
            catch (IllegalArgumentException e) {
                this.setWoodType(ForestryWoodType.ACACIA_DESERT);
            }
        }
    }

    public void setWoodType(ForestryWoodType woodType) {
        this.f_19804_.m_135381_(DATA_ID_WOOD_TYPE, (Object)woodType.ordinal());
    }

    public ForestryWoodType getWoodType() {
        return ForestryWoodType.VALUES[(Integer)this.f_19804_.m_135370_(DATA_ID_WOOD_TYPE)];
    }
}

