/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.IWoodAccess;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.arboriculture.ForestryWoodType;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.VanillaWoodType;
import forestry.modules.features.FeatureBlockGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public enum WoodAccess implements IWoodAccess
{
    INSTANCE;

    private final WoodMap[] woodMaps = new WoodMap[WoodBlockKind.values().length];
    private final List<IWoodType> registeredWoodTypes = new ArrayList<IWoodType>();
    private final Map<IWoodType, TagKey<Block>> logBlockTags = new HashMap<IWoodType, TagKey<Block>>();
    private final Map<IWoodType, TagKey<Item>> logItemTags = new HashMap<IWoodType, TagKey<Item>>();
    private final Map<IWoodType, TagKey<Block>> fireproofLogBlockTags = new HashMap<IWoodType, TagKey<Block>>();
    private final Map<IWoodType, TagKey<Item>> fireproofLogItemTags = new HashMap<IWoodType, TagKey<Item>>();

    private WoodAccess() {
        WoodBlockKind[] kind = WoodBlockKind.values();
        int length = kind.length;
        for (int i = 0; i < length; ++i) {
            this.woodMaps[i] = new WoodMap(kind[i]);
        }
        this.registerVanilla();
    }

    public <T extends Block> void registerFeatures(FeatureBlockGroup<? extends T, ? extends IWoodType> featureGroup, WoodBlockKind kind) {
        for (Block block : featureGroup.getBlocks()) {
            this.registerWithoutVariants(block, kind);
        }
    }

    private void registerVanilla() {
        this.register(VanillaWoodType.OAK, WoodBlockKind.LOG, false, Blocks.f_49999_.m_49966_(), () -> Items.f_41837_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.LOG, false, Blocks.f_50000_.m_49966_(), () -> Items.f_41838_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.LOG, false, Blocks.f_50001_.m_49966_(), () -> Items.f_41839_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.LOG, false, Blocks.f_50002_.m_49966_(), () -> Items.f_41840_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.LOG, false, Blocks.f_50003_.m_49966_(), () -> Items.f_41841_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.LOG, false, Blocks.f_50004_.m_49966_(), () -> Items.f_41842_);
        this.register(VanillaWoodType.CHERRY, WoodBlockKind.LOG, false, Blocks.f_271170_.m_49966_(), () -> Items.f_271090_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.STRIPPED_LOG, false, Blocks.f_50010_.m_49966_(), () -> Items.f_41845_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.STRIPPED_LOG, false, Blocks.f_50005_.m_49966_(), () -> Items.f_41846_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.STRIPPED_LOG, false, Blocks.f_50006_.m_49966_(), () -> Items.f_41847_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.STRIPPED_LOG, false, Blocks.f_50007_.m_49966_(), () -> Items.f_41848_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.STRIPPED_LOG, false, Blocks.f_50008_.m_49966_(), () -> Items.f_41849_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.STRIPPED_LOG, false, Blocks.f_50009_.m_49966_(), () -> Items.f_41850_);
        this.register(VanillaWoodType.CHERRY, WoodBlockKind.STRIPPED_LOG, false, Blocks.f_271326_.m_49966_(), () -> Items.f_271164_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.WOOD, false, Blocks.f_50011_.m_49966_(), () -> Items.f_41888_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.WOOD, false, Blocks.f_50012_.m_49966_(), () -> Items.f_41889_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.WOOD, false, Blocks.f_50013_.m_49966_(), () -> Items.f_41890_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.WOOD, false, Blocks.f_50014_.m_49966_(), () -> Items.f_41891_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.WOOD, false, Blocks.f_50015_.m_49966_(), () -> Items.f_41892_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.WOOD, false, Blocks.f_50043_.m_49966_(), () -> Items.f_41893_);
        this.register(VanillaWoodType.CHERRY, WoodBlockKind.WOOD, false, Blocks.f_271348_.m_49966_(), () -> Items.f_271302_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.STRIPPED_WOOD, false, Blocks.f_50044_.m_49966_(), () -> Items.f_41880_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.STRIPPED_WOOD, false, Blocks.f_50045_.m_49966_(), () -> Items.f_41881_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.STRIPPED_WOOD, false, Blocks.f_50046_.m_49966_(), () -> Items.f_41882_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.STRIPPED_WOOD, false, Blocks.f_50047_.m_49966_(), () -> Items.f_41883_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.STRIPPED_WOOD, false, Blocks.f_50048_.m_49966_(), () -> Items.f_41884_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.STRIPPED_WOOD, false, Blocks.f_50049_.m_49966_(), () -> Items.f_41885_);
        this.register(VanillaWoodType.CHERRY, WoodBlockKind.STRIPPED_WOOD, false, Blocks.f_271145_.m_49966_(), () -> Items.f_271182_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.PLANKS, false, Blocks.f_50705_.m_49966_(), () -> Items.f_42647_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.PLANKS, false, Blocks.f_50741_.m_49966_(), () -> Items.f_42700_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.PLANKS, false, Blocks.f_50742_.m_49966_(), () -> Items.f_42753_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.PLANKS, false, Blocks.f_50743_.m_49966_(), () -> Items.f_42794_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.PLANKS, false, Blocks.f_50744_.m_49966_(), () -> Items.f_42795_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.PLANKS, false, Blocks.f_50745_.m_49966_(), () -> Items.f_42796_);
        this.register(VanillaWoodType.CHERRY, WoodBlockKind.PLANKS, false, Blocks.f_271304_.m_49966_(), () -> Items.f_271154_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.SLAB, false, Blocks.f_50398_.m_49966_(), () -> Items.f_41914_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.SLAB, false, Blocks.f_50399_.m_49966_(), () -> Items.f_41915_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.SLAB, false, Blocks.f_50400_.m_49966_(), () -> Items.f_41916_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.SLAB, false, Blocks.f_50401_.m_49966_(), () -> Items.f_41917_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.SLAB, false, Blocks.f_50402_.m_49966_(), () -> Items.f_41918_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.SLAB, false, Blocks.f_50403_.m_49966_(), () -> Items.f_41919_);
        this.register(VanillaWoodType.CHERRY, WoodBlockKind.SLAB, false, Blocks.f_271301_.m_49966_(), () -> Items.f_271349_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.FENCE, false, Blocks.f_50132_.m_49966_(), () -> Items.f_42038_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.FENCE, false, Blocks.f_50479_.m_49966_(), () -> Items.f_42039_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.FENCE, false, Blocks.f_50480_.m_49966_(), () -> Items.f_42040_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.FENCE, false, Blocks.f_50481_.m_49966_(), () -> Items.f_42041_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.FENCE, false, Blocks.f_50482_.m_49966_(), () -> Items.f_42042_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.FENCE, false, Blocks.f_50483_.m_49966_(), () -> Items.f_42043_);
        this.register(VanillaWoodType.CHERRY, WoodBlockKind.FENCE, false, Blocks.f_271219_.m_49966_(), () -> Items.f_271316_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.FENCE_GATE, false, Blocks.f_50192_.m_49966_(), () -> Items.f_42030_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.FENCE_GATE, false, Blocks.f_50474_.m_49966_(), () -> Items.f_42031_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.FENCE_GATE, false, Blocks.f_50475_.m_49966_(), () -> Items.f_42032_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.FENCE_GATE, false, Blocks.f_50476_.m_49966_(), () -> Items.f_42033_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.FENCE_GATE, false, Blocks.f_50477_.m_49966_(), () -> Items.f_42034_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.FENCE_GATE, false, Blocks.f_50478_.m_49966_(), () -> Items.f_42035_);
        this.register(VanillaWoodType.CHERRY, WoodBlockKind.FENCE_GATE, false, Blocks.f_271274_.m_49966_(), () -> Items.f_271205_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.STAIRS, false, Blocks.f_50086_.m_49966_(), () -> Items.f_42008_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.STAIRS, false, Blocks.f_50269_.m_49966_(), () -> Items.f_42111_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.STAIRS, false, Blocks.f_50270_.m_49966_(), () -> Items.f_42112_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.STAIRS, false, Blocks.f_50271_.m_49966_(), () -> Items.f_42113_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.STAIRS, false, Blocks.f_50372_.m_49966_(), () -> Items.f_42202_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.STAIRS, false, Blocks.f_50373_.m_49966_(), () -> Items.f_42203_);
        this.register(VanillaWoodType.CHERRY, WoodBlockKind.STAIRS, false, Blocks.f_271206_.m_49966_(), () -> Items.f_271397_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.DOOR, false, Blocks.f_50154_.m_49966_(), () -> Items.f_42342_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.DOOR, false, Blocks.f_50484_.m_49966_(), () -> Items.f_42343_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.DOOR, false, Blocks.f_50485_.m_49966_(), () -> Items.f_42344_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.DOOR, false, Blocks.f_50486_.m_49966_(), () -> Items.f_42345_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.DOOR, false, Blocks.f_50487_.m_49966_(), () -> Items.f_42346_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.DOOR, false, Blocks.f_50488_.m_49966_(), () -> Items.f_42347_);
        this.register(VanillaWoodType.CHERRY, WoodBlockKind.DOOR, false, Blocks.f_271169_.m_49966_(), () -> Items.f_271459_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.TRAPDOOR, false, Blocks.f_50216_.m_49966_(), () -> Items.f_42056_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.TRAPDOOR, false, Blocks.f_50217_.m_49966_(), () -> Items.f_42057_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.TRAPDOOR, false, Blocks.f_50218_.m_49966_(), () -> Items.f_42058_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.TRAPDOOR, false, Blocks.f_50219_.m_49966_(), () -> Items.f_42059_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.TRAPDOOR, false, Blocks.f_50220_.m_49966_(), () -> Items.f_42060_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.TRAPDOOR, false, Blocks.f_50221_.m_49966_(), () -> Items.f_42061_);
        this.register(VanillaWoodType.CHERRY, WoodBlockKind.TRAPDOOR, false, Blocks.f_271350_.m_49966_(), () -> Items.f_271114_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.SIGN, false, Blocks.f_50095_.m_49966_(), () -> Items.f_42438_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.SIGN, false, Blocks.f_50149_.m_49966_(), () -> Items.f_42439_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.SIGN, false, Blocks.f_50150_.m_49966_(), () -> Items.f_42440_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.SIGN, false, Blocks.f_50152_.m_49966_(), () -> Items.f_42441_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.SIGN, false, Blocks.f_50151_.m_49966_(), () -> Items.f_42442_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.SIGN, false, Blocks.f_50153_.m_49966_(), () -> Items.f_42443_);
        this.register(VanillaWoodType.CHERRY, WoodBlockKind.SIGN, false, Blocks.f_271516_.m_49966_(), () -> Items.f_271504_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.WALL_SIGN, false, Blocks.f_50158_.m_49966_(), () -> Items.f_42438_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.WALL_SIGN, false, Blocks.f_50159_.m_49966_(), () -> Items.f_42439_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.WALL_SIGN, false, Blocks.f_50160_.m_49966_(), () -> Items.f_42440_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.WALL_SIGN, false, Blocks.f_50162_.m_49966_(), () -> Items.f_42441_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.WALL_SIGN, false, Blocks.f_50161_.m_49966_(), () -> Items.f_42442_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.WALL_SIGN, false, Blocks.f_50163_.m_49966_(), () -> Items.f_42443_);
        this.register(VanillaWoodType.CHERRY, WoodBlockKind.WALL_SIGN, false, Blocks.f_271107_.m_49966_(), () -> Items.f_271504_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.HANGING_SIGN, false, Blocks.f_244319_.m_49966_(), () -> Items.f_244406_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.HANGING_SIGN, false, Blocks.f_244633_.m_49966_(), () -> Items.f_243963_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.HANGING_SIGN, false, Blocks.f_243890_.m_49966_(), () -> Items.f_244431_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.HANGING_SIGN, false, Blocks.f_244263_.m_49966_(), () -> Items.f_243722_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.HANGING_SIGN, false, Blocks.f_243716_.m_49966_(), () -> Items.f_244440_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.HANGING_SIGN, false, Blocks.f_243960_.m_49966_(), () -> Items.f_243805_);
        this.register(VanillaWoodType.CHERRY, WoodBlockKind.HANGING_SIGN, false, Blocks.f_271116_.m_49966_(), () -> Items.f_271501_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.WALL_HANGING_SIGN, false, Blocks.f_244093_.m_49966_(), () -> Items.f_244406_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.WALL_HANGING_SIGN, false, Blocks.f_243895_.m_49966_(), () -> Items.f_243963_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.WALL_HANGING_SIGN, false, Blocks.f_244296_.m_49966_(), () -> Items.f_244431_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.WALL_HANGING_SIGN, false, Blocks.f_243897_.m_49966_(), () -> Items.f_243722_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.WALL_HANGING_SIGN, false, Blocks.f_243773_.m_49966_(), () -> Items.f_244440_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.WALL_HANGING_SIGN, false, Blocks.f_243998_.m_49966_(), () -> Items.f_243805_);
        this.register(VanillaWoodType.CHERRY, WoodBlockKind.WALL_HANGING_SIGN, false, Blocks.f_271427_.m_49966_(), () -> Items.f_271501_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.BUTTON, false, Blocks.f_50251_.m_49966_(), () -> Items.f_42084_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.BUTTON, false, Blocks.f_50252_.m_49966_(), () -> Items.f_42085_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.BUTTON, false, Blocks.f_50253_.m_49966_(), () -> Items.f_42086_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.BUTTON, false, Blocks.f_50254_.m_49966_(), () -> Items.f_42087_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.BUTTON, false, Blocks.f_50308_.m_49966_(), () -> Items.f_42088_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.BUTTON, false, Blocks.f_50309_.m_49966_(), () -> Items.f_42089_);
        this.register(VanillaWoodType.CHERRY, WoodBlockKind.BUTTON, false, Blocks.f_271396_.m_49966_(), () -> Items.f_271474_);
        this.register(VanillaWoodType.OAK, WoodBlockKind.PRESSURE_PLATE, false, Blocks.f_50167_.m_49966_(), () -> Items.f_41968_);
        this.register(VanillaWoodType.SPRUCE, WoodBlockKind.PRESSURE_PLATE, false, Blocks.f_50168_.m_49966_(), () -> Items.f_41969_);
        this.register(VanillaWoodType.BIRCH, WoodBlockKind.PRESSURE_PLATE, false, Blocks.f_50169_.m_49966_(), () -> Items.f_41970_);
        this.register(VanillaWoodType.JUNGLE, WoodBlockKind.PRESSURE_PLATE, false, Blocks.f_50170_.m_49966_(), () -> Items.f_41971_);
        this.register(VanillaWoodType.ACACIA, WoodBlockKind.PRESSURE_PLATE, false, Blocks.f_50171_.m_49966_(), () -> Items.f_41972_);
        this.register(VanillaWoodType.DARK_OAK, WoodBlockKind.PRESSURE_PLATE, false, Blocks.f_50172_.m_49966_(), () -> Items.f_41973_);
        this.register(VanillaWoodType.CHERRY, WoodBlockKind.PRESSURE_PLATE, false, Blocks.f_271227_.m_49966_(), () -> Items.f_271282_);
        this.registerLogTag(VanillaWoodType.OAK, false, (TagKey<Block>)BlockTags.f_13108_, (TagKey<Item>)ItemTags.f_13184_);
        this.registerLogTag(VanillaWoodType.SPRUCE, false, (TagKey<Block>)BlockTags.f_13112_, (TagKey<Item>)ItemTags.f_13188_);
        this.registerLogTag(VanillaWoodType.BIRCH, false, (TagKey<Block>)BlockTags.f_13109_, (TagKey<Item>)ItemTags.f_13185_);
        this.registerLogTag(VanillaWoodType.JUNGLE, false, (TagKey<Block>)BlockTags.f_13111_, (TagKey<Item>)ItemTags.f_13187_);
        this.registerLogTag(VanillaWoodType.ACACIA, false, (TagKey<Block>)BlockTags.f_13110_, (TagKey<Item>)ItemTags.f_13186_);
        this.registerLogTag(VanillaWoodType.DARK_OAK, false, (TagKey<Block>)BlockTags.f_13107_, (TagKey<Item>)ItemTags.f_13183_);
        this.registerLogTag(VanillaWoodType.CHERRY, false, (TagKey<Block>)BlockTags.f_271212_, (TagKey<Item>)ItemTags.f_271202_);
        for (VanillaWoodType vanillaWoodType : VanillaWoodType.VALUES) {
            this.registerLogTag(vanillaWoodType, true, vanillaWoodType.fireproofBlockTag, vanillaWoodType.fireproofItemTag);
        }
        for (Enum enum_ : ForestryWoodType.VALUES) {
            this.registerLogTag((IWoodType)((Object)enum_), false, ((ForestryWoodType)enum_).blockTag, ((ForestryWoodType)enum_).itemTag);
            this.registerLogTag((IWoodType)((Object)enum_), true, ((ForestryWoodType)enum_).fireproofBlockTag, ((ForestryWoodType)enum_).fireproofItemTag);
        }
    }

    private <T extends Block> void registerWithoutVariants(T woodTyped, WoodBlockKind woodBlockKind) {
        boolean fireproof = ((IWoodTyped)woodTyped).isFireproof();
        BlockState blockState = woodTyped.m_49966_();
        IWoodType woodType = ((IWoodTyped)woodTyped).getWoodType();
        Supplier<Item> itemStack = () -> woodTyped.m_5456_();
        this.register(woodType, woodBlockKind, fireproof, blockState, itemStack);
    }

    @Override
    public void register(IWoodType woodType, WoodBlockKind woodBlockKind, boolean fireproof, BlockState blockState, Supplier<Item> itemStack) {
        if (WoodAccess.isNonBurning(woodBlockKind)) {
            fireproof = true;
        }
        WoodMap woodMap = this.woodMaps[woodBlockKind.ordinal()];
        if (!this.registeredWoodTypes.contains(woodType)) {
            this.registeredWoodTypes.add(woodType);
        }
        woodMap.getItem(fireproof).put(woodType, itemStack);
        woodMap.getBlock(fireproof).put(woodType, blockState);
    }

    @Override
    public void registerLogTag(IWoodType woodType, boolean fireproof, TagKey<Block> logBlockTag, TagKey<Item> logItemTag) {
        if (fireproof) {
            this.fireproofLogBlockTags.put(woodType, logBlockTag);
            this.fireproofLogItemTags.put(woodType, logItemTag);
        } else {
            this.logBlockTags.put(woodType, logBlockTag);
            this.logItemTags.put(woodType, logItemTag);
        }
    }

    @Override
    public ItemStack getStack(IWoodType woodType, WoodBlockKind woodBlockKind, boolean fireproof) {
        WoodMap woodMap;
        Supplier<Item> itemStack;
        if (WoodAccess.isNonBurning(woodBlockKind)) {
            fireproof = true;
        }
        if ((itemStack = (woodMap = this.woodMaps[woodBlockKind.ordinal()]).getItem(fireproof).get(woodType)) == null) {
            String errMessage = String.format("No stack found for %s %s %s", woodType, woodMap.getName(), fireproof ? "fireproof" : "non-fireproof");
            throw new IllegalStateException(errMessage);
        }
        return new ItemStack((ItemLike)itemStack.get());
    }

    @Override
    public BlockState getBlock(IWoodType woodType, WoodBlockKind woodBlockKind, boolean fireproof) {
        WoodMap woodMap;
        BlockState blockState;
        if (WoodAccess.isNonBurning(woodBlockKind)) {
            fireproof = true;
        }
        if ((blockState = (woodMap = this.woodMaps[woodBlockKind.ordinal()]).getBlock(fireproof).get(woodType)) == null) {
            String errMessage = String.format("No block found for %s %s %s", woodType, woodMap.getName(), fireproof ? "fireproof" : "non-fireproof");
            throw new IllegalStateException(errMessage);
        }
        return blockState;
    }

    @Override
    public TagKey<Block> getLogBlockTag(IWoodType kind, boolean fireproof) {
        return (fireproof ? this.fireproofLogBlockTags : this.logBlockTags).get(kind);
    }

    @Override
    public TagKey<Item> getLogItemTag(IWoodType kind, boolean fireproof) {
        return (fireproof ? this.fireproofLogItemTags : this.logItemTags).get(kind);
    }

    private static boolean isNonBurning(WoodBlockKind kind) {
        return kind == WoodBlockKind.DOOR || kind == WoodBlockKind.TRAPDOOR || kind == WoodBlockKind.BUTTON || kind == WoodBlockKind.PRESSURE_PLATE || kind == WoodBlockKind.SIGN || kind == WoodBlockKind.WALL_SIGN || kind == WoodBlockKind.HANGING_SIGN || kind == WoodBlockKind.WALL_HANGING_SIGN;
    }

    @Override
    public List<IWoodType> getRegisteredWoodTypes() {
        return this.registeredWoodTypes;
    }

    private static class WoodMap {
        private final Map<IWoodType, Supplier<Item>> normalItems = new HashMap<IWoodType, Supplier<Item>>();
        private final Map<IWoodType, Supplier<Item>> fireproofItems = new HashMap<IWoodType, Supplier<Item>>();
        private final Map<IWoodType, BlockState> normalBlocks = new HashMap<IWoodType, BlockState>();
        private final Map<IWoodType, BlockState> fireproofBlocks = new HashMap<IWoodType, BlockState>();
        private final WoodBlockKind woodBlockKind;

        public WoodMap(WoodBlockKind woodBlockKind) {
            this.woodBlockKind = woodBlockKind;
        }

        public String getName() {
            return this.woodBlockKind.name();
        }

        public Map<IWoodType, Supplier<Item>> getItem(boolean fireproof) {
            return fireproof ? this.fireproofItems : this.normalItems;
        }

        public Map<IWoodType, BlockState> getBlock(boolean fireproof) {
            return fireproof ? this.fireproofBlocks : this.normalBlocks;
        }
    }
}

