/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.villagers;

import com.google.common.collect.ImmutableSet;
import forestry.api.ForestryTags;
import forestry.api.apiculture.ForestryBeeSpecies;
import forestry.api.apiculture.genetics.BeeLifeStage;
import forestry.api.modules.ForestryModuleIds;
import forestry.apiculture.blocks.BlockTypeApiculture;
import forestry.apiculture.features.ApicultureBlocks;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiculture.items.EnumPropolis;
import forestry.core.blocks.BlockCore;
import forestry.core.blocks.BlockTypeCoreTesr;
import forestry.core.features.CoreBlocks;
import forestry.core.registration.VillagerTrade;
import forestry.core.utils.SpeciesUtil;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureProvider;
import forestry.modules.features.IFeatureRegistry;
import forestry.modules.features.ModFeatureRegistry;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.server.ServerLifecycleHooks;

@FeatureProvider
public class ApicultureVillagers {
    private static final IFeatureRegistry REGISTRY = ModFeatureRegistry.get(ForestryModuleIds.APICULTURE);
    private static final DeferredRegister<PoiType> POINTS_OF_INTEREST = REGISTRY.getRegistry(Registries.f_256805_);
    private static final DeferredRegister<VillagerProfession> PROFESSIONS = REGISTRY.getRegistry(Registries.f_256749_);
    public static final RegistryObject<PoiType> POI_ESCRITOIRE = POINTS_OF_INTEREST.register("escritoire", () -> new PoiType(Set.copyOf(((BlockCore)((Object)((Object)((FeatureBlock)CoreBlocks.BASE.get(BlockTypeCoreTesr.ESCRITOIRE)).block()))).m_49965_().m_61056_()), 1, 1));
    public static final RegistryObject<VillagerProfession> PROF_BEEKEEPER = PROFESSIONS.register("beekeeper", () -> {
        ResourceKey key = Objects.requireNonNull(POI_ESCRITOIRE.getKey());
        Predicate<Holder> jobSitePredicate = e -> e.m_203565_(key);
        return new VillagerProfession("beekeeper", jobSitePredicate, jobSitePredicate, ImmutableSet.of(), ImmutableSet.of(), SoundEvents.f_12571_);
    });

    public static void villagerTrades(VillagerTradesEvent event) {
        if (event.getType().equals(PROF_BEEKEEPER.get())) {
            Int2ObjectMap trades = event.getTrades();
            List<Item> combs = ((HolderSet.Named)ServerLifecycleHooks.getCurrentServer().m_206579_().m_175515_(Registries.f_256913_).m_203431_(ForestryTags.Items.VILLAGE_COMBS).get()).m_203614_().map(Holder::get).toList();
            ((List)trades.get(1)).add(new GiveHoneyCombForItem(combs, Items.f_42405_, new VillagerTrade.PriceInterval(2, 4), new VillagerTrade.PriceInterval(8, 12), 8, 2, 0.0f));
            ((List)trades.get(1)).add(new GiveHoneyCombForItem(combs, Items.f_42619_, new VillagerTrade.PriceInterval(2, 4), new VillagerTrade.PriceInterval(8, 12), 8, 2, 0.0f));
            ((List)trades.get(1)).add(new GiveHoneyCombForItem(combs, Items.f_42620_, new VillagerTrade.PriceInterval(2, 4), new VillagerTrade.PriceInterval(8, 12), 8, 2, 0.0f));
            ((List)trades.get(2)).add(new VillagerTrade.GiveItemForEmeralds(ApicultureItems.SMOKER.item(), new VillagerTrade.PriceInterval(1, 1), new VillagerTrade.PriceInterval(1, 4), 8, 6));
            ((List)trades.get(2)).add(new GiveDroneForItems(ApicultureItems.PROPOLIS.stack(EnumPropolis.NORMAL).m_41720_(), new VillagerTrade.PriceInterval(2, 4), new VillagerTrade.PriceInterval(1, 1), 8, 6, 0.0f));
            ((List)trades.get(3)).add(new VillagerTrade.GiveEmeraldForItem(ApicultureItems.BEE_PRINCESS.item(), new VillagerTrade.PriceInterval(1, 1), new VillagerTrade.PriceInterval(1, 1), 8, 10));
            ((List)trades.get(3)).add(new VillagerTrade.GiveItemForEmeralds(ApicultureItems.FRAME_PROVEN.item(), new VillagerTrade.PriceInterval(1, 2), new VillagerTrade.PriceInterval(1, 6), 8, 10));
            ((List)trades.get(3)).add(new VillagerTrade.GiveItemForLogAndEmerald(new VillagerTrade.PriceInterval(32, 64), new VillagerTrade.PriceInterval(16, 32), ((FeatureBlock)ApicultureBlocks.BASE.get(BlockTypeApiculture.APIARY)).stack().m_41720_(), new VillagerTrade.PriceInterval(1, 1), 8, 10));
            ((List)trades.get(4)).add(new VillagerTrade.GiveItemForItemAndEmerald(ApicultureItems.BEE_PRINCESS.item(), new VillagerTrade.PriceInterval(1, 1), new VillagerTrade.PriceInterval(10, 64), SpeciesUtil.getBeeSpecies(ForestryBeeSpecies.MONASTIC).createStack(BeeLifeStage.DRONE), new VillagerTrade.PriceInterval(1, 1), 8, 15));
            ((List)trades.get(4)).add(new VillagerTrade.GiveItemForTwoItems(ApicultureItems.BEE_DRONE.item(), new VillagerTrade.PriceInterval(1, 1), Items.f_42545_, new VillagerTrade.PriceInterval(12, 16), SpeciesUtil.getBeeSpecies(ForestryBeeSpecies.ENDED).createStack(BeeLifeStage.DRONE), new VillagerTrade.PriceInterval(1, 1), 8, 15));
        }
    }

    public record GiveHoneyCombForItem(List<Item> itemHoneyCombs, Item buying, VillagerTrade.PriceInterval sellingPriceInfo, VillagerTrade.PriceInterval buyingPriceInfo, int maxUses, int xp, float priceMult) implements VillagerTrades.ItemListing
    {
        public MerchantOffer m_213663_(Entity trader, RandomSource rand) {
            ItemStack buy = new ItemStack((ItemLike)this.buying, this.buyingPriceInfo.getPrice(rand));
            ItemStack sell = new ItemStack((ItemLike)this.itemHoneyCombs.get(rand.m_188503_(this.itemHoneyCombs.size())), this.sellingPriceInfo.getPrice(rand));
            return new MerchantOffer(buy, sell, this.maxUses, this.xp, this.priceMult);
        }
    }

    public record GiveDroneForItems(Item buying, VillagerTrade.PriceInterval buyingPriceInfo, VillagerTrade.PriceInterval sellingPriceInfo, int maxUses, int xp, float priceMult) implements VillagerTrades.ItemListing
    {
        public MerchantOffer m_213663_(Entity trader, RandomSource rand) {
            ResourceLocation[] forestryMundane = new ResourceLocation[]{ForestryBeeSpecies.FOREST, ForestryBeeSpecies.MEADOWS, ForestryBeeSpecies.MODEST, ForestryBeeSpecies.WINTRY, ForestryBeeSpecies.TROPICAL, ForestryBeeSpecies.MARSHY};
            ItemStack randomHiveDrone = SpeciesUtil.getBeeSpecies(forestryMundane[rand.m_188503_(forestryMundane.length)]).createStack(BeeLifeStage.DRONE);
            randomHiveDrone.m_41764_(this.sellingPriceInfo.getPrice(rand));
            return new MerchantOffer(new ItemStack((ItemLike)this.buying, this.buyingPriceInfo.getPrice(rand)), randomHiveDrone, this.maxUses, this.xp, this.priceMult);
        }
    }
}

