/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.climate.IClimateProvider;
import forestry.api.core.HumidityType;
import forestry.api.core.IErrorLogic;
import forestry.api.core.TemperatureType;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.apiculture.blocks.BlockAlveary;
import forestry.apiculture.blocks.BlockAlvearyType;
import forestry.apiculture.features.ApicultureBlocks;
import forestry.apiculture.gui.ContainerAlveary;
import forestry.apiculture.multiblock.MultiblockLogicAlveary;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.MultiblockTileEntityForestry;
import forestry.core.network.IStreamableGui;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.tiles.ITitled;
import forestry.modules.features.FeatureBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileAlveary
extends MultiblockTileEntityForestry<MultiblockLogicAlveary>
implements IBeeHousing,
IAlvearyComponent<MultiblockLogicAlveary>,
IOwnedTile,
IStreamableGui,
ITitled,
IClimateProvider {
    private final String translationKey;

    public TileAlveary(BlockAlvearyType type, BlockPos pos, BlockState state) {
        this(type.getTileType().tileType(), ((FeatureBlock)ApicultureBlocks.ALVEARY.get(type)).getTranslationKey(), pos, state);
    }

    public TileAlveary(BlockEntityType<?> type, String translationKey, BlockPos pos, BlockState state) {
        super(type, pos, state, new MultiblockLogicAlveary());
        this.translationKey = translationKey;
    }

    @Override
    public void onMachineAssembled(IMultiblockController multiblockController, BlockPos minCoord, BlockPos maxCoord) {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof BlockAlveary) {
            BlockAlveary alveary = (BlockAlveary)block;
            this.f_58857_.m_46597_(this.m_58899_(), alveary.getNewState(this));
        }
    }

    @Override
    public void onMachineBroken() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof BlockAlveary) {
            BlockAlveary alveary = (BlockAlveary)block;
            this.f_58857_.m_46597_(this.m_58899_(), alveary.getNewState(this));
        }
        this.m_6596_();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing != null) {
                return LazyOptional.of(() -> new SidedInvWrapper((WorldlyContainer)this.getInternalInventory(), facing)).cast();
            }
            return LazyOptional.of(() -> new InvWrapper((Container)this.getInternalInventory())).cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public Holder<Biome> getBiome() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBiome();
    }

    @Override
    public Iterable<IBeeModifier> getBeeModifiers() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBeeModifiers();
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBeeListeners();
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBeeInventory();
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBeekeepingLogic();
    }

    @Override
    public Vec3 getBeeFXCoordinates() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBeeFXCoordinates();
    }

    @Override
    public TemperatureType temperature() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().temperature();
    }

    @Override
    public HumidityType humidity() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().humidity();
    }

    @Override
    public int getBlockLightValue() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBlockLightValue();
    }

    @Override
    public boolean canBlockSeeTheSky() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().canBlockSeeTheSky();
    }

    @Override
    public boolean isRaining() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().isRaining();
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getErrorLogic();
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getOwnerHandler();
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getInternalInventory();
    }

    @Override
    public Component getTitle() {
        return Component.m_237115_((String)this.translationKey);
    }

    @Override
    public void writeGuiData(FriendlyByteBuf data) {
        ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().writeGuiData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readGuiData(FriendlyByteBuf data) {
        ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().readGuiData(data);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ContainerAlveary(windowId, player.m_150109_(), this);
    }

    public Component m_5446_() {
        return this.getTitle();
    }
}

