/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.apiculture.genetics.IBeeSpecies;
import forestry.api.apiculture.hives.IHiveFrame;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutation;
import forestry.core.items.ItemForestry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemCreativeHiveFrame
extends ItemForestry
implements IHiveFrame {
    public static final String NBT_FORCE_MUTATIONS = "force_mutations";

    public ItemCreativeHiveFrame() {
        super(new Item.Properties().m_41497_(Rarity.EPIC));
    }

    @Override
    public ItemStack frameUsed(IBeeHousing housing, ItemStack frame, IBee queen, int wear) {
        return frame;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag advanced) {
        super.m_7373_(stack, world, tooltip, advanced);
        tooltip.add((Component)Component.m_237110_((String)"item.forestry.bee.modifier.production", (Object[])new Object[]{Float.valueOf(10000.0f)}));
        tooltip.add((Component)Component.m_237110_((String)"item.forestry.bee.modifier.genetic.decay", (Object[])new Object[]{Float.valueOf(0.0f)}));
        if (ItemCreativeHiveFrame.hasForceMutations(stack)) {
            tooltip.add((Component)Component.m_237113_((String)"Maximum mutation chances").m_130940_(ChatFormatting.LIGHT_PURPLE));
        } else {
            tooltip.add((Component)Component.m_237113_((String)"Base mutation chances").m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    public IBeeModifier getBeeModifier(ItemStack frame) {
        return ItemCreativeHiveFrame.hasForceMutations(frame) ? Modifier.FORCE_MUTATIONS : Modifier.BASE_MUTATIONS;
    }

    public static boolean hasForceMutations(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128441_(NBT_FORCE_MUTATIONS);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Modifier implements IBeeModifier
    {
        BASE_MUTATIONS,
        FORCE_MUTATIONS{

            @Override
            public float modifyMutationChance(IGenome genome, IGenome mate, IMutation<IBeeSpecies> mutation, float currentChance) {
                return 100.0f;
            }
        };

        private static final float PRODUCTION = 10000.0f;
        private static final float POLLINATION = 100.0f;
        private static final float MUTATION = 100.0f;
        private static final float GENETIC_DECAY = 0.0f;

        @Override
        public float modifyAging(IGenome genome, @Nullable IGenome mate, float currentAging) {
            return -1.0f;
        }

        @Override
        public float modifyProductionSpeed(IGenome genome, float currentSpeed) {
            return 10000.0f;
        }

        @Override
        public float modifyPollination(IGenome genome, float currentPollination) {
            return 100.0f;
        }

        @Override
        public float modifyGeneticDecay(IGenome genome, float currentDecay) {
            return 0.0f;
        }

        @Override
        public boolean isSealed() {
            return true;
        }

        @Override
        public boolean isAlwaysActive(IGenome genome) {
            return true;
        }

        @Override
        public boolean isSunlightSimulated() {
            return true;
        }

        @Override
        public boolean isHellish() {
            return true;
        }
    }
}

