/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.genetics.BeeLifeStage;
import forestry.api.apiculture.genetics.IBeeSpeciesType;
import forestry.api.genetics.ILifeStage;
import forestry.core.inventory.InventoryAdapterRestricted;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.SlotUtil;
import forestry.core.utils.SpeciesUtil;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public class InventoryBeeHousing
extends InventoryAdapterRestricted
implements IBeeHousingInventory {
    public static final int SLOT_QUEEN = 0;
    public static final int SLOT_DRONE = 1;
    public static final int SLOT_PRODUCT_1 = 2;
    public static final int SLOT_PRODUCT_COUNT = 7;

    public InventoryBeeHousing(int size) {
        super(size, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack stack) {
        ILifeStage beeType = ((IBeeSpeciesType)SpeciesUtil.BEE_TYPE.get()).getLifeStage(stack);
        if (slotIndex == 0) {
            return beeType == BeeLifeStage.QUEEN || beeType == BeeLifeStage.PRINCESS;
        }
        if (slotIndex == 1) {
            return beeType == BeeLifeStage.DRONE;
        }
        return false;
    }

    @Override
    public boolean m_7157_(int slotIndex, ItemStack itemstack, Direction side) {
        if (!super.m_7157_(slotIndex, itemstack, side)) {
            return false;
        }
        return SlotUtil.isSlotInRange(slotIndex, 2, 7);
    }

    @Override
    public final ItemStack getQueen() {
        return this.m_8020_(0);
    }

    @Override
    public final ItemStack getDrone() {
        return this.m_8020_(1);
    }

    @Override
    public final void setQueen(ItemStack stack) {
        this.m_6836_(0, stack);
    }

    @Override
    public final void setDrone(ItemStack stack) {
        this.m_6836_(1, stack);
    }

    @Override
    public final boolean addProduct(ItemStack product, boolean all) {
        return InventoryUtil.tryAddStack((Container)this, product, 2, 7, all, true);
    }
}

