/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.plugin;

import forestry.api.genetics.IGenome;
import forestry.api.genetics.alleles.AllelePair;
import forestry.api.genetics.alleles.ForestryAlleles;
import forestry.api.genetics.alleles.IAllele;
import forestry.api.genetics.alleles.IBooleanChromosome;
import forestry.api.genetics.alleles.IChromosome;

public interface IGenomeBuilder {
    default public void set(IBooleanChromosome chromosome, boolean defaultAllele) {
        this.set(chromosome, defaultAllele ? ForestryAlleles.TRUE : ForestryAlleles.FALSE);
    }

    default public void setUnchecked(IChromosome chromosome, AllelePair allele) {
        this.setActive(chromosome, allele.active());
        this.setInactive(chromosome, allele.inactive());
    }

    public <A extends IAllele> void set(IChromosome<A> var1, A var2);

    public <A extends IAllele> void setActive(IChromosome<A> var1, A var2);

    public <A extends IAllele> void setInactive(IChromosome<A> var1, A var2);

    public IGenome build();

    public boolean isEmpty();

    public void setRemainingDefault();
}

