/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.core;

import forestry.api.ForestryTags;
import forestry.api.client.ForestrySprites;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;

public enum TemperatureType {
    ICY(ForestryTags.Biomes.ICY_TEMPERATURE, ForestrySprites.HABITAT_SNOW, 0xAAFFF0),
    COLD(ForestryTags.Biomes.COLD_TEMPERATURE, ForestrySprites.HABITAT_TAIGA, 7527927),
    NORMAL(ForestryTags.Biomes.NORMAL_TEMPERATURE, ForestrySprites.HABITAT_PLAINS, 16764947),
    WARM(ForestryTags.Biomes.WARM_TEMPERATURE, ForestrySprites.HABITAT_JUNGLE, 16484900),
    HOT(ForestryTags.Biomes.HOT_TEMPERATURE, ForestrySprites.HABITAT_DESERT, 14029881),
    HELLISH(ForestryTags.Biomes.HELLISH_TEMPERATURE, ForestrySprites.HABITAT_NETHER, 8454957);

    public static final List<TemperatureType> VALUES;
    public final TagKey<Biome> tag;
    public final ResourceLocation iconTexture;
    public final int color;

    private TemperatureType(TagKey<Biome> tag, ResourceLocation iconSprite, int color) {
        this.tag = tag;
        this.iconTexture = iconSprite;
        this.color = color;
    }

    public TemperatureType up() {
        return this.up(1);
    }

    public TemperatureType up(int steps) {
        return VALUES.get(Mth.m_14045_((int)(this.ordinal() + steps), (int)0, (int)5));
    }

    public TemperatureType down() {
        return this.down(1);
    }

    public TemperatureType down(int steps) {
        return VALUES.get(Mth.m_14045_((int)(this.ordinal() - steps), (int)0, (int)5));
    }

    public boolean isWarmerOrEqual(TemperatureType other) {
        return this.ordinal() >= other.ordinal();
    }

    public boolean isCoolerOrEqual(TemperatureType other) {
        return this.ordinal() <= other.ordinal();
    }

    public static TemperatureType getFromValue(float baseTemperature) {
        if (baseTemperature > 1.0f) {
            return HOT;
        }
        if (baseTemperature > 0.85f) {
            return WARM;
        }
        if (baseTemperature > 0.35f) {
            return NORMAL;
        }
        if (baseTemperature > 0.0f) {
            return COLD;
        }
        return ICY;
    }

    static {
        VALUES = List.of(TemperatureType.values());
    }
}

