/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.behaviors.PlacementStrategy;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class FluidPlacementStrategy
implements PlacementStrategy {
    private final ServerLevel level;
    private final BlockPos pos;
    private final Direction side;
    private final Set<Fluid> blocked = new HashSet<Fluid>();
    private long lastEffect;

    public FluidPlacementStrategy(ServerLevel level, BlockPos pos, Direction side, BlockEntity host, @Nullable UUID owningPlayerId) {
        this.level = level;
        this.pos = pos;
        this.side = side;
    }

    @Override
    public void clearBlocked() {
        this.blocked.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long placeInWorld(AEKey f, long amount, Actionable type, boolean placeAsEntity) {
        if (placeAsEntity) return 0L;
        if (!(f instanceof AEFluidKey)) return 0L;
        AEFluidKey fluidKey = (AEFluidKey)f;
        if (amount < 1000L) {
            return 0L;
        }
        Fluid fluid = fluidKey.getFluid();
        if (this.blocked.contains(fluid)) {
            return 0L;
        }
        if (fluidKey.hasTag()) {
            return 0L;
        }
        BlockState state = this.level.m_8055_(this.pos);
        if (!this.canPlace((Level)this.level, state, this.pos, fluid)) {
            this.blocked.add(fluid);
            return 0L;
        }
        if (type != Actionable.MODULATE) return 1000L;
        if (this.level.m_6042_().f_63857_() && fluid.m_205067_(FluidTags.f_13131_)) {
            this.playEvaporationEffect((Level)this.level, this.pos);
            return 1000L;
        }
        Block block = state.m_60734_();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer liquidBlockContainer = (LiquidBlockContainer)block;
            if (fluid == Fluids.f_76193_) {
                liquidBlockContainer.m_7361_((LevelAccessor)this.level, this.pos, state, ((FlowingFluid)fluid).m_76068_(false));
                this.playEmptySound((Level)this.level, this.pos, fluid);
                return 1000L;
            }
        }
        if (state.m_60722_(fluid) && !state.m_278721_()) {
            this.level.m_46961_(this.pos, true);
        }
        if (!this.level.m_7731_(this.pos, fluid.m_76145_().m_76188_(), 11) && !state.m_60819_().m_76170_()) {
            return 0L;
        }
        this.playEmptySound((Level)this.level, this.pos, fluid);
        return 1000L;
    }

    private void playEmptySound(Level level, BlockPos pos, Fluid fluid) {
        if (this.throttleEffect()) {
            return;
        }
        SoundEvent soundEvent = fluid.m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
        level.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_220407_(GameEvent.f_157769_, pos, GameEvent.Context.m_223719_(null, null));
    }

    private void playEvaporationEffect(Level level, BlockPos pos) {
        if (this.throttleEffect()) {
            return;
        }
        level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_() + Math.random(), (double)pos.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    private boolean canPlace(Level level, BlockState state, BlockPos pos, Fluid fluid) {
        LiquidBlockContainer liquidBlockContainer;
        Block block;
        if (!(fluid instanceof FlowingFluid)) {
            return false;
        }
        if (state == fluid.m_76145_().m_76188_()) {
            return false;
        }
        return state.m_60795_() || state.m_60722_(fluid) || (block = state.m_60734_()) instanceof LiquidBlockContainer && (liquidBlockContainer = (LiquidBlockContainer)block).m_6044_((BlockGetter)level, pos, state, fluid);
    }

    protected final boolean throttleEffect() {
        long now = System.currentTimeMillis();
        if (now < this.lastEffect + 250L) {
            return true;
        }
        this.lastEffect = now;
        return false;
    }
}

