/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.storage;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.implementations.blockentities.IColorableBlockEntity;
import appeng.api.implementations.blockentities.IMEChest;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.events.GridPowerStorageStateChanged;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageCells;
import appeng.api.storage.StorageHelper;
import appeng.api.storage.SupplierStorage;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ICellGuiHandler;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.StorageCell;
import appeng.api.util.AEColor;
import appeng.api.util.IConfigManager;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.blockentity.grid.AENetworkPowerBlockEntity;
import appeng.capabilities.Capabilities;
import appeng.core.definitions.AEBlocks;
import appeng.helpers.IPriorityHost;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.DelegatingMEInventory;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.implementations.ChestMenu;
import appeng.menu.locator.MenuLocators;
import appeng.util.ConfigManager;
import appeng.util.Platform;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.CombinedInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChestBlockEntity
extends AENetworkPowerBlockEntity
implements IMEChest,
ITerminalHost,
IPriorityHost,
IColorableBlockEntity,
ServerTickingBlockEntity,
IStorageProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ChestBlockEntity.class);
    private final AppEngInternalInventory inputInventory = new AppEngInternalInventory(this, 1);
    private final AppEngInternalInventory cellInventory = new AppEngInternalInventory(this, 1);
    private final InternalInventory internalInventory = new CombinedInternalInventory(this.inputInventory, this.cellInventory);
    private final IActionSource mySrc = new MachineSource(this);
    private final IConfigManager config = new ConfigManager(this::saveChanges);
    private int priority = 0;
    private CellState clientCellState = CellState.ABSENT;
    private boolean clientPowered;
    private Item cellItem = Items.f_41852_;
    private boolean wasOnline = false;
    private AEColor paintedColor = AEColor.TRANSPARENT;
    private boolean isCached = false;
    private ChestMonitorHandler cellHandler;
    private IFluidHandler fluidHandler;
    private SupplierStorage supplierStorage;
    private double idlePowerUsage;

    public ChestBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.setInternalMaxPower(PowerMultiplier.CONFIG.multiply(500.0));
        this.getMainNode().addService(IStorageProvider.class, this).setFlags(GridFlags.REQUIRE_CHANNEL);
        this.config.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.config.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        this.config.registerSetting(Settings.TYPE_FILTER, TypeFilter.ALL);
        this.config.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        this.setInternalPublicPowerStorage(true);
        this.setInternalPowerFlow(AccessRestriction.WRITE);
        this.inputInventory.setFilter(new InputInventoryFilter());
        this.cellInventory.setFilter(new CellInventoryFilter());
    }

    public ItemStack getCell() {
        return this.cellInventory.getStackInSlot(0);
    }

    public void setCell(ItemStack stack) {
        this.cellInventory.setItemDirect(0, Objects.requireNonNull(stack));
    }

    @Override
    protected void emitPowerStateEvent(GridPowerStorageStateChanged.PowerEventType x) {
        if (x == GridPowerStorageStateChanged.PowerEventType.RECEIVE_POWER) {
            this.getMainNode().ifPresent(grid -> grid.postEvent(new GridPowerStorageStateChanged(this, GridPowerStorageStateChanged.PowerEventType.RECEIVE_POWER)));
        } else {
            this.recalculateDisplay();
        }
    }

    private void recalculateDisplay() {
        boolean powered;
        boolean changed = false;
        CellState cellState = this.getCellStatus(0);
        if (this.clientCellState != cellState) {
            this.clientCellState = cellState;
            changed = true;
        }
        if (this.clientPowered != (powered = this.isPowered())) {
            this.clientPowered = powered;
            changed = true;
        }
        if (changed) {
            this.markForUpdate();
        }
    }

    @Override
    public int getCellCount() {
        return 1;
    }

    private void updateHandler() {
        if (!this.isCached) {
            this.cellHandler = null;
            this.fluidHandler = null;
            this.supplierStorage = null;
            ItemStack is = this.getCell();
            if (!is.m_41619_()) {
                this.isCached = true;
                StorageCell newCell = StorageCells.getCellInventory(is, this::onCellContentChanged);
                if (newCell != null) {
                    this.idlePowerUsage = 1.0 + newCell.getIdleDrain();
                    this.cellHandler = this.wrap(newCell);
                    this.getMainNode().setIdlePowerUsage(this.idlePowerUsage);
                    if (this.cellHandler != null) {
                        this.fluidHandler = new FluidHandler();
                        this.supplierStorage = new SupplierStorage(() -> this.cellHandler);
                    }
                }
            }
        }
    }

    private ChestMonitorHandler wrap(StorageCell cellInventory) {
        if (cellInventory == null) {
            return null;
        }
        return new ChestMonitorHandler(cellInventory);
    }

    @Override
    public CellState getCellStatus(int slot) {
        if (this.isClientSide()) {
            return this.clientCellState;
        }
        this.updateHandler();
        ItemStack cell = this.getCell();
        ICellHandler ch = StorageCells.getHandler(cell);
        if (this.cellHandler != null && ch != null) {
            return this.cellHandler.cellInventory.getStatus();
        }
        return CellState.ABSENT;
    }

    @Override
    @Nullable
    public Item getCellItem(int slot) {
        if (slot != 0) {
            return null;
        }
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return this.cellItem;
        }
        ItemStack cell = this.getCell();
        return cell.m_41619_() ? null : cell.m_41720_();
    }

    @Override
    @Nullable
    public MEStorage getCellInventory(int slot) {
        if (slot == 0 && this.cellHandler != null) {
            return this.cellHandler;
        }
        return null;
    }

    @Override
    @Nullable
    public StorageCell getOriginalCellInventory(int slot) {
        if (slot == 0 && this.cellHandler != null) {
            return this.cellHandler.cellInventory;
        }
        return null;
    }

    @Override
    public boolean isPowered() {
        if (this.isClientSide()) {
            return this.clientPowered;
        }
        if (this.getMainNode().isPowered()) {
            return true;
        }
        return this.getAECurrentPower() > 1.0;
    }

    @Override
    public boolean isCellBlinking(int slot) {
        return false;
    }

    @Override
    protected double extractAEPower(double amt, Actionable mode) {
        IEnergyService eg;
        double stash = 0.0;
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null && (stash = (eg = grid.getEnergyService()).extractAEPower(amt, mode, PowerMultiplier.ONE)) >= amt) {
            return stash;
        }
        return super.extractAEPower(amt - stash, mode) + stash;
    }

    @Override
    public void serverTick() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null || !grid.getEnergyService().isNetworkPowered()) {
            this.extractAEPower(this.idlePowerUsage, Actionable.MODULATE, PowerMultiplier.CONFIG);
            this.recalculateDisplay();
        }
        if (!this.inputInventory.isEmpty()) {
            this.tryToStoreContents();
        }
    }

    @Override
    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        this.clientCellState = this.getCellStatus(0);
        data.m_130068_((Enum)this.clientCellState);
        this.clientPowered = this.isPowered();
        data.writeBoolean(this.clientPowered);
        data.writeByte(this.paintedColor.ordinal());
        data.m_130130_(Item.m_41393_((Item)this.getCell().m_41720_()));
    }

    @Override
    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean c = super.readFromStream(data);
        CellState oldCellState = this.clientCellState;
        boolean oldPowered = this.clientPowered;
        AEColor oldColor = this.paintedColor;
        Item oldCellItem = this.cellItem;
        this.clientCellState = (CellState)data.m_130066_(CellState.class);
        this.clientPowered = data.readBoolean();
        this.paintedColor = (AEColor)data.m_130066_(AEColor.class);
        this.cellItem = Item.m_41445_((int)data.m_130242_());
        return c || oldCellState != this.clientCellState || oldPowered != this.clientPowered || oldColor != this.paintedColor || oldCellItem != this.cellItem;
    }

    @Override
    protected void saveVisualState(CompoundTag data) {
        super.saveVisualState(data);
        data.m_128379_("powered", this.isPowered());
        data.m_128359_("cellStatus", this.getCellStatus(0).name());
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)this.getCell().m_41720_());
        data.m_128359_("cellId", itemId.toString());
        data.m_128359_("color", this.paintedColor.name());
    }

    @Override
    protected void loadVisualState(CompoundTag data) {
        super.loadVisualState(data);
        this.clientPowered = data.m_128471_("powered");
        try {
            this.clientCellState = CellState.valueOf(data.m_128461_("cellStatus"));
        }
        catch (Exception e) {
            this.clientCellState = CellState.ABSENT;
            LOG.warn("Couldn't read cell status for {} from {}", (Object)this, (Object)data);
        }
        try {
            this.cellItem = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(data.m_128461_("cellId")));
        }
        catch (Exception e) {
            LOG.warn("Couldn't read cell item for {} from {}", (Object)this, (Object)data);
            this.cellItem = Items.f_41852_;
        }
        try {
            this.paintedColor = AEColor.valueOf(data.m_128461_("color"));
        }
        catch (IllegalArgumentException ignore) {
            LOG.warn("Invalid painted color in visual data for {}: {}", (Object)this, (Object)data);
            this.paintedColor = AEColor.TRANSPARENT;
        }
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.config.readFromNBT(data);
        this.priority = data.m_128451_("priority");
        if (data.m_128441_("paintedColor")) {
            this.paintedColor = AEColor.values()[data.m_128445_("paintedColor")];
        }
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        this.config.writeToNBT(data);
        data.m_128405_("priority", this.priority);
        data.m_128344_("paintedColor", (byte)this.paintedColor.ordinal());
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        boolean currentOnline = this.getMainNode().isOnline();
        if (this.wasOnline != currentOnline) {
            this.wasOnline = currentOnline;
            IStorageProvider.requestUpdate(this.getMainNode());
            this.recalculateDisplay();
        }
    }

    @Override
    public MEStorage getInventory() {
        this.updateHandler();
        if (this.supplierStorage != null) {
            return this.supplierStorage;
        }
        return null;
    }

    @Override
    public InternalInventory getInternalInventory() {
        return this.internalInventory;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (inv == this.cellInventory) {
            this.cellHandler = null;
            this.supplierStorage = null;
            this.isCached = false;
            IStorageProvider.requestUpdate(this.getMainNode());
            if (this.f_58857_ != null) {
                Platform.notifyBlocksOfNeighbors(this.f_58857_, this.f_58858_);
                this.markForUpdate();
            }
        }
        if (inv == this.inputInventory && !inv.getStackInSlot(slot).m_41619_()) {
            this.tryToStoreContents();
        }
    }

    @Override
    public InternalInventory getExposedInventoryForSide(Direction side) {
        if (side == this.getFront()) {
            return this.cellInventory;
        }
        return this.inputInventory;
    }

    private void tryToStoreContents() {
        if (!this.inputInventory.isEmpty()) {
            this.updateHandler();
            if (this.cellHandler != null) {
                ItemStack stack = this.inputInventory.getStackInSlot(0);
                if (stack.m_41619_()) {
                    return;
                }
                long inserted = StorageHelper.poweredInsert(this, this.cellHandler, AEItemKey.of(stack), stack.m_41613_(), this.mySrc);
                if (inserted >= (long)stack.m_41613_()) {
                    this.inputInventory.setItemDirect(0, ItemStack.f_41583_);
                } else {
                    stack.m_41774_((int)inserted);
                    this.inputInventory.setItemDirect(0, stack);
                }
            }
        }
    }

    @Override
    public void mountInventories(IStorageMounts storageMounts) {
        if (this.getMainNode().isOnline()) {
            this.updateHandler();
            if (this.cellHandler != null) {
                storageMounts.mount(this.cellHandler, this.priority);
            }
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.cellHandler = null;
        this.supplierStorage = null;
        this.isCached = false;
        IStorageProvider.requestUpdate(this.getMainNode());
    }

    private void blinkCell(int slot) {
        this.recalculateDisplay();
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.config;
    }

    public boolean openGui(Player p) {
        ICellGuiHandler chg;
        ICellHandler ch;
        this.updateHandler();
        if (this.cellHandler != null && (ch = StorageCells.getHandler(this.getCell())) != null && (chg = StorageCells.getGuiHandler(this.getCell())) != null) {
            chg.openChestGui(p, this, ch, this.getCell());
            return true;
        }
        return false;
    }

    @Override
    public AEColor getColor() {
        return this.paintedColor;
    }

    @Override
    public boolean recolourBlock(Direction side, AEColor newPaintedColor, Player who) {
        if (this.paintedColor == newPaintedColor) {
            return false;
        }
        this.paintedColor = newPaintedColor;
        this.saveChanges();
        this.markForUpdate();
        return true;
    }

    private void onCellContentChanged() {
        if (this.cellHandler != null) {
            this.cellHandler.cellInventory.persist();
        }
        this.f_58857_.m_151543_(this.f_58858_);
    }

    public void openCellInventoryMenu(Player player) {
        MenuOpener.open(ChestMenu.TYPE, player, MenuLocators.forBlockEntity(this));
    }

    @Nullable
    public IFluidHandler getFluidHandler(Direction side) {
        if (side != this.getFront()) {
            return this.fluidHandler;
        }
        return null;
    }

    @Nullable
    public MEStorage getMEStorage(Direction side) {
        if (side != this.getFront()) {
            return this.getInventory();
        }
        return null;
    }

    @Override
    public ItemStack getMainMenuIcon() {
        return AEBlocks.CHEST.stack();
    }

    @Override
    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        MenuOpener.returnTo(ChestMenu.TYPE, player, MenuLocators.forBlockEntity(this));
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        this.updateHandler();
        if (capability == ForgeCapabilities.FLUID_HANDLER && this.fluidHandler != null && facing != this.getFront()) {
            return LazyOptional.of(() -> this.fluidHandler);
        }
        if (capability == Capabilities.STORAGE && facing != this.getFront()) {
            return LazyOptional.of(this::getInventory);
        }
        return super.getCapability(capability, facing);
    }

    private class InputInventoryFilter
    implements IAEItemFilter {
        private InputInventoryFilter() {
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return false;
        }

        @Override
        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            if (ChestBlockEntity.this.isPowered()) {
                ChestBlockEntity.this.updateHandler();
                if (ChestBlockEntity.this.cellHandler == null) {
                    return false;
                }
                AEItemKey what = AEItemKey.of(stack);
                if (what == null) {
                    return false;
                }
                return ChestBlockEntity.this.cellHandler.insert(what, stack.m_41613_(), Actionable.SIMULATE, ChestBlockEntity.this.mySrc) > 0L;
            }
            return false;
        }
    }

    private static class CellInventoryFilter
    implements IAEItemFilter {
        private CellInventoryFilter() {
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return true;
        }

        @Override
        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return StorageCells.getHandler(stack) != null;
        }
    }

    private class ChestMonitorHandler
    extends DelegatingMEInventory {
        private final StorageCell cellInventory;

        public ChestMonitorHandler(StorageCell cellInventory) {
            super(cellInventory);
            this.cellInventory = cellInventory;
        }

        @Override
        public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
            long inserted = super.insert(what, amount, mode, source);
            if (inserted > 0L && mode == Actionable.MODULATE) {
                ChestBlockEntity.this.blinkCell(0);
            }
            return inserted;
        }

        @Override
        public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
            long extracted = super.extract(what, amount, mode, source);
            if (extracted > 0L && mode == Actionable.MODULATE) {
                ChestBlockEntity.this.blinkCell(0);
            }
            return extracted;
        }
    }

    private class FluidHandler
    implements IFluidHandler,
    IFluidTank {
        private FluidHandler() {
        }

        private boolean canAcceptLiquids() {
            return ChestBlockEntity.this.cellHandler != null;
        }

        public FluidStack getFluid() {
            return FluidStack.EMPTY;
        }

        public int getFluidAmount() {
            return 0;
        }

        public int getCapacity() {
            return this.canAcceptLiquids() ? 1000 : 0;
        }

        public boolean isFluidValid(FluidStack stack) {
            return this.canAcceptLiquids();
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return tank == 0 ? 1000 : 0;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return tank == 0;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            AEFluidKey what;
            ChestBlockEntity.this.updateHandler();
            if (this.canAcceptLiquids() && (what = AEFluidKey.of(resource)) != null) {
                return (int)StorageHelper.poweredInsert(ChestBlockEntity.this, ChestBlockEntity.this.cellHandler, what, resource.getAmount(), ChestBlockEntity.this.mySrc, Actionable.of(action));
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }
}

