/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.shapes;

import blusunrize.immersiveengineering.api.utils.shapes.ShapeUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.DieselGeneratorLogic;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DieselGeneratorShapes
implements Function<BlockPos, VoxelShape> {
    public static final Function<BlockPos, VoxelShape> SHAPE_GETTER = new DieselGeneratorShapes();
    public static final Function<BlockPos, VoxelShape> GETTER_WITH_REDSTONE_SUPPORT = DieselGeneratorShapes::redstoneSupported;

    private DieselGeneratorShapes() {
    }

    @Override
    public VoxelShape apply(BlockPos posInMultiblock) {
        if (new BlockPos(1, 1, 4).equals((Object)posInMultiblock)) {
            return Shapes.m_83110_((VoxelShape)Shapes.m_83048_((double)0.0, (double)0.5, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (VoxelShape)Shapes.m_83048_((double)0.0, (double)-0.5, (double)-0.625, (double)1.0, (double)0.5, (double)1.0));
        }
        if (posInMultiblock.m_123342_() == 1 && posInMultiblock.m_123343_() == 4) {
            return ShapeUtils.join(Utils.flipBoxes(false, posInMultiblock.m_123341_() == 2, new AABB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0), new AABB(0.125, 0.0, 0.125, 0.375, 0.5, 0.375), new AABB(0.125, 0.0, 0.625, 0.375, 0.5, 0.875)));
        }
        if (new BlockPos(2, 1, 2).equals((Object)posInMultiblock)) {
            return Shapes.m_83124_((VoxelShape)DieselGeneratorShapes.getBlockBounds(posInMultiblock), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.5, (double)0.25, (double)0.3125, (double)1.0, (double)0.75, (double)0.6875), Shapes.m_83048_((double)0.6875, (double)-0.5, (double)0.4375, (double)0.8125, (double)0.25, (double)0.5625)});
        }
        if (posInMultiblock.m_123341_() % 2 == 0 && posInMultiblock.m_123342_() == 0 && posInMultiblock.m_123343_() < 4) {
            double offset;
            ArrayList list = Lists.newArrayList((Object[])new AABB[]{DieselGeneratorShapes.getBlockBounds(posInMultiblock).m_83215_()});
            if (posInMultiblock.m_123343_() > 2) {
                list.add(new AABB(0.125, 0.5625, 0.25, 1.0, 0.8125, 0.5));
                list.add(new AABB(0.125, 0.5625, 0.5, 0.375, 0.8125, 1.0));
            } else if (posInMultiblock.m_123343_() > 0) {
                offset = posInMultiblock.m_123343_() > 1 ? 0.0 : 1.0;
                list.add(new AABB(0.4375, 0.5, -0.5625 + offset, 1.0, 1.0, 0.75 + offset));
            }
            if (posInMultiblock.m_123343_() < 2) {
                offset = posInMultiblock.m_123343_() == 1 ? 0.0 : 1.0;
                list.add(new AABB(0.375, 0.5625, 0.5625 + offset, 0.4375, 0.8125, 0.8125 + offset));
                list.add(new AABB(0.375, 0.5625, -0.875 + offset, 0.5, 0.8125, -0.625 + offset));
                list.add(new AABB(0.125, 0.5625, -0.875 + offset, 0.375, 0.8125, 0.8125 + offset));
            }
            return ShapeUtils.join(Utils.flipBoxes(false, posInMultiblock.m_123341_() == 2, list));
        }
        return DieselGeneratorShapes.getBlockBounds(posInMultiblock);
    }

    private static VoxelShape getBlockBounds(BlockPos posInMultiblock) {
        boolean lessThan21;
        if (new BlockPos(1, 0, 4).equals((Object)posInMultiblock)) {
            return Shapes.m_83048_((double)0.0, (double)0.5, (double)-0.625, (double)1.0, (double)1.5, (double)1.0);
        }
        if (ImmutableSet.of((Object)new BlockPos(0, 0, 4), (Object)new BlockPos(2, 1, 0), (Object)new BlockPos(2, 2, 0)).contains((Object)posInMultiblock)) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)(posInMultiblock.m_123342_() == 2 ? 0.8125 : 1.0), (double)(posInMultiblock.m_123343_() == 0 ? 1.125 : 1.0));
        }
        if (ImmutableSet.of((Object)new BlockPos(2, 0, 4), (Object)new BlockPos(0, 1, 0), (Object)new BlockPos(0, 2, 0)).contains((Object)posInMultiblock)) {
            return Shapes.m_83048_((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)(posInMultiblock.m_123342_() == 2 ? 0.8125 : 1.0), (double)(posInMultiblock.m_123343_() == 0 ? 1.125 : 1.0));
        }
        if (new BlockPos(1, 2, 0).equals((Object)posInMultiblock)) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)(posInMultiblock.m_123342_() == 2 ? 0.8125 : 1.0), (double)(posInMultiblock.m_123343_() == 0 ? 0.625 : 1.0));
        }
        if (posInMultiblock.m_123342_() == 1 && posInMultiblock.m_123343_() == 4) {
            return Shapes.m_83048_((double)0.0, (double)0.5, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        }
        if (posInMultiblock.m_123341_() == 1 && posInMultiblock.m_123342_() > 0 && posInMultiblock.m_123343_() == 3) {
            return Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0, (double)0.9375, (double)(posInMultiblock.m_123342_() == 2 ? 0.3125 : 1.0), (double)0.625);
        }
        if (new BoundingBox(1, 2, 1, 1, 2, 2).m_71051_((Vec3i)posInMultiblock)) {
            return Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0, (double)0.9375, (double)0.3125, (double)1.0);
        }
        if (posInMultiblock.m_123341_() % 2 == 0 && posInMultiblock.m_123342_() == 0) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
        }
        boolean bl = lessThan21 = posInMultiblock.m_123342_() == 0 || posInMultiblock.m_123342_() == 1 && posInMultiblock.m_123343_() > 2;
        if (posInMultiblock.m_123341_() == 0 && posInMultiblock.m_123342_() < 2) {
            return Shapes.m_83048_((double)0.9375, (double)-0.5, (double)0.0, (double)1.0, (double)0.625, (double)(lessThan21 ? 0.625 : 1.0));
        }
        if (posInMultiblock.m_123341_() == 2 && posInMultiblock.m_123342_() < 2) {
            return Shapes.m_83048_((double)0.0, (double)-0.5, (double)0.0, (double)0.0625, (double)0.625, (double)(lessThan21 ? 0.625 : 1.0));
        }
        if (posInMultiblock.m_123341_() % 2 == 0 && posInMultiblock.m_123342_() == 2 && posInMultiblock.m_123343_() == 2) {
            return Shapes.m_83064_((AABB)Utils.flipBox(false, posInMultiblock.m_123341_() == 2, new AABB(0.5625, 0.0, -0.0625, 1.0625, posInMultiblock.m_123341_() == 2 ? 1.125 : 0.75, 0.4375)));
        }
        return Shapes.m_83144_();
    }

    private static VoxelShape redstoneSupported(BlockPos pos) {
        VoxelShape baseShape = SHAPE_GETTER.apply(pos);
        if (pos.equals((Object)DieselGeneratorLogic.REDSTONE_POS)) {
            return Shapes.m_83110_((VoxelShape)baseShape, (VoxelShape)Shapes.m_83048_((double)0.9375, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
        }
        return baseShape;
    }
}

