/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.process;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.InsertOnlyInventory;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class DirectProcessingItemHandler<R extends MultiblockRecipe>
extends InsertOnlyInventory {
    private static final float TRANSFORMATION_POINT = 0.5f;
    private boolean doProcessStacking = false;
    protected final Supplier<Level> level;
    protected final MultiblockProcessor<R, ProcessContext.ProcessContextInWorld<R>> processor;
    private final BiFunction<Level, ItemStack, @Nullable R> getRecipeOnInsert;

    public DirectProcessingItemHandler(Supplier<Level> level, MultiblockProcessor<R, ProcessContext.ProcessContextInWorld<R>> processor, BiFunction<Level, ItemStack, @Nullable R> getRecipeOnInsert) {
        this.level = level;
        this.processor = processor;
        this.getRecipeOnInsert = getRecipeOnInsert;
    }

    public DirectProcessingItemHandler<R> setProcessStacking(boolean stacking) {
        this.doProcessStacking = stacking;
        return this;
    }

    @Override
    protected ItemStack insert(ItemStack stack, boolean simulate) {
        stack = stack.m_41777_();
        MultiblockRecipe recipe = (MultiblockRecipe)this.getRecipeOnInsert.apply(this.level.get(), stack);
        if (recipe == null) {
            return stack;
        }
        ItemStack displayStack = recipe.getDisplayStack(stack);
        if (this.processor.addProcessToQueue(new MultiblockProcessInWorld<MultiblockRecipe>(recipe, 0.5f, Utils.createNonNullItemStackListFromItemStack(displayStack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)displayStack.m_41613_()))), this.level.get(), simulate, this.doProcessStacking)) {
            stack.m_41774_(displayStack.m_41613_());
        }
        return stack;
    }
}

