/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtphc2.blocks;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import maxhyper.dtphc2.genfeatures.DTPHC2GenFeatures;
import maxhyper.dtphc2.genfeatures.SyrupGenFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class MapleSpileCommon
extends HorizontalDirectionalBlock {
    public static final BooleanProperty FILLED = BooleanProperty.m_61465_((String)"filled");
    public static final int maxFilling = 3;
    public static final IntegerProperty FILLING = IntegerProperty.m_61631_((String)"filling", (int)0, (int)3);
    protected VoxelShape SHAPE_N;
    protected VoxelShape SHAPE_E;
    protected VoxelShape SHAPE_S;
    protected VoxelShape SHAPE_W;

    protected static VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Block.m_49796_((double)7.0, (double)10.0, (double)-1.0, (double)9.0, (double)12.0, (double)4.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Block.m_49796_((double)7.0, (double)10.0, (double)4.0, (double)9.0, (double)11.0, (double)6.0), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.ordinal() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                System.out.println("min: " + maxZ + ", " + minX + " | max: " + minZ + ", " + maxX);
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public MapleSpileCommon() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_).m_60978_(0.5f).m_60977_());
    }

    protected abstract boolean giveSyrup(Level var1, BlockPos var2, BlockState var3, Player var4, BlockPos var5);

    public static Item getSyrupItem(Species species) {
        if (species == null) {
            return Items.f_41852_;
        }
        GenFeatureConfiguration featureConfig = species.getGenFeatures().stream().filter(fc -> fc.getGenFeature() == DTPHC2GenFeatures.SYRUP_GEN).findFirst().orElse(null);
        if (featureConfig == null) {
            return Items.f_41852_;
        }
        return ((SyrupGenFeature)DTPHC2GenFeatures.SYRUP_GEN).getSyrupItem(featureConfig);
    }

    public int colorMultiplier(BlockState state, BlockAndTintGetter level, BlockPos pos, int tintIndex) {
        if (tintIndex != 0) {
            return 1;
        }
        Species species = null;
        BlockPos treePos = pos.m_121955_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_().m_122436_());
        BlockState treeState = level.m_8055_(treePos);
        Block block = treeState.m_60734_();
        if (block instanceof BranchBlock) {
            BranchBlock branch = (BranchBlock)block;
            species = branch.getFamily().getCommonSpecies();
        }
        if (species == null) {
            return 1;
        }
        GenFeatureConfiguration featureConfig = species.getGenFeatures().stream().filter(fc -> fc.getGenFeature() == DTPHC2GenFeatures.SYRUP_GEN).findFirst().orElse(null);
        if (featureConfig == null) {
            return 0xFF00FF;
        }
        return ((SyrupGenFeature)DTPHC2GenFeatures.SYRUP_GEN).getTint(featureConfig);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState blockstate = this.m_49966_();
        Direction direction = pContext.m_43719_();
        if (direction.m_122434_().m_122479_()) {
            return (BlockState)blockstate.m_61124_((Property)f_54117_, (Comparable)direction);
        }
        return blockstate;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos offsetPos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_());
        BlockState offsetState = world.m_8055_(offsetPos);
        return TreeHelper.isBranch((BlockState)offsetState) && TreeHelper.getRadius((BlockGetter)world, (BlockPos)offsetPos) >= 7;
    }

    @Nonnull
    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return pFacing == ((Direction)pState.m_61143_((Property)f_54117_)).m_122424_() && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case Direction.EAST -> this.SHAPE_E;
            case Direction.SOUTH -> this.SHAPE_S;
            case Direction.WEST -> this.SHAPE_W;
            default -> this.SHAPE_N;
        };
    }

    @Nonnull
    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)f_54117_, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)f_54117_)));
    }

    @Nonnull
    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)f_54117_)));
    }
}

