/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtphc2.blocks;

import com.ferreusveritas.dynamictrees.block.FruitBlock;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.systems.fruit.Fruit;
import java.util.List;
import javax.annotation.Nonnull;
import maxhyper.dtphc2.blocks.IFallingFruit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class FallingFruitBlock
extends FruitBlock
implements IFallingFruit {
    DamageSource damageSource;
    public static float randomFruitFallChance = 0.005f;
    public static float playerDistanceToFall = 10.0f;

    public FallingFruitBlock(BlockBehaviour.Properties properties, Fruit fruit) {
        super(properties, fruit);
        DamageType damageType = new DamageType("dtphc2.falling_fruit." + fruit.getRegistryName().m_135815_(), 1.0f);
        this.damageSource = new DamageSource(Holder.m_205709_((Object)damageType));
    }

    public void doTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (this.checkToFall(state, world, pos, random)) {
            this.doFall(state, world, pos);
        } else {
            super.doTick(state, world, pos, random);
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!this.isSupported((LevelReader)world, pos, state) && !this.doFall(state, world, pos)) {
            super.m_6861_(state, world, pos, block, fromPos, isMoving);
        }
        DebugPackets.m_133708_((Level)world, (BlockPos)pos);
    }

    @Override
    public ItemStack getDropOnFallItems(@Nonnull FallingBlockEntity entity) {
        if (entity.m_20194_() == null) {
            return ItemStack.f_41583_;
        }
        ServerLevel world = entity.m_20194_().m_129880_(entity.m_9236_().m_46472_());
        if (world == null) {
            return ItemStack.f_41583_;
        }
        List items = FallingFruitBlock.m_49869_((BlockState)entity.m_31980_(), (ServerLevel)world, (BlockPos)entity.m_20183_(), null);
        return items.isEmpty() ? ItemStack.f_41583_ : (ItemStack)items.get(0);
    }

    @Override
    public DamageSource getDamageSource(Level level) {
        return this.damageSource;
    }

    @Override
    public int getRootY(BlockState state, Level world, BlockPos pos) {
        for (int i = 0; i < 20; ++i) {
            BlockPos pos2 = pos.m_6625_(i);
            if (!(world.m_8055_(pos2).m_60734_() instanceof RootyBlock)) continue;
            return pos2.m_123342_();
        }
        return pos.m_123342_();
    }

    @Override
    public float getRandomFruitFallChance() {
        return randomFruitFallChance;
    }

    @Override
    public float getPlayerDistanceToFall() {
        return playerDistanceToFall;
    }
}

