/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.multimine.client;

import atomicstryker.multimine.common.MultiMine;
import atomicstryker.multimine.common.PartiallyMinedBlock;
import atomicstryker.multimine.common.network.PartialBlockPacket;
import java.io.File;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="multimine")
public class MultiMineClient {
    private static MultiMineClient instance = null;
    private static Minecraft mc;
    private static Player thePlayer;
    private final PartiallyMinedBlock[] partiallyMinedBlocksArray = new PartiallyMinedBlock[30];
    private Field vanillaDestroyProgressField = null;
    private int arrayOverWriteIndex;
    private BlockPos lastClickedBlock;
    private float lastBlockCompletion;

    public void initialize() {
        MultiMine.LOGGER.info("MultiMineClient initializing");
        this.arrayOverWriteIndex = 0;
        this.lastClickedBlock = BlockPos.f_121853_;
        this.lastBlockCompletion = 0.0f;
    }

    public static MultiMineClient instance() {
        if (instance == null) {
            instance = new MultiMineClient();
            instance.initialize();
        }
        return instance;
    }

    @SubscribeEvent
    public static void playerLoginToServer(ClientPlayerNetworkEvent.LoggingIn evt) {
        mc = Minecraft.m_91087_();
        MultiMine.LOGGER.info("MultiMineClient playerLoginToServer: " + evt.getPlayer());
        MultiMine.instance().initIfNeeded(evt.getPlayer().m_9236_());
        MultiMineClient.instance().reset();
    }

    private void reset() {
        if (MultiMineClient.mc.f_91073_ == null) {
            return;
        }
        for (int i = 0; i < this.partiallyMinedBlocksArray.length; ++i) {
            if (this.partiallyMinedBlocksArray[i] == null) continue;
            if (MultiMineClient.mc.f_91073_.m_46749_(this.partiallyMinedBlocksArray[i].getPos())) {
                MultiMineClient.mc.f_91073_.m_6801_(i, this.partiallyMinedBlocksArray[i].getPos(), 10);
            }
            this.partiallyMinedBlocksArray[i] = null;
        }
    }

    public static File getMcFolder() {
        return Minecraft.m_91087_().f_91069_;
    }

    @SubscribeEvent
    public static void onClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        MultiMineClient.instance().onClickBlockInstance(event);
    }

    private void onClickBlockInstance(PlayerInteractEvent.LeftClickBlock event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            return;
        }
        thePlayer = event.getEntity();
        BlockPos pos = event.getPos();
        if (!this.destroyProgressFieldFound()) {
            MultiMine.instance().debugPrint("reflection into destroyProgress not ready, aborting", new Object[0]);
            return;
        }
        BlockEntity blockentity = thePlayer.m_9236_().m_7702_(pos);
        if (blockentity instanceof Container) {
            MultiMine.instance().debugPrint("aborting because its a container block", new Object[0]);
            return;
        }
        float destroyProgressVanilla = this.getVanillaDestroyProgressValue();
        MultiMine.instance().debugPrint("client {} clicked block {}, destroyProgress {}, lastBlockCompletion {}", thePlayer, pos, Float.valueOf(destroyProgressVanilla), Float.valueOf(this.lastBlockCompletion));
        boolean cachedProgressWasAhead = false;
        for (int i = 0; i < this.partiallyMinedBlocksArray.length; ++i) {
            if (this.partiallyMinedBlocksArray[i] == null || !this.partiallyMinedBlocksArray[i].getPos().equals((Object)pos)) continue;
            float savedProgress = this.partiallyMinedBlocksArray[i].getProgress();
            MultiMine.instance().debugPrint("found cached destroyProgress at index {}, cached: {}, mc: {}", i, Float.valueOf(savedProgress), Float.valueOf(destroyProgressVanilla));
            if (!(savedProgress > destroyProgressVanilla)) break;
            this.lastBlockCompletion = savedProgress;
            cachedProgressWasAhead = true;
            break;
        }
        if (!cachedProgressWasAhead) {
            if (!this.lastClickedBlock.equals((Object)pos)) {
                MultiMine.instance().debugPrint("client is destroying new block, was {} and now {}", this.lastClickedBlock, pos);
                this.lastClickedBlock = pos;
                this.lastBlockCompletion = 0.0f;
            } else if (destroyProgressVanilla > this.lastBlockCompletion) {
                MultiMine.instance().debugPrint("client has block progress for: [{}], actual completion: {}, lastCompletion: {}", pos, Float.valueOf(destroyProgressVanilla), Float.valueOf(this.lastBlockCompletion));
                MultiMine.instance().networkHelper.sendPacketToServer(new PartialBlockPacket(thePlayer.m_6302_(), this.lastClickedBlock.m_123341_(), this.lastClickedBlock.m_123342_(), this.lastClickedBlock.m_123343_(), destroyProgressVanilla, false));
                MultiMine.instance().debugPrint("sent block progress packet to server: {}", Float.valueOf(destroyProgressVanilla));
                this.lastBlockCompletion = destroyProgressVanilla;
                this.updateLocalPartialBlock(this.lastClickedBlock.m_123341_(), this.lastClickedBlock.m_123342_(), this.lastClickedBlock.m_123343_(), destroyProgressVanilla, false);
            }
        } else {
            MultiMine.instance().debugPrint("overriding client destroyProgress {} with multi mine cache {}", Float.valueOf(destroyProgressVanilla), Float.valueOf(this.lastBlockCompletion));
            this.setDestroyProgressValue(this.lastBlockCompletion);
        }
    }

    private boolean destroyProgressFieldFound() {
        if (MultiMineClient.mc.f_91072_ == null) {
            return false;
        }
        if (this.vanillaDestroyProgressField != null) {
            return true;
        }
        for (Field f : MultiPlayerGameMode.class.getDeclaredFields()) {
            if (!f.getType().equals(Float.TYPE)) continue;
            try {
                f.setAccessible(true);
                float value = ((Float)f.get(MultiMineClient.mc.f_91072_)).floatValue();
                if (!(value > 0.0f) || !(value < 1.0f)) continue;
                this.vanillaDestroyProgressField = f;
                return true;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("vanillaDestroyProgressField read failure", e);
            }
        }
        return false;
    }

    private float getVanillaDestroyProgressValue() {
        try {
            return ((Float)this.vanillaDestroyProgressField.get(MultiMineClient.mc.f_91072_)).floatValue();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("vanillaDestroyProgressField read failure", e);
        }
    }

    private void setDestroyProgressValue(float lastBlockCompletion) {
        try {
            this.vanillaDestroyProgressField.set(MultiMineClient.mc.f_91072_, Float.valueOf(lastBlockCompletion));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("vanillaDestroyProgressField write failure", e);
        }
    }

    private void renderBlockDigParticles(int x, int y, int z) {
        BlockPos bp;
        Level world = thePlayer.m_9236_();
        BlockState state = world.m_8055_(bp = new BlockPos(x, y, z));
        Block block = state.m_60734_();
        if (block != Blocks.f_50016_) {
            SoundType soundtype = block.getSoundType(state, (LevelReader)world, bp, (Entity)thePlayer);
            mc.m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(soundtype.m_56778_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 8.0f, soundtype.m_56774_() * 0.5f, thePlayer.m_217043_(), bp));
        }
        world.m_142052_(bp, state);
    }

    public void onServerSentPartialBlockData(int x, int y, int z, float progress, boolean regenerating) {
        if (thePlayer == null) {
            return;
        }
        MultiMine.instance().debugPrint("Client received partial Block packet for: [{}|{}|{}], progress now: {}, regen: {}", x, y, z, Float.valueOf(progress), regenerating);
        this.updateLocalPartialBlock(x, y, z, progress, regenerating);
    }

    private void updateLocalPartialBlock(int x, int y, int z, float progress, boolean regenerating) {
        BlockPos pos = new BlockPos(x, y, z);
        PartiallyMinedBlock newBlock = new PartiallyMinedBlock(x, y, z, (ResourceKey<Level>)thePlayer.m_9236_().m_46472_(), progress);
        int freeIndex = -1;
        if (regenerating && pos.equals((Object)this.lastClickedBlock) && progress >= 0.0f) {
            this.lastBlockCompletion = progress;
        }
        for (int arrayIndex = 0; arrayIndex < this.partiallyMinedBlocksArray.length; ++arrayIndex) {
            PartiallyMinedBlock iterBlock = this.partiallyMinedBlocksArray[arrayIndex];
            if (iterBlock == null && freeIndex == -1) {
                freeIndex = arrayIndex;
                continue;
            }
            if (!newBlock.equals(iterBlock)) continue;
            if (progress < 0.0f) {
                MultiMine.instance().debugPrint("Client was told to forget progress for partial block [{}|{}|{}], at index {}, it is blacklisted", x, y, z, arrayIndex);
                this.partiallyMinedBlocksArray[arrayIndex] = null;
                return;
            }
            boolean notClientsBlock = false;
            if (iterBlock.getProgress() < progress && !iterBlock.getPos().equals((Object)pos)) {
                this.renderBlockDigParticles(x, y, z);
                notClientsBlock = true;
            }
            MultiMine.instance().debugPrint("Client updating local partial block [{}|{}|{}], at index {}, notClientsBlock: {}, setting progress from {} to {}", x, y, z, arrayIndex, notClientsBlock, Float.valueOf(iterBlock.getProgress()), Float.valueOf(progress));
            iterBlock.setProgress(progress);
            MultiMineClient.mc.f_91073_.m_6801_(arrayIndex, iterBlock.getPos(), Math.min(9, Math.round(10.0f * iterBlock.getProgress())));
            if (iterBlock.isFinished()) {
                MultiMineClient.mc.f_91072_.m_105267_(pos);
                MultiMineClient.mc.f_91073_.m_6801_(arrayIndex, iterBlock.getPos(), 10);
                this.partiallyMinedBlocksArray[arrayIndex] = null;
                if (this.lastClickedBlock.m_123341_() == x && this.lastClickedBlock.m_123342_() == y && this.lastClickedBlock.m_123343_() == z) {
                    this.lastClickedBlock = BlockPos.f_121853_;
                }
                MultiMine.instance().debugPrint("Client wiped local finished block [{}|{}|{}], at index {}", x, y, z, arrayIndex);
            }
            return;
        }
        if ((double)progress > 0.99) {
            MultiMine.instance().debugPrint("Client ignoring late arrival packet [{}|{}|{}]", x, y, z);
            return;
        }
        if (freeIndex != -1) {
            this.partiallyMinedBlocksArray[freeIndex] = newBlock;
        } else {
            this.partiallyMinedBlocksArray[this.arrayOverWriteIndex++] = newBlock;
            if (this.arrayOverWriteIndex == this.partiallyMinedBlocksArray.length) {
                this.arrayOverWriteIndex = 0;
            }
        }
    }

    private void onBlockMineFinishedDamagePlayerItem(Player player, int x, int y, int z) {
        if (x != this.lastClickedBlock.m_123341_() || y != this.lastClickedBlock.m_123342_() || z != this.lastClickedBlock.m_123343_()) {
            return;
        }
        ItemStack itemStack = player.m_21205_();
        BlockPos pos = new BlockPos(x, y, z);
        itemStack.m_41686_(player.m_9236_(), player.m_9236_().m_8055_(pos), pos, player);
        if (itemStack.m_41613_() == 0) {
            player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
    }

    public void onServerSentPartialBlockDeleteCommand(BlockPos p) {
        if (MultiMineClient.mc.f_91073_ == null) {
            return;
        }
        MultiMine.instance().debugPrint("Server sent partial delete command for [{}|{}|{}]", p.m_123341_(), p.m_123342_(), p.m_123343_());
        if (this.lastClickedBlock.equals((Object)p)) {
            MultiMine.instance().debugPrint("was current block, wiping that!", new Object[0]);
            this.lastClickedBlock = BlockPos.f_121853_;
            this.lastBlockCompletion = 0.0f;
        }
        for (int i = 0; i < this.partiallyMinedBlocksArray.length; ++i) {
            if (this.partiallyMinedBlocksArray[i] == null || !this.partiallyMinedBlocksArray[i].getPos().equals((Object)p)) continue;
            MultiMineClient.mc.f_91073_.m_6801_(i, this.partiallyMinedBlocksArray[i].getPos(), 10);
            this.partiallyMinedBlocksArray[i] = null;
            MultiMine.instance().debugPrint("Server sent partial delete matched at index {}, deleted!", i);
            break;
        }
    }
}

