/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem;

import com.corosus.coroutil.util.CoroUtilMisc;
import extendedrenderer.particle.entity.ParticleCube;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import weather2.ClientTickHandler;
import weather2.Weather;
import weather2.client.SceneEnhancer;
import weather2.config.ConfigParticle;
import weather2.weathersystem.WeatherManager;
import weather2.weathersystem.storm.EnumWeatherObjectType;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.storm.WeatherObject;
import weather2.weathersystem.storm.WeatherObjectParticleStorm;

@OnlyIn(value=Dist.CLIENT)
public class WeatherManagerClient
extends WeatherManager {
    public WeatherManagerClient(ResourceKey<Level> dimension) {
        super(dimension);
    }

    @Override
    public void tick() {
        boolean cloudTest;
        super.tick();
        if (Weather.isLoveTropicsInstalled() || (cloudTest = false)) {
            // empty if block
        }
    }

    @Override
    public Level getWorld() {
        return Minecraft.m_91087_().f_91073_;
    }

    public void nbtSyncFromServer(CompoundTag parNBT) {
        String command = parNBT.m_128461_("command");
        if (command.equals("syncStormNew")) {
            CompoundTag stormNBT = parNBT.m_128469_("data");
            long ID = stormNBT.m_128454_("ID");
            Weather.dbg("syncStormNew, ID: " + ID);
            EnumWeatherObjectType weatherObjectType = EnumWeatherObjectType.get(stormNBT.m_128451_("weatherObjectType"));
            WeatherObject wo = null;
            if (weatherObjectType == EnumWeatherObjectType.CLOUD) {
                wo = new StormObject(ClientTickHandler.weatherManager);
            } else if (weatherObjectType == EnumWeatherObjectType.SAND) {
                wo = new WeatherObjectParticleStorm(ClientTickHandler.weatherManager);
                ((WeatherObjectParticleStorm)wo).setType(WeatherObjectParticleStorm.StormType.SANDSTORM);
            } else if (weatherObjectType == EnumWeatherObjectType.SNOW) {
                wo = new WeatherObjectParticleStorm(ClientTickHandler.weatherManager);
                ((WeatherObjectParticleStorm)wo).setType(WeatherObjectParticleStorm.StormType.SNOWSTORM);
            }
            wo.getNbtCache().setNewNBT(stormNBT);
            wo.nbtSyncFromServer();
            wo.getNbtCache().updateCacheFromNew();
            this.addStormObject(wo);
        } else if (command.equals("syncStormRemove")) {
            CompoundTag stormNBT = parNBT.m_128469_("data");
            long ID = stormNBT.m_128454_("ID");
            WeatherObject so = (WeatherObject)this.lookupStormObjectsByID.get(ID);
            if (so != null) {
                Weather.dbg("syncStormRemove, ID: " + ID);
                this.removeStormObject(ID);
            } else {
                Weather.dbg("error removing storm, cant find by ID: " + ID);
            }
        } else if (command.equals("syncStormUpdate")) {
            CompoundTag stormNBT = parNBT.m_128469_("data");
            long ID = stormNBT.m_128454_("ID");
            WeatherObject so = (WeatherObject)this.lookupStormObjectsByID.get(ID);
            if (so != null) {
                so.getNbtCache().setNewNBT(stormNBT);
                so.nbtSyncFromServer();
                so.getNbtCache().updateCacheFromNew();
            } else {
                Weather.dbg("error syncing storm, cant find by ID: " + ID + ", probably due to client resetting and waiting on full resync (this is ok)");
            }
        } else if (command.equals("syncWindUpdate")) {
            CompoundTag nbt = parNBT.m_128469_("data");
            this.getWindManager().nbtSyncFromServer(nbt);
        } else if (command.equals("syncWeatherUpdate")) {
            this.isVanillaRainActiveOnServer = parNBT.m_128471_("isVanillaRainActiveOnServer");
            this.isVanillaThunderActiveOnServer = parNBT.m_128471_("isVanillaThunderActiveOnServer");
            this.vanillaRainTimeOnServer = parNBT.m_128451_("vanillaRainTimeOnServer");
            this.vanillaRainAmountOnServer = parNBT.m_128457_("vanillaRainAmountOnServer");
        } else if (command.equals("syncBlockParticleNew")) {
            CompoundTag nbt = parNBT.m_128469_("data");
            int posX = nbt.m_128451_("posX");
            int posY = nbt.m_128451_("posY") + 1;
            int posZ = nbt.m_128451_("posZ");
            BlockState state = NbtUtils.m_247651_((HolderGetter)this.getWorld().m_246945_(Registries.f_256747_), (CompoundTag)nbt.m_128469_("blockstate"));
            long ownerID = nbt.m_128454_("ownerID");
            StormObject storm = this.getStormObjectByID(ownerID);
            if (storm != null && ConfigParticle.Particle_effect_rate > 0.0) {
                int extraCubes = (int)(1.0 + (double)ConfigParticle.Particle_Tornado_extraParticleCubes * ConfigParticle.Particle_effect_rate);
                Random rand = CoroUtilMisc.random();
                float randRange = 3.0f;
                for (int i = 0; i < extraCubes; ++i) {
                    ParticleCube hail = new ParticleCube(this.getWorld(), (double)((float)posX + (rand.nextFloat() - rand.nextFloat()) * randRange), (double)((float)posY + (rand.nextFloat() - rand.nextFloat()) * randRange), (double)((float)posZ + (rand.nextFloat() - rand.nextFloat()) * randRange), 0.0, 0.0, 0.0, state);
                    SceneEnhancer.checkParticleBehavior();
                    SceneEnhancer.particleBehavior.initParticleCube(hail);
                    storm.listParticlesDebris.add(hail);
                    hail.spawnAsWeatherEffect();
                }
            }
        }
    }
}

