/*
 * Decompiled with CFR 0.152.
 */
package weather2.util;

import com.corosus.coroutil.util.CoroUtilBlock;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import weather2.WeatherBlocks;
import weather2.block.SandLayerBlock;

public class WeatherUtilBlock {
    public static int layerableHeightPropMax = 8;

    public static void fillAgainstWallSmoothly(Level world, Vec3 posSource, float directionYaw, float scanDistance, float fillRadius, Block blockLayerable, int maxBlockStackingAllowed) {
        WeatherUtilBlock.fillAgainstWallSmoothly(world, posSource, directionYaw, scanDistance, fillRadius, blockLayerable, 4, maxBlockStackingAllowed);
    }

    public static void fillAgainstWallSmoothly(Level world, Vec3 posSource, float directionYaw, float scanDistance, float fillRadius, Block blockLayerable, int heightDiff, int maxBlockStackingAllowed) {
        int heightTest;
        BlockState stateTest = world.m_8055_(CoroUtilBlock.blockPos((Vec3)posSource));
        if (stateTest.m_60734_() != blockLayerable || (heightTest = WeatherUtilBlock.getHeightForAnyBlock(stateTest)) < 8) {
            // empty if block
        }
        BlockPos posSourcei = CoroUtilBlock.blockPos((Vec3)posSource);
        int y = posSourcei.m_123342_();
        float tickStep = 0.75f;
        Vec3 posLastNonWall = new Vec3(posSource.f_82479_, posSource.f_82480_, posSource.f_82481_);
        Vec3 posWall = null;
        BlockPos lastScannedPosXZ = null;
        int previousBlockHeight = 0;
        for (float i = 0.0f; i < scanDistance; i += tickStep) {
            double vecX = -Math.sin(Math.toRadians(directionYaw)) * (double)i;
            double vecZ = Math.cos(Math.toRadians(directionYaw)) * (double)i;
            int x = Mth.m_14107_((double)(posSource.f_82479_ + vecX));
            int z = Mth.m_14107_((double)(posSource.f_82481_ + vecZ));
            BlockPos pos = new BlockPos(x, y, z);
            BlockPos posXZ = new BlockPos(x, 0, z);
            BlockState state = world.m_8055_(pos);
            if (lastScannedPosXZ != null && posXZ.equals(lastScannedPosXZ)) continue;
            lastScannedPosXZ = new BlockPos((Vec3i)posXZ);
            AABB aabbCompare = new AABB(pos);
            ArrayList listAABBCollision = new ArrayList();
            VoxelShape voxelshape = Shapes.m_83064_((AABB)aabbCompare);
            boolean collided = Shapes.m_83157_((VoxelShape)state.m_60812_((BlockGetter)world, pos).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), (VoxelShape)voxelshape, (BooleanOp)BooleanOp.f_82689_);
            if (!state.m_60795_() && state.m_60734_().m_284356_() != MapColor.f_283915_ && collided) {
                BlockPos posUp = new BlockPos(x, y + 1, z);
                BlockState stateUp = world.m_8055_(posUp);
                if (stateUp.m_60795_()) {
                    int height = WeatherUtilBlock.getHeightForAnyBlock(state);
                    if (height - previousBlockHeight <= heightDiff) {
                        if (height == 8) {
                            previousBlockHeight = 0;
                            ++y;
                        } else {
                            previousBlockHeight = height;
                        }
                        posLastNonWall = new Vec3(posSource.f_82479_ + vecX, (double)y, posSource.f_82481_ + vecZ);
                        continue;
                    }
                    posWall = new Vec3(posSource.f_82479_ + vecX, (double)y, posSource.f_82481_ + vecZ);
                    break;
                }
                posWall = new Vec3(posSource.f_82479_ + vecX, (double)y, posSource.f_82481_ + vecZ);
                break;
            }
            posLastNonWall = new Vec3(posSource.f_82479_ + vecX, (double)y, posSource.f_82481_ + vecZ);
        }
        if (posWall != null) {
            int amountWeHave = 1;
            int amountToAddPerXZ = 1;
            BlockState state = world.m_8055_(CoroUtilBlock.blockPos(posWall));
            BlockState state1 = world.m_8055_(CoroUtilBlock.blockPos((Vec3)posLastNonWall).m_7918_(1, 0, 0));
            BlockState state22 = world.m_8055_(CoroUtilBlock.blockPos((Vec3)posLastNonWall).m_7918_(-1, 0, 0));
            BlockState state3 = world.m_8055_(CoroUtilBlock.blockPos((Vec3)posLastNonWall).m_7918_(0, 0, 1));
            BlockState state4 = world.m_8055_(CoroUtilBlock.blockPos((Vec3)posLastNonWall).m_7918_(0, 0, -1));
            if (state.m_60734_() == Blocks.f_50128_ || state1.m_60734_() == Blocks.f_50128_ || state22.m_60734_() == Blocks.f_50128_ || state3.m_60734_() == Blocks.f_50128_ || state4.m_60734_() == Blocks.f_50128_) {
                return;
            }
            BlockPos pos2 = CoroUtilBlock.blockPos((double)posLastNonWall.f_82479_, (double)posLastNonWall.f_82480_, (double)posLastNonWall.f_82481_);
            BlockState state2 = world.m_8055_(pos2);
            if (state2.m_60734_().m_284356_() == MapColor.f_283864_ || state2.m_60734_().m_284356_() == MapColor.f_283816_) {
                return;
            }
            amountWeHave = WeatherUtilBlock.trySpreadOnPos2(world, CoroUtilBlock.blockPos((double)posLastNonWall.f_82479_, (double)posLastNonWall.f_82480_, (double)posLastNonWall.f_82481_), amountWeHave, amountToAddPerXZ, 10, blockLayerable, maxBlockStackingAllowed);
        }
    }

    public static int trySpreadOnPos2(Level world, BlockPos posSpreadTo, int amount, int amountAllowedToAdd, int maxDropAllowed, Block blockLayerable, int maxBlockStackingAllowed) {
        int distForPlaceableBlocks;
        if (amount <= 0) {
            return amount;
        }
        if (!world.m_8055_(posSpreadTo.m_7918_(0, 1, 0)).m_60795_()) {
            return amount;
        }
        BlockState statePos = world.m_8055_(posSpreadTo);
        BlockPos posCheckNonAir = new BlockPos((Vec3i)posSpreadTo);
        BlockState stateCheckNonAir = world.m_8055_(posCheckNonAir);
        int depth = 0;
        while (stateCheckNonAir.m_60795_()) {
            posCheckNonAir = posCheckNonAir.m_7918_(0, -1, 0);
            stateCheckNonAir = world.m_8055_(posCheckNonAir);
            if (++depth <= maxDropAllowed) continue;
            return amount;
        }
        BlockPos posCheckPlaceable = new BlockPos((Vec3i)posCheckNonAir);
        BlockState stateCheckPlaceable = world.m_8055_(posCheckPlaceable);
        if (maxBlockStackingAllowed > 0) {
            boolean sandMode = false;
            if (blockLayerable == Blocks.f_50125_) {
                sandMode = false;
            } else if (blockLayerable == WeatherBlocks.BLOCK_SAND_LAYER.get()) {
                sandMode = true;
            }
            int foundBlocks = 0;
            BlockPos posCheckDownForStacks = new BlockPos((Vec3i)posCheckPlaceable);
            BlockState stateCheckDownForStacks = world.m_8055_(posCheckPlaceable);
            if (!sandMode && stateCheckPlaceable.m_60734_() == Blocks.f_50127_ || sandMode && stateCheckPlaceable.m_60734_() == Blocks.f_49992_) {
                while (!sandMode && stateCheckDownForStacks.m_60734_() == Blocks.f_50127_ || sandMode && stateCheckDownForStacks.m_60734_() == Blocks.f_49992_) {
                    if (++foundBlocks >= maxBlockStackingAllowed) {
                        return amount;
                    }
                    posCheckDownForStacks = posCheckDownForStacks.m_7918_(0, -1, 0);
                    stateCheckDownForStacks = world.m_8055_(posCheckDownForStacks);
                }
            }
        }
        for (distForPlaceableBlocks = 0; distForPlaceableBlocks < 10; ++distForPlaceableBlocks) {
            AABB aabbCompare = new AABB(posCheckPlaceable);
            VoxelShape voxelshape = Shapes.m_83064_((AABB)aabbCompare);
            boolean collided = Shapes.m_83157_((VoxelShape)stateCheckPlaceable.m_60812_((BlockGetter)world, posCheckPlaceable).m_83216_((double)posCheckPlaceable.m_123341_(), (double)posCheckPlaceable.m_123342_(), (double)posCheckPlaceable.m_123343_()), (VoxelShape)voxelshape, (BooleanOp)BooleanOp.f_82689_);
            if (stateCheckPlaceable.m_60734_() != blockLayerable && !collided && !stateCheckPlaceable.m_278721_()) {
                posCheckPlaceable = posCheckPlaceable.m_7918_(0, -1, 0);
                stateCheckPlaceable = world.m_8055_(posCheckPlaceable);
                continue;
            }
            if (stateCheckPlaceable.m_60783_((BlockGetter)world, posCheckPlaceable, Direction.UP) || stateCheckPlaceable.m_60734_() == blockLayerable) break;
            return amount;
        }
        if (distForPlaceableBlocks >= 10) {
            return amount;
        }
        if (!stateCheckPlaceable.m_60783_((BlockGetter)world, posCheckPlaceable, Direction.UP) && stateCheckPlaceable.m_60734_() != blockLayerable) {
            System.out.println("shouldnt be, failed a check somewhere!");
            return amount;
        }
        for (int i = 0; i < distForPlaceableBlocks; ++i) {
            world.m_46597_(posCheckNonAir.m_7918_(0, -i, 0), Blocks.f_50016_.m_49966_());
        }
        BlockPos posPlaceLayerable = new BlockPos((Vec3i)posCheckPlaceable);
        BlockState statePlaceLayerable = world.m_8055_(posPlaceLayerable);
        int amountToAdd = amountAllowedToAdd;
        while (amountAllowedToAdd > 0 && world.m_8055_(posPlaceLayerable.m_7918_(0, 1, 0)).m_60795_() && amountAllowedToAdd > 0) {
            int height;
            if (statePlaceLayerable.m_60734_() == blockLayerable && WeatherUtilBlock.getHeightForLayeredBlock(statePlaceLayerable) < layerableHeightPropMax) {
                height = WeatherUtilBlock.getHeightForLayeredBlock(statePlaceLayerable);
                if ((height += amountAllowedToAdd) > layerableHeightPropMax) {
                    amountAllowedToAdd = height - layerableHeightPropMax;
                    height = layerableHeightPropMax;
                } else {
                    amountAllowedToAdd = 0;
                }
                try {
                    world.m_46597_(posPlaceLayerable, WeatherUtilBlock.setBlockWithLayerState(blockLayerable, height));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (height != layerableHeightPropMax) continue;
                posPlaceLayerable = posPlaceLayerable.m_7918_(0, 1, 0);
                statePlaceLayerable = world.m_8055_(posPlaceLayerable);
                continue;
            }
            if (statePlaceLayerable.m_60783_((BlockGetter)world, posPlaceLayerable, Direction.UP)) {
                posPlaceLayerable = posPlaceLayerable.m_7918_(0, 1, 0);
                statePlaceLayerable = world.m_8055_(posPlaceLayerable);
                continue;
            }
            if (!statePlaceLayerable.m_60795_()) continue;
            height = amountAllowedToAdd;
            if (height > layerableHeightPropMax) {
                amountAllowedToAdd = height - layerableHeightPropMax;
                height = layerableHeightPropMax;
            } else {
                amountAllowedToAdd = 0;
            }
            try {
                world.m_46597_(posPlaceLayerable, WeatherUtilBlock.setBlockWithLayerState(blockLayerable, height));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (height != layerableHeightPropMax) continue;
            posPlaceLayerable = posPlaceLayerable.m_7918_(0, 1, 0);
            statePlaceLayerable = world.m_8055_(posPlaceLayerable);
        }
        if (amountAllowedToAdd < 0) {
            // empty if block
        }
        int amountAdded = amountToAdd - amountAllowedToAdd;
        return amount -= amountAdded;
    }

    public static int getHeightForAnyBlock(BlockState state) {
        Block block = state.m_60734_();
        if (block == Blocks.f_50125_) {
            return (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
        }
        if (block == WeatherBlocks.BLOCK_SAND_LAYER.get()) {
            return (Integer)state.m_61143_((Property)SandLayerBlock.LAYERS);
        }
        if (block == Blocks.f_49992_ || block == Blocks.f_50127_) {
            return 8;
        }
        if (block instanceof SlabBlock) {
            return 4;
        }
        if (block == Blocks.f_50016_) {
            return 0;
        }
        return 8;
    }

    public static int getHeightForLayeredBlock(BlockState state) {
        if (state.m_60734_() == Blocks.f_50125_) {
            return (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
        }
        if (state.m_60734_() == WeatherBlocks.BLOCK_SAND_LAYER.get()) {
            return (Integer)state.m_61143_((Property)SandLayerBlock.LAYERS);
        }
        if (state.m_60734_() == Blocks.f_49992_ || state.m_60734_() == Blocks.f_50127_) {
            return 8;
        }
        return 0;
    }

    public static BlockState setBlockWithLayerState(Block block, int height) {
        boolean solidBlockUnderMode = true;
        if (block == Blocks.f_50125_) {
            if (height == layerableHeightPropMax && solidBlockUnderMode) {
                return Blocks.f_50127_.m_49966_();
            }
            return (BlockState)block.m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(height));
        }
        if (block == WeatherBlocks.BLOCK_SAND_LAYER.get()) {
            if (height == layerableHeightPropMax && solidBlockUnderMode) {
                return Blocks.f_49992_.m_49966_();
            }
            return (BlockState)block.m_49966_().m_61124_((Property)SandLayerBlock.LAYERS, (Comparable)Integer.valueOf(height));
        }
        return null;
    }

    public static BlockPos getPrecipitationHeightSafe(Level world, BlockPos pos) {
        return WeatherUtilBlock.getPrecipitationHeightSafe(world, pos, Heightmap.Types.MOTION_BLOCKING);
    }

    public static BlockPos getPrecipitationHeightSafe(Level world, BlockPos pos, Heightmap.Types heightmapType) {
        if (world.m_46805_(pos)) {
            return world.m_5452_(heightmapType, pos);
        }
        return new BlockPos(pos.m_123341_(), -255, pos.m_123343_());
    }
}

