/*
 * Decompiled with CFR 0.152.
 */
package weather2.client.tile;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import weather2.ClientTickHandler;
import weather2.WeatherBlocks;
import weather2.blockentity.AnemometerBlockEntity;
import weather2.client.entity.model.AnemometerModel;
import weather2.weathersystem.WeatherManagerClient;
import weather2.weathersystem.wind.WindManager;

public class AnemometerEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static Map<String, ResourceLocation> resLocMap = Maps.newHashMap();
    private static Map<String, Material> materialMap = Maps.newHashMap();
    private final Block block = (Block)WeatherBlocks.BLOCK_ANEMOMETER.get();
    protected final AnemometerModel model = new AnemometerModel(Minecraft.m_91087_().m_167973_().m_171103_(AnemometerModel.LAYER_LOCATION));

    public static Material getTEMaterial(String path) {
        return materialMap.computeIfAbsent(path, m -> AnemometerEntityRenderer.createTEMaterial(path));
    }

    private static Material createTEMaterial(String path) {
        return new Material(TextureAtlas.f_118259_, AnemometerEntityRenderer.getTextureTE(path));
    }

    public static ResourceLocation getTextureTE(String path) {
        return AnemometerEntityRenderer.getTexture(String.format("textures/blocks/te/%s.png", path));
    }

    public static ResourceLocation getTexture(String path) {
        return resLocMap.computeIfAbsent(path, k -> AnemometerEntityRenderer.getResLoc(path));
    }

    private static ResourceLocation getResLoc(String path) {
        return new ResourceLocation("weather2", path);
    }

    public static void renderModel(Material material, Model model, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        model.m_7695_(stack, buffer.m_6299_(model.m_103119_(material.m_119203_())), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public AnemometerEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void m_6922_(T te, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        this.model.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        ModelPart root = this.model.m_142109_();
        root.f_104200_ += 8.0f;
        root.f_104201_ += 8.0f;
        root.f_104202_ += 8.0f;
        root.f_104203_ = (float)((double)root.f_104203_ + Math.toRadians(180.0));
        root.f_104204_ = (float)((double)root.f_104204_ + Math.toRadians(180.0));
        root.f_104201_ -= 32.0f;
        ModelPart top = this.model.m_142109_().m_171324_("base").m_171324_("top");
        if (top != null) {
            boolean shaking;
            float lerpAngle;
            WeatherManagerClient weatherMan = ClientTickHandler.weatherManager;
            if (weatherMan == null) {
                return;
            }
            WindManager windMan = weatherMan.getWindManager();
            if (windMan == null) {
                return;
            }
            float renderAngle = lerpAngle = (float)Mth.m_14139_((double)partialTicks, (double)((AnemometerBlockEntity)((Object)te)).smoothAnglePrev, (double)((AnemometerBlockEntity)((Object)te)).smoothAngle);
            top.f_104204_ = (float)Math.toRadians(renderAngle);
            boolean bl = shaking = ((AnemometerBlockEntity)((Object)te)).smoothAngleRotationalVel > 45.0f;
            if (shaking) {
                Random rand = new Random(te.m_58904_().m_46467_());
                top.f_104203_ = (float)((double)(rand.nextFloat() - rand.nextFloat()) * Math.toRadians(7.0));
                top.f_104205_ = (float)((double)(rand.nextFloat() - rand.nextFloat()) * Math.toRadians(7.0));
            }
        }
        AnemometerEntityRenderer.renderModel(AnemometerEntityRenderer.getTEMaterial("anemometer"), (Model)this.model, stack, buffer, combinedLightIn, combinedOverlayIn);
    }
}

