/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import weather2.ClientTickHandler;
import weather2.ClientWeatherProxy;
import weather2.config.ConfigMisc;
import weather2.config.ConfigStorm;
import weather2.weathersystem.storm.StormObject;

public final class ClientWeatherHelper {
    private static ClientWeatherHelper instance;
    private float curPrecipStr = 0.0f;
    private float curPrecipStrTarget = 0.0f;
    private float curOvercastStr = 0.0f;
    private float curOvercastStrTarget = 0.0f;

    private ClientWeatherHelper() {
    }

    public static ClientWeatherHelper get() {
        if (instance == null) {
            instance = new ClientWeatherHelper();
        }
        return instance;
    }

    public void reset() {
        ClientWeatherHelper.instance.curPrecipStr = 0.0f;
        ClientWeatherHelper.instance.curPrecipStrTarget = 0.0f;
        ClientWeatherHelper.instance.curOvercastStr = 0.0f;
        ClientWeatherHelper.instance.curOvercastStrTarget = 0.0f;
    }

    public void tick() {
        this.tickRainRates();
    }

    public float getPrecipitationStrength(Player entP) {
        return this.getPrecipitationStrength(entP, false);
    }

    public float getPrecipitationStrength(Player entP, boolean forOvercast) {
        if (entP == null) {
            return 0.0f;
        }
        double maxStormDist = 384.0;
        Vec3 plPos = new Vec3(entP.m_20185_(), (double)StormObject.static_YPos_layer0, entP.m_20189_());
        ClientTickHandler.getClientWeather();
        StormObject storm = ClientTickHandler.weatherManager.getClosestStorm(plPos, maxStormDist, StormObject.STATE_FORMING, -1, true);
        boolean closeEnough = false;
        double stormDist = 9999.0;
        float tempAdj = 1.0f;
        float sizeToUse = 0.0f;
        float overcastModeMinPrecip = 0.23f;
        overcastModeMinPrecip = ClientTickHandler.weatherManager.vanillaRainAmountOnServer;
        if (storm != null) {
            sizeToUse = storm.size;
            if (forOvercast) {
                sizeToUse *= 1.0f;
            }
            if ((double)sizeToUse > (stormDist = storm.pos.m_82554_(plPos))) {
                closeEnough = true;
            }
        }
        if (closeEnough) {
            double stormIntensity = ((double)sizeToUse - stormDist) / (double)sizeToUse;
            tempAdj = 1.0f;
            if (storm.levelCurIntensityStage == StormObject.STATE_NORMAL && stormIntensity > 0.3) {
                stormIntensity = 0.3;
            }
            if (ConfigStorm.Storm_NoRainVisual) {
                stormIntensity = 0.0;
            }
            if (forOvercast && stormIntensity < (double)overcastModeMinPrecip) {
                stormIntensity = overcastModeMinPrecip;
            }
            if (forOvercast) {
                this.curOvercastStrTarget = (float)stormIntensity;
            } else {
                this.curPrecipStrTarget = (float)stormIntensity;
            }
        } else if (!ClientTickHandler.clientConfigData.overcastMode) {
            if (forOvercast) {
                this.curOvercastStrTarget = 0.0f;
            } else {
                this.curPrecipStrTarget = 0.0f;
            }
        } else if (ClientTickHandler.weatherManager.isVanillaRainActiveOnServer) {
            if (forOvercast) {
                this.curOvercastStrTarget = overcastModeMinPrecip;
            } else {
                this.curPrecipStrTarget = overcastModeMinPrecip;
            }
        } else if (forOvercast) {
            this.curOvercastStrTarget = 0.0f;
        } else {
            this.curPrecipStrTarget = 0.0f;
        }
        if (forOvercast) {
            if ((double)this.curOvercastStr < 0.002 && this.curOvercastStr > -0.002f) {
                return 0.0f;
            }
            return this.curOvercastStr * tempAdj;
        }
        if ((double)this.curPrecipStr < 0.002 && this.curPrecipStr > -0.002f) {
            return 0.0f;
        }
        return this.curPrecipStr * tempAdj;
    }

    public void controlVisuals(boolean precipitating) {
        Minecraft mc = Minecraft.m_91087_();
        ClientTickHandler.getClientWeather();
        ClientWeatherProxy weather = ClientWeatherProxy.get();
        float rainAmount = weather.getVanillaRainAmount();
        float visualDarknessAmplifier = 0.5f;
        visualDarknessAmplifier = 1.0f;
        if (!ConfigMisc.Aesthetic_Only_Mode) {
            if (precipitating) {
                mc.f_91073_.m_6106_().m_5565_(rainAmount > 0.0f);
                mc.f_91073_.m_46734_(rainAmount * visualDarknessAmplifier);
                mc.f_91073_.m_46707_(rainAmount * visualDarknessAmplifier);
            } else if (!ClientTickHandler.clientConfigData.overcastMode) {
                mc.f_91073_.m_6106_().m_5565_(false);
                mc.f_91073_.m_46734_(0.0f);
                mc.f_91073_.m_46707_(0.0f);
            } else if (ClientTickHandler.weatherManager.isVanillaRainActiveOnServer) {
                mc.f_91073_.m_6106_().m_5565_(true);
                mc.f_91073_.m_46734_(rainAmount * visualDarknessAmplifier);
                mc.f_91073_.m_46707_(rainAmount * visualDarknessAmplifier);
            }
        }
    }

    public void tickRainRates() {
        float rateChange = 0.0015f;
        if (this.curOvercastStr > this.curOvercastStrTarget) {
            this.curOvercastStr -= rateChange;
        } else if (this.curOvercastStr < this.curOvercastStrTarget) {
            this.curOvercastStr += rateChange;
        }
        if (this.curPrecipStr > this.curPrecipStrTarget) {
            this.curPrecipStr -= rateChange;
        } else if (this.curPrecipStr < this.curPrecipStrTarget) {
            this.curPrecipStr += rateChange;
        }
    }
}

