/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumextras;

import com.mojang.blaze3d.platform.Window;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import toni.sodiumextras.SodiumExtras;
import toni.sodiumextras.mixins.impl.borderless.accessors.MainWindowAccessor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="sodiumextras")
public class EmbyConfig {
    public static final Marker IT = MarkerManager.getMarker((String)"Config");
    public static final ForgeConfigSpec SPECS;
    public static final ForgeConfigSpec.EnumValue<FullScreenMode> fullScreen;
    public static final ForgeConfigSpec.EnumValue<FPSDisplayMode> fpsDisplayMode;
    public static final ForgeConfigSpec.EnumValue<FPSDisplayGravity> fpsDisplayGravity;
    public static final ForgeConfigSpec.EnumValue<FPSDisplaySystemMode> fpsDisplaySystemMode;
    public static final ForgeConfigSpec.IntValue fpsDisplayMargin;
    public static final ForgeConfigSpec.BooleanValue fpsDisplayShadow;
    public static volatile int fpsDisplayMarginCache;
    public static volatile boolean fpsDisplayShadowCache;
    public static final ForgeConfigSpec.BooleanValue fog;
    public static final ForgeConfigSpec.IntValue cloudsHeight;
    public static final ForgeConfigSpec.EnumValue<ChunkFadeSpeed> chunkFadeSpeed;
    public static volatile boolean fogCache;
    public static volatile int cloudsHeightCache;
    public static final ForgeConfigSpec.EnumValue<DarknessMode> darknessMode;
    public static final ForgeConfigSpec.BooleanValue darknessOnOverworld;
    public static final ForgeConfigSpec.BooleanValue darknessOnNether;
    public static final ForgeConfigSpec.DoubleValue darknessNetherFogBright;
    public static final ForgeConfigSpec.BooleanValue darknessOnEnd;
    public static final ForgeConfigSpec.DoubleValue darknessEndFogBright;
    public static final ForgeConfigSpec.BooleanValue darknessByDefault;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> darknessDimensionWhiteList;
    public static final ForgeConfigSpec.BooleanValue darknessOnNoSkyLight;
    public static final ForgeConfigSpec.BooleanValue darknessBlockLightOnly;
    public static final ForgeConfigSpec.BooleanValue darknessAffectedByMoonPhase;
    public static final ForgeConfigSpec.DoubleValue darknessNewMoonBright;
    public static final ForgeConfigSpec.DoubleValue darknessFullMoonBright;
    public static volatile boolean darknessOnOverworldCache;
    public static volatile boolean darknessOnNetherCache;
    public static volatile double darknessNetherFogBrightCache;
    public static volatile boolean darknessOnEndCache;
    public static volatile double darknessEndFogBrightCache;
    public static volatile boolean darknessByDefaultCache;
    public static volatile boolean darknessOnNoSkyLightCache;
    public static volatile boolean darknessBlockLightOnlyCache;
    public static volatile boolean darknessAffectedByMoonPhaseCache;
    public static volatile double darknessNewMoonBrightCache;
    public static volatile double darknessFullMoonBrightCache;
    public static final ForgeConfigSpec.BooleanValue hideJREI;
    public static final ForgeConfigSpec.BooleanValue fontShadows;
    public static volatile boolean hideJREICache;
    public static volatile boolean fontShadowsCache;
    public static final ForgeConfigSpec.BooleanValue tileEntityDistanceCulling;
    public static final ForgeConfigSpec.IntValue tileEntityCullingDistanceX;
    public static final ForgeConfigSpec.IntValue tileEntityCullingDistanceY;
    public static final ForgeConfigSpec.BooleanValue entityDistanceCulling;
    public static final ForgeConfigSpec.IntValue entityCullingDistanceX;
    public static final ForgeConfigSpec.IntValue entityCullingDistanceY;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> entityWhitelist;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> tileEntityWhitelist;
    public static volatile boolean tileEntityDistanceCullingCache;
    public static volatile int tileEntityCullingDistanceXCache;
    public static volatile int tileEntityCullingDistanceYCache;
    public static volatile boolean entityDistanceCullingCache;
    public static volatile int entityCullingDistanceXCache;
    public static volatile int entityCullingDistanceYCache;
    public static final ForgeConfigSpec.EnumValue<AttachMode> borderlessAttachModeF11;
    public static final ForgeConfigSpec.BooleanValue fastLanguageReload;
    public static boolean fastLanguageReloadCache;
    public static volatile boolean dynLightsOnEntitiesCache;
    public static volatile boolean dynLightsOnTileEntitiesCache;
    public static volatile boolean dynLightsUpdateOnPositionChangeCache;
    private static final String[] DEFAULT_TILE_ENTITIES_WHITELIST;
    private static final String[] DEFAULT_ENTITIES_WHITELIST;

    public static boolean isLoaded() {
        return SPECS.isLoaded();
    }

    public static void setFullScreenMode(Options opts, FullScreenMode value) {
        fullScreen.set((Object)value);
        opts.f_92052_.m_231514_((Object)(value != FullScreenMode.WINDOWED ? 1 : 0));
        Minecraft client = Minecraft.m_91087_();
        Window window = client.m_91268_();
        if (window.m_85440_() != ((Boolean)opts.f_92052_.m_231551_()).booleanValue()) {
            window.m_85438_();
            opts.f_92052_.m_231514_((Object)window.m_85440_());
        }
        if (((Boolean)opts.f_92052_.m_231551_()).booleanValue()) {
            ((MainWindowAccessor)window).setDirty(true);
            window.m_85437_();
        }
        SPECS.save();
    }

    @SubscribeEvent
    public static void updateCache(ModConfigEvent ignored) {
        SodiumExtras.LOGGER.info(IT, "Updating config cache");
        fpsDisplayMarginCache = (Integer)fpsDisplayMargin.get();
        fpsDisplayShadowCache = (Boolean)fpsDisplayShadow.get();
        fogCache = (Boolean)fog.get();
        cloudsHeightCache = (Integer)cloudsHeight.get();
        darknessOnOverworldCache = (Boolean)darknessOnOverworld.get();
        darknessOnNetherCache = (Boolean)darknessOnNether.get();
        darknessNetherFogBrightCache = (Double)darknessNetherFogBright.get();
        darknessOnEndCache = (Boolean)darknessOnEnd.get();
        darknessEndFogBrightCache = (Double)darknessEndFogBright.get();
        darknessByDefaultCache = (Boolean)darknessByDefault.get();
        darknessOnNoSkyLightCache = (Boolean)darknessOnNoSkyLight.get();
        darknessBlockLightOnlyCache = (Boolean)darknessBlockLightOnly.get();
        darknessAffectedByMoonPhaseCache = (Boolean)darknessAffectedByMoonPhase.get();
        darknessNewMoonBrightCache = (Double)darknessNewMoonBright.get();
        darknessFullMoonBrightCache = (Double)darknessFullMoonBright.get();
        hideJREICache = (Boolean)hideJREI.get();
        fontShadowsCache = (Boolean)fontShadows.get();
        tileEntityDistanceCullingCache = (Boolean)tileEntityDistanceCulling.get();
        tileEntityCullingDistanceXCache = (Integer)tileEntityCullingDistanceX.get();
        tileEntityCullingDistanceYCache = (Integer)tileEntityCullingDistanceY.get();
        entityDistanceCullingCache = (Boolean)entityDistanceCulling.get();
        entityCullingDistanceXCache = (Integer)entityCullingDistanceX.get();
        entityCullingDistanceYCache = (Integer)entityCullingDistanceY.get();
        fastLanguageReloadCache = (Boolean)fastLanguageReload.get();
        SodiumExtras.LOGGER.info(IT, "Cache updated successfully");
    }

    static {
        darknessOnOverworldCache = true;
        DEFAULT_TILE_ENTITIES_WHITELIST = new String[]{"waterframes:*"};
        DEFAULT_ENTITIES_WHITELIST = new String[]{"minecraft:ghast", "minecraft:ender_dragon", "iceandfire:*", "create:*"};
        ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        BUILDER.push("embeddiumextras");
        BUILDER.push("general");
        fullScreen = BUILDER.comment(new String[]{"Set Fullscreen mode", "Borderless let you change between screens more faster and move your mouse across monitors"}).defineEnum("fullscreen", (Enum)FullScreenMode.WINDOWED);
        fpsDisplayMode = BUILDER.comment(new String[]{"Configure FPS Display mode", "Complete mode gives you min FPS count and average count"}).defineEnum("fpsDisplay", (Enum)FPSDisplayMode.ADVANCED);
        fpsDisplayGravity = BUILDER.comment(new String[]{"Configure FPS Display gravity", "Places counter on specified corner of your screen"}).defineEnum("fpsDisplayGravity", (Enum)FPSDisplayGravity.LEFT);
        fpsDisplaySystemMode = BUILDER.comment("Shows GPU and memory usage onto FPS display").defineEnum("fpsDisplaySystem", (Enum)FPSDisplaySystemMode.OFF);
        fpsDisplayMargin = BUILDER.comment(new String[]{"Configure FPS Display margin", "Give some space between corner and text"}).defineInRange("fpsDisplayMargin", 12, 0, 48);
        fpsDisplayShadow = BUILDER.comment(new String[]{"Toggle FPS Display shadow", "In case sometimes you can't see the text"}).define("fpsDisplayShadow", false);
        BUILDER.pop();
        BUILDER.push("quality");
        fog = BUILDER.comment(new String[]{"Toggle fog feature", "Fog was a vanilla feature, toggling off may increases performance"}).define("fog", true);
        cloudsHeight = BUILDER.comment(new String[]{"Raise clouds", "Modify clouds height perfect for a adaptative world experience"}).defineInRange("cloudsHeight", 192, 0, 512);
        chunkFadeSpeed = BUILDER.comment(new String[]{"Chunks fade in speed", "This option doesn't affect performance, just changes speed"}).defineEnum("chunkFadeSpeed", (Enum)ChunkFadeSpeed.SLOW);
        BUILDER.push("darkness");
        darknessMode = BUILDER.comment(new String[]{"Configure Darkness Mode", "Each config changes what is considered 'true darkness'"}).defineEnum("mode", (Enum)DarknessMode.OFF);
        darknessOnOverworld = BUILDER.comment("Toggle Darkness on Overworld dimension").define("enableOnOverworld", true);
        darknessOnNether = BUILDER.comment("Toggle Darkness on Nether dimension").define("enableOnNether", false);
        darknessNetherFogBright = BUILDER.comment("Configure fog brightness on nether when darkness is enabled").defineInRange("netherFogBright", 0.5, 0.0, 1.0);
        darknessOnEnd = BUILDER.comment("Toggle Darkness on End dimension").define("enableOnEnd", false);
        darknessEndFogBright = BUILDER.comment("Configure fog brightness on nether when darkness is enabled").defineInRange("endFogBright", 0.5, 0.0, 1.0);
        darknessByDefault = BUILDER.comment("Toggle Darkness default mode for modded dimensions").define("valueByDefault", false);
        darknessDimensionWhiteList = BUILDER.comment(new String[]{"List of all dimensions to use True Darkness", "This option overrides 'valueByDefault' state"}).defineListAllowEmpty(Collections.singletonList("dimensionWhitelist"), Collections::emptyList, s -> s.toString().contains(":"));
        darknessOnNoSkyLight = BUILDER.comment("Toggle darkness when dimension has no SkyLight").define("enableOnNoSkyLight", false);
        darknessBlockLightOnly = BUILDER.comment(new String[]{"Disables all bright sources of darkness like moon or fog", "Only affects darkness effect"}).define("enableBlockLightOnly", false);
        darknessAffectedByMoonPhase = BUILDER.comment("Toggles if moon phases affects darkness in the overworld").define("affectedByMoonPhase", true);
        darknessFullMoonBright = BUILDER.comment("Configure max moon brightness level with darkness").defineInRange("fullMoonBright", 0.25, 0.0, 1.0);
        darknessNewMoonBright = BUILDER.comment("Configure min moon brightness level with darkness").defineInRange("newMoonBright", 0.0, 0.0, 1.0);
        BUILDER.pop(2);
        BUILDER.push("performance");
        hideJREI = BUILDER.comment(new String[]{"Toggles JREI item rendering until searching", "Increases performance a little bit and cleans your screen when you don't want to use it"}).define("hideJREI", false);
        fontShadows = BUILDER.comment(new String[]{"Toggles Minecraft Fonts shadows", "Depending of the case may increase performance", "Gives a flat style text"}).define("fontShadows", true);
        BUILDER.push("distanceCulling");
        BUILDER.push("tileEntities");
        tileEntityDistanceCulling = BUILDER.comment(new String[]{"Toggles distance culling for Block Entities", "Maybe you use another mod for that :("}).define("enable", true);
        tileEntityCullingDistanceX = BUILDER.comment(new String[]{"Configure horizontal max distance before cull Block entities", "Value is squared, default was 64^2 (or 64x64)"}).defineInRange("cullingMaxDistanceX", 4096, 0, Integer.MAX_VALUE);
        tileEntityCullingDistanceY = BUILDER.comment(new String[]{"Configure vertical max distance before cull Block entities", "Value is raw"}).defineInRange("cullingMaxDistanceY", 32, 0, 512);
        tileEntityWhitelist = BUILDER.comment(new String[]{"List of all Block Entities to be ignored by distance culling", "Uses ResourceLocation to identify it", "Example 1: \"minecraft:chest\" - Ignores chests only", "Example 2: \"ae2:*\" - ignores all Block entities from Applied Energetics 2"}).defineListAllowEmpty(Collections.singletonList("whitelist"), () -> Arrays.asList(DEFAULT_TILE_ENTITIES_WHITELIST), s -> s.toString().contains(":"));
        BUILDER.pop();
        BUILDER.push("entities");
        entityDistanceCulling = BUILDER.comment(new String[]{"Toggles distance culling for entities", "Maybe you use another mod for that :("}).define("enable", true);
        entityCullingDistanceX = BUILDER.comment(new String[]{"Configure horizontal max distance before cull entities", "Value is squared, default was 64^2 (or 64x64)"}).defineInRange("cullingMaxDistanceX", 4096, 0, Integer.MAX_VALUE);
        entityCullingDistanceY = BUILDER.comment(new String[]{"Configure vertical max distance before cull entities", "Value is raw"}).defineInRange("cullingMaxDistanceY", 32, 0, 512);
        entityWhitelist = BUILDER.comment(new String[]{"List of all Entities to be ignored by distance culling", "Uses ResourceLocation to identify it", "Example 1: \"minecraft:bat\" - Ignores bats only", "Example 2: \"alexsmobs:*\" - ignores all entities for alexmobs mod"}).defineListAllowEmpty(Collections.singletonList("whitelist"), () -> Arrays.asList(DEFAULT_ENTITIES_WHITELIST), s -> s.toString().contains(":"));
        BUILDER.pop(3);
        BUILDER.push("others");
        borderlessAttachModeF11 = BUILDER.comment("Configure if borderless fullscreen option should be attached to F11 or replace vanilla fullscreen").defineEnum("borderlessAttachModeOnF11", (Enum)AttachMode.OFF);
        fastLanguageReload = BUILDER.comment(new String[]{"Toggles fast language reload", "Embeddedt points it maybe cause troubles to JEI, so \u00bfwhy not add it as a toggleable option?"}).define("fastLanguageReload", true);
        BUILDER.pop();
        SPECS = BUILDER.build();
    }

    public static enum FullScreenMode {
        WINDOWED,
        BORDERLESS,
        FULLSCREEN;


        public static FullScreenMode nextOf(FullScreenMode current) {
            return switch (current.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> BORDERLESS;
                case 1 -> FULLSCREEN;
                case 2 -> WINDOWED;
            };
        }

        public static FullScreenMode nextBorderless(FullScreenMode current) {
            return switch (current.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 1, 2 -> WINDOWED;
                case 0 -> BORDERLESS;
            };
        }

        public static FullScreenMode nextFullscreen(FullScreenMode current) {
            return switch (current.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 1, 2 -> WINDOWED;
                case 0 -> FULLSCREEN;
            };
        }

        public static FullScreenMode getVanillaConfig() {
            return (Boolean)Minecraft.m_91087_().f_91066_.m_231829_().m_231551_() != false ? BORDERLESS : WINDOWED;
        }

        public boolean isBorderless() {
            return this == BORDERLESS;
        }
    }

    public static enum FPSDisplayMode {
        OFF,
        SIMPLE,
        ADVANCED;


        public boolean off() {
            return this == OFF;
        }
    }

    public static enum FPSDisplayGravity {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum FPSDisplaySystemMode {
        OFF,
        ON,
        GPU,
        RAM;


        public boolean ram() {
            return this == RAM || this == ON;
        }

        public boolean gpu() {
            return this == GPU || this == ON;
        }

        public boolean off() {
            return this == OFF;
        }
    }

    public static enum ChunkFadeSpeed {
        OFF,
        FAST,
        SLOW;

    }

    public static enum DarknessMode {
        PITCH_BLACK(0.0f),
        TOTAL_DARKNESS(0.04f),
        DARK(0.08f),
        DIM(0.12f),
        OFF(-1.0f);

        public final float value;

        private DarknessMode(float value) {
            this.value = value;
        }
    }

    public static enum AttachMode {
        ATTACH,
        REPLACE,
        OFF;

    }

    public static enum DynLightsSpeed {
        OFF(-1),
        SLOW(750),
        NORMAL(500),
        FAST(250),
        SUPERFAST(100),
        FASTESTS(50),
        REALTIME(-1);

        private final int delay;

        private DynLightsSpeed(int delay) {
            this.delay = delay;
        }

        public int getDelay() {
            return this.delay;
        }

        public boolean off() {
            return this == OFF;
        }
    }
}

