/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.projectile.PoisonNeedle;
import com.aetherteam.aether.item.AetherItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AechorPlant
extends PathfinderMob
implements RangedAttackMob {
    private static final EntityDataAccessor<Integer> DATA_SIZE_ID = SynchedEntityData.m_135353_(AechorPlant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_POISON_REMAINING_ID = SynchedEntityData.m_135353_(AechorPlant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_TARGETING_ENTITY_ID = SynchedEntityData.m_135353_(AechorPlant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float sinage;
    private float sinageAdd;

    public AechorPlant(EntityType<? extends AechorPlant> type, Level level) {
        super(type, level);
        this.f_21364_ = 5;
        this.setPoisonRemaining(2);
        if (level.m_5776_()) {
            this.sinage = this.m_217043_().m_188501_() * 6.0f;
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 60, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder m_21552_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_SIZE_ID, (Object)0);
        this.m_20088_().m_135372_(DATA_POISON_REMAINING_ID, (Object)0);
        this.m_20088_().m_135372_(DATA_TARGETING_ENTITY_ID, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        if (DATA_SIZE_ID.equals(dataAccessor)) {
            this.m_6210_();
        }
        super.m_7350_(dataAccessor);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        this.setSize(this.m_217043_().m_188503_(4) + 1);
        this.m_146884_(Vec3.m_82539_((Vec3i)this.m_20183_()));
        return spawnData;
    }

    public static boolean checkAechorPlantSpawnRules(EntityType<? extends AechorPlant> aechorPlant, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return level.m_8055_(pos.m_7495_()).m_204336_(AetherTags.Blocks.AECHOR_PLANT_SPAWNABLE_ON) && level.m_45524_(pos, 0) > 8 && level.m_46791_() != Difficulty.PEACEFUL && (reason != MobSpawnType.NATURAL || random.m_188503_(10) == 0 && !AechorPlant.inRadiusOfFlowers(level, pos, 10) && !AechorPlant.inRadiusOfEnchantedFlowers(level, pos, 40));
    }

    public static boolean inRadiusOfFlowers(LevelAccessor level, BlockPos pos, int radius) {
        for (int xOffset = -radius; xOffset <= radius; ++xOffset) {
            for (int yOffset = -radius; yOffset <= radius; ++yOffset) {
                for (int zOffset = -radius; zOffset <= radius; ++zOffset) {
                    if (xOffset * xOffset + zOffset * zOffset > radius * radius || !level.m_8055_(pos.m_7918_(xOffset, yOffset, zOffset)).m_204336_(AetherTags.Blocks.AECHOR_PLANT_SPAWNABLE_DETERRENT)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean inRadiusOfEnchantedFlowers(LevelAccessor level, BlockPos pos, int radius) {
        for (int xOffset = -radius; xOffset <= radius; ++xOffset) {
            for (int yOffset = -radius; yOffset <= radius; ++yOffset) {
                for (int zOffset = -radius; zOffset <= radius; ++zOffset) {
                    if (xOffset * xOffset + zOffset * zOffset > radius * radius || !level.m_8055_(pos.m_7918_(xOffset, yOffset, zOffset)).m_204336_(AetherTags.Blocks.AECHOR_PLANT_SPAWNABLE_DETERRENT) || !level.m_8055_(pos.m_7918_(xOffset, yOffset, zOffset).m_7495_()).m_204336_(AetherTags.Blocks.ENCHANTED_GRASS)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_204336_(AetherTags.Blocks.AECHOR_PLANT_SPAWNABLE_ON) && !this.m_20159_()) {
            this.m_6074_();
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.m_5448_() != null) {
                this.setTargetingEntity(true);
            } else if (this.m_5448_() == null && this.getTargetingEntity()) {
                this.setTargetingEntity(false);
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().m_5776_()) {
            this.sinage += this.sinageAdd;
            this.sinageAdd = this.f_20916_ > 0 ? 0.45f : (this.getTargetingEntity() ? 0.3f : 0.15f);
            if (this.sinage >= (float)Math.PI * 2) {
                this.sinage -= (float)Math.PI * 2;
            }
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_((Item)AetherItems.SKYROOT_BUCKET.get()) && this.getPoisonRemaining() > 0) {
            this.setPoisonRemaining(this.getPoisonRemaining() - 1);
            ItemStack itemStack1 = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)((Item)AetherItems.SKYROOT_POISON_BUCKET.get()).m_7968_());
            player.m_21008_(hand, itemStack1);
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    public void m_5997_(double x, double y, double z) {
    }

    protected void m_6135_() {
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.f_20916_ == 0) {
            for (int i = 0; i < 8; ++i) {
                double d1 = this.m_20185_() + (double)(this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.5;
                double d2 = this.m_20186_() + 0.25 + (double)(this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.5;
                double d3 = this.m_20189_() + (double)(this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.5;
                double d4 = (double)(this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.5;
                double d5 = (double)(this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.5;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, d1, d2, d3, d4, 0.25, d5);
            }
        }
        return super.m_6469_(source, amount);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        PoisonNeedle needle = new PoisonNeedle(this.m_9236_(), (LivingEntity)this);
        double x = target.m_20185_() - this.m_20185_();
        double z = target.m_20189_() - this.m_20189_();
        double sqrt = Math.sqrt(x * x + z * z + 0.1);
        double y = 0.1 + sqrt * 0.5 + (this.m_20186_() - target.m_20186_()) * 0.25;
        double distance = 1.5 / sqrt;
        needle.m_6686_(x *= distance, y + 0.5, z *= distance, 0.285f + (float)y * 0.08f, 1.0f);
        this.m_5496_((SoundEvent)AetherSoundEvents.ENTITY_AECHOR_PLANT_SHOOT.get(), 2.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)needle);
    }

    public int getSize() {
        return (Integer)this.m_20088_().m_135370_(DATA_SIZE_ID);
    }

    public void setSize(int size) {
        this.m_20088_().m_135381_(DATA_SIZE_ID, (Object)size);
    }

    public int getPoisonRemaining() {
        return (Integer)this.m_20088_().m_135370_(DATA_POISON_REMAINING_ID);
    }

    public void setPoisonRemaining(int poisonRemaining) {
        this.m_20088_().m_135381_(DATA_POISON_REMAINING_ID, (Object)poisonRemaining);
    }

    public boolean getTargetingEntity() {
        return (Boolean)this.m_20088_().m_135370_(DATA_TARGETING_ENTITY_ID);
    }

    public void setTargetingEntity(boolean targetingEntity) {
        this.m_20088_().m_135381_(DATA_TARGETING_ENTITY_ID, (Object)targetingEntity);
    }

    public float getSinage() {
        return this.sinage;
    }

    public float getSinageAdd() {
        return this.sinageAdd;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)AetherSoundEvents.ENTITY_AECHOR_PLANT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_AECHOR_PLANT_DEATH.get();
    }

    public boolean m_142582_(Entity entity) {
        return (double)this.m_20270_(entity) <= 8.0 && super.m_142582_(entity);
    }

    public EntityDimensions m_6972_(Pose pose) {
        float width = 0.75f + (float)this.getSize() * 0.125f;
        float height = 0.5f + (float)this.getSize() * 0.075f;
        return EntityDimensions.m_20398_((float)width, (float)height);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ / 1.15f;
    }

    public double m_6049_() {
        return this.m_20202_() != null && this.m_20202_().m_6047_() ? 0.1 : 0.275;
    }

    protected boolean m_8028_() {
        return true;
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return effect.m_19544_() != AetherEffects.INEBRIATION.get() && super.m_7301_(effect);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Size", this.getSize());
        tag.m_128405_("Poison Remaining", this.getPoisonRemaining());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Size")) {
            this.setSize(tag.m_128451_("Size"));
        }
        if (tag.m_128441_("Poison Remaining")) {
            this.setPoisonRemaining(tag.m_128451_("Poison Remaining"));
        }
    }
}

