/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.ai.goal;

import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public class MostDamageTargetGoal
extends TargetGoal {
    private static final TargetingConditions HURT_BY_TARGETING = TargetingConditions.m_148352_().m_148355_().m_26893_();
    private final Object2DoubleMap<LivingEntity> attackers = new Object2DoubleOpenHashMap();
    private int lastHurtTimestamp;
    @Nullable
    private LivingEntity primaryTarget;
    private final float calmDownRate;
    private int aiTicks;

    public MostDamageTargetGoal(Mob mob) {
        this(mob, 1.0f);
    }

    public MostDamageTargetGoal(Mob mob, float calmDownRate) {
        super(mob, true);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.calmDownRate = calmDownRate;
    }

    public boolean m_8036_() {
        this.tickAggro();
        if (this.attackers.isEmpty()) {
            return false;
        }
        int mobTimestamp = this.f_26135_.m_21213_();
        LivingEntity lastAttacker = this.f_26135_.m_21188_();
        if (lastAttacker != null && mobTimestamp != this.lastHurtTimestamp) {
            this.primaryTarget = this.getStrongestAttacker();
        }
        return this.primaryTarget != null;
    }

    public boolean m_8045_() {
        this.tickAggro();
        return this.f_26135_.m_21213_() == this.lastHurtTimestamp && this.f_26135_.m_5448_() != null && !this.f_26135_.m_5448_().m_21224_() && super.m_8045_();
    }

    public void m_8056_() {
        this.f_26135_.m_6710_(this.primaryTarget);
        this.lastHurtTimestamp = this.f_26135_.m_21213_();
        super.m_8056_();
    }

    public void m_8041_() {
        this.primaryTarget = null;
        super.m_8041_();
    }

    public void addAggro(LivingEntity attacker, double damage) {
        this.attackers.mergeDouble((Object)attacker, damage, Double::sum);
    }

    private void tickAggro() {
        if (++this.aiTicks >= 10) {
            this.aiTicks = 0;
            ObjectIterator iterator = this.attackers.entrySet().iterator();
            while (iterator.hasNext()) {
                Player player;
                Map.Entry entry = (Map.Entry)iterator.next();
                LivingEntity livingEntity = (LivingEntity)entry.getKey();
                Double oldAggro = (Double)entry.getValue();
                double aggro = oldAggro - (double)this.calmDownRate;
                if (!livingEntity.m_6084_() || aggro <= 0.0 && !this.m_26150_(livingEntity, HURT_BY_TARGETING) || livingEntity instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_())) {
                    iterator.remove();
                    continue;
                }
                entry.setValue(aggro);
            }
        }
    }

    @Nullable
    private LivingEntity getStrongestAttacker() {
        Map.Entry entry = this.attackers.object2DoubleEntrySet().stream().filter(entityEntry -> this.m_26150_((LivingEntity)entityEntry.getKey(), HURT_BY_TARGETING)).max(Comparator.comparingDouble(Map.Entry::getValue)).orElse(null);
        if (entry == null) {
            return null;
        }
        return (LivingEntity)entry.getKey();
    }

    @Nullable
    public LivingEntity getPrimaryTarget() {
        return this.primaryTarget;
    }
}

