/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.platform;

import com.github.eterdelta.crittersandcompanions.CrittersAndCompanions;
import com.github.eterdelta.crittersandcompanions.network.IPacketHandler;
import com.github.eterdelta.crittersandcompanions.platform.service.INetwork;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ForgeNetwork
implements INetwork {
    private final String protocol = "2";
    private final SimpleChannel channel = NetworkRegistry.newSimpleChannel((ResourceLocation)CrittersAndCompanions.createId("main"), () -> "2", "2"::equals, "2"::equals);
    private int messageId = 0;

    @Override
    public <T> INetwork.Sender<T> createSender(Class<T> clazz, IPacketHandler<T> handler) {
        this.channel.registerMessage(this.messageId++, clazz, handler::write, handler::read, (packet, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            context.enqueueWork(() -> handler.handle(packet));
            context.setPacketHandled(true);
        });
        return new INetwork.Sender<T>(){

            @Override
            public void sendToPlayer(ServerPlayer player, T packet) {
                ForgeNetwork.this.channel.send(PacketDistributor.PLAYER.with(() -> player), packet);
            }

            @Override
            public void sendToTracking(Entity entity, T packet) {
                if (entity.m_9236_().m_5776_()) {
                    return;
                }
                ForgeNetwork.this.channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), packet);
            }
        };
    }
}

