/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dttconstruct.init;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cell.CellKit;
import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEvent;
import com.ferreusveritas.dynamictrees.api.registry.TypeRegistryEvent;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.rooty.SoilProperties;
import com.ferreusveritas.dynamictrees.systems.BranchConnectables;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import maxhyper.dttconstruct.DynamicTreesTinkersConstruct;
import maxhyper.dttconstruct.cellkits.DTCCellKits;
import maxhyper.dttconstruct.trees.SlimeMangroveFamily;
import maxhyper.dttconstruct.world.BiomeSpeciesFeatureConfiguration;
import maxhyper.dttconstruct.world.SingleDynamicTreeFeature;
import maxhyper.dttconstruct.world.SpeciesFeatureConfiguration;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="dttconstruct")
public class DTTConstructRegistries {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"dttconstruct");
    public static final Supplier<SingleDynamicTreeFeature> DYNAMIC_TREE_FEATURE = FEATURES.register("tree", () -> new SingleDynamicTreeFeature(SpeciesFeatureConfiguration.CODEC));
    public static final Supplier<SingleDynamicTreeFeature> DYNAMIC_TREE_FEATURE_BIOME = FEATURES.register("tree_biome", () -> new SingleDynamicTreeFeature((Codec<SpeciesFeatureConfiguration>)Codec.unit(BiomeSpeciesFeatureConfiguration::new)));

    public static void setup(IEventBus modBus) {
        FEATURES.register(modBus);
    }

    public static void setupConnectables() {
        Block ichor = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("tconstruct", "ichor_congealed_slime"));
        if (ichor != null) {
            BranchConnectables.makeBlockConnectable((Block)ichor, (state, world, pos, side) -> {
                if (side == Direction.DOWN) {
                    BlockState branchState = world.m_8055_(pos.m_121945_(Direction.UP));
                    BranchBlock branch = TreeHelper.getBranch((BlockState)branchState);
                    if (branch != null) {
                        return Math.min(Math.max(1, branch.getRadius(branchState) - 1), 8);
                    }
                    return 8;
                }
                return 0;
            });
        }
    }

    @SubscribeEvent
    public static void onCellKitRegistry(RegistryEvent<CellKit> event) {
        DTCCellKits.register((Registry<CellKit>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerFamilyTypes(TypeRegistryEvent<Family> event) {
        event.registerType(DynamicTreesTinkersConstruct.location("slime_mangrove"), SlimeMangroveFamily.TYPE);
    }

    @SubscribeEvent
    public static void registerSoilPropertiesTypes(TypeRegistryEvent<SoilProperties> event) {
    }
}

