/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class DebugProbeInfoProvider
implements IProbeInfoProvider {
    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("theoneprobe", "debug");
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
        if (mode == ProbeMode.DEBUG && ((Boolean)Config.showDebugInfo.get()).booleanValue()) {
            BlockPos pos = data.getPos();
            this.showDebugInfo(probeInfo, world, blockState, pos, data.getSideHit());
        }
    }

    private void showDebugInfo(IProbeInfo probeInfo, Level world, BlockState blockState, BlockPos pos, Direction side) {
        Block block = blockState.m_60734_();
        String simpleName = block.getClass().getSimpleName();
        IProbeInfo vertical = probeInfo.vertical(new LayoutStyle().borderColor(-48060).spacing(2)).text(CompoundText.createLabelInfo("Reg Name: ", ForgeRegistries.BLOCKS.getKey((Object)block).toString())).text(CompoundText.createLabelInfo("Unlocname: ", block.m_7705_())).text(CompoundText.createLabelInfo("Class: ", simpleName)).text(CompoundText.createLabelInfo("Hardness: ", Float.valueOf(blockState.m_60800_((BlockGetter)world, pos)))).text(CompoundText.createLabelInfo("Power W: ", blockState.m_60746_((BlockGetter)world, pos, side.m_122424_())).style(TextStyleClass.LABEL).text(", S: ").style(TextStyleClass.INFO).text(String.valueOf(blockState.m_60775_((BlockGetter)world, pos, side.m_122424_())))).text(CompoundText.createLabelInfo("Light: ", block.getLightEmission(blockState, (BlockGetter)world, pos)));
        BlockEntity te = world.m_7702_(pos);
        if (te != null) {
            vertical.text(CompoundText.createLabelInfo("TE: ", te.getClass().getSimpleName()));
        }
    }
}

