/*
 * Decompiled with CFR 0.152.
 */
package waves.client.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaterniond;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import waves.client.WaveSounds;
import waves.client.particle.WaveParticleOption;
import waves.config.Config;
import waves.util.WaveHelpers;

@OnlyIn(value=Dist.CLIENT)
public class WaveParticle
extends TextureSheetParticle {
    public Vec3 startPos;
    public Vec3 shorePos;
    public Vec3 direction;
    public float size;
    public float speed;
    public double initialDistance;
    public double angleToShore;
    public int waveSize;
    public int surroundWaterBlocks;
    public static double minDistance = Double.MAX_VALUE;
    public int waveSpriteOld;
    public double distanceOld;
    public double waveSpeedOld;
    public ResourceLocation waveTexture;
    public boolean hasReachedShore = false;
    public boolean hasTouchedLand = false;
    public boolean hasPlayedSound = false;
    public final double diagonalSize;
    public final double waveArea;
    public final Quaterniond rotation;
    public final AABB aabb;

    public WaveParticle(ClientLevel level, Vec3 startPos, Vec3 shorePos, Vec3 direction, float scale, float size, float speed, int waveSize, int surroundWaterBlocks) {
        super(level, startPos.m_7096_(), startPos.m_7098_(), startPos.m_7094_());
        this.waveTexture = WaveHelpers.identifier("textures/particle/waves/" + WaveHelpers.toSize(waveSize).toLowerCase() + "_0.png");
        this.f_107663_ = size * 0.5f;
        this.setSize(this.f_107663_, (double)this.f_107663_ * 0.075, (double)this.f_107663_ * 0.2);
        this.f_107215_ = direction.m_7096_() * (double)speed;
        this.f_107217_ = direction.m_7094_() * (double)speed;
        this.f_107225_ = Integer.MAX_VALUE;
        this.f_107226_ = 0.0f;
        this.f_107230_ = 0.0f;
        this.f_107219_ = false;
        this.startPos = startPos;
        this.shorePos = shorePos;
        this.direction = direction;
        this.size = size;
        this.speed = speed;
        this.initialDistance = startPos.m_82554_(shorePos);
        this.angleToShore = WaveHelpers.calculateAngleToTarget(startPos, shorePos);
        this.waveSize = waveSize;
        this.surroundWaterBlocks = surroundWaterBlocks;
        this.waveSpriteOld = 0;
        this.distanceOld = Double.MAX_VALUE;
        this.diagonalSize = Math.sqrt(Math.pow(this.f_107663_, 2.0) + Math.pow(this.f_107663_, 2.0)) / 2.0;
        this.waveArea = this.f_107663_ * this.f_107663_;
        this.rotation = new Quaterniond((Quaternionfc)new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f).mul((Quaternionfc)Axis.f_252392_.m_252961_((float)this.angleToShore)).mul((Quaternionfc)Axis.f_252436_.m_252977_(90.0f)));
        this.aabb = new AABB(-this.diagonalSize, -this.diagonalSize, -this.diagonalSize, this.diagonalSize, this.diagonalSize, this.diagonalSize);
    }

    public void m_5989_() {
        float soundMod;
        boolean shouldDecay;
        Vec3 currentPos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        BlockPos blockPos = WaveHelpers.toBlockPos(currentPos);
        double distance = currentPos.m_82554_(this.shorePos);
        boolean hasFluidBelow = !this.f_107208_.m_6425_(blockPos.m_7495_()).m_76178_();
        int waveSprite = WaveHelpers.updateSprite(this.initialDistance, distance, 3.0);
        if (this.waveSpriteOld < waveSprite) {
            this.waveTexture = WaveHelpers.identifier("textures/particle/waves/" + WaveHelpers.toSize(this.waveSize).toLowerCase() + "_" + waveSprite + ".png");
        }
        double vecSpeed = new Vec3(this.f_107215_, 0.0, this.f_107217_).m_82553_();
        boolean bl = shouldDecay = this.hasReachedShore || vecSpeed == 0.0 || waveSprite >= (Integer)Config.COMMON.waveSpriteCount.get() - 1;
        if (!shouldDecay) {
            this.m_107271_(Mth.m_14036_((float)(this.f_107230_ + 0.025f), (float)0.0f, (float)1.0f));
        }
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (!this.hasReachedShore && !hasFluidBelow) {
            this.f_107215_ *= 0.95;
            this.f_107217_ *= 0.95;
            if (vecSpeed <= 0.01) {
                this.m_107271_(1.0f);
                Vec3 vecInverse = WaveHelpers.inverse(this.direction);
                this.f_107217_ = vecInverse.m_7094_() * 0.015;
                this.f_107215_ = vecInverse.m_7096_() * 0.015;
                this.hasReachedShore = true;
            }
            this.hasTouchedLand = true;
        }
        if (this.hasReachedShore && currentPos.m_82554_(this.shorePos) <= 2.0) {
            double speedFactor = 1.0 + (0.05 - WaveHelpers.applyEaseOutQuart(this.direction, distance, 5.0, 0.5, 1.0).m_82553_() * 0.02);
            this.f_107215_ *= speedFactor;
            this.f_107217_ *= speedFactor;
        }
        if ((!hasFluidBelow || this.waveSpeedOld == vecSpeed || distance > this.distanceOld) && this.hasReachedShore) {
            this.m_107271_(Mth.m_14036_((float)(this.f_107230_ - 0.1f), (float)0.0f, (float)1.0f));
        }
        if (hasFluidBelow && this.hasTouchedLand) {
            this.f_107215_ *= 0.95;
            this.f_107217_ *= 0.95;
            this.m_107271_(Mth.m_14036_((float)(this.f_107230_ - 0.1f), (float)0.0f, (float)1.0f));
        }
        this.m_6257_(this.f_107215_, 0.0, this.f_107217_);
        if (this.f_107230_ <= 0.01f || this.f_107224_ > 600) {
            this.m_107274_();
        }
        ++this.f_107224_;
        this.waveSpeedOld = vecSpeed;
        this.distanceOld = distance;
        if (this.waveSpriteOld <= waveSprite) {
            this.waveSpriteOld = waveSprite;
        }
        if (currentPos.m_82554_(this.shorePos) < 4.0 && this.f_107223_.m_188503_((Integer)Config.COMMON.waveBreakingSoundChance.get() + 1) == 0 && !this.hasPlayedSound && (soundMod = (float)WaveHelpers.soundDistanceMod((Player)Minecraft.m_91087_().f_91074_, this.shorePos, 60.0, 10.0)) > 0.0f) {
            float rainfall = 1.0f + this.f_107208_.m_46722_(1.0f) * 0.5f;
            WaveHelpers.playSound((Level)this.f_107208_, this.f_107223_, WaveHelpers.toBlockPos(this.shorePos), (SoundEvent)WaveSounds.WAVES_BREAKING.get(), SoundSource.AMBIENT, true, rainfall * 0.5f * soundMod * ((Double)Config.COMMON.waveVolume.get()).floatValue());
            this.hasPlayedSound = true;
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public void setSize(double length, double height, double width) {
        this.f_107221_ = (float)width;
        this.f_107222_ = (float)height;
        this.m_107259_(new AABB(-length, -width, -height, length, width, height));
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float partialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        Vec3 wavePos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        LocalPlayer player = minecraft.f_91074_;
        if (WaveHelpers.isWithinAngle(wavePos, (Player)player, ((Integer)minecraft.f_91066_.m_231837_().m_231551_()).doubleValue() + 5.0) && player.m_146892_().m_82554_(wavePos) <= ((Integer)minecraft.f_91066_.m_231984_().m_231551_()).doubleValue() * 16.0) {
            PoseStack poseStack = new PoseStack();
            poseStack.m_85836_();
            Matrix4f matrix = poseStack.m_85850_().m_252922_();
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder builder = tesselator.m_85915_();
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85820_);
            RenderSystem.enableCull();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.setShader(GameRenderer::m_172835_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.waveTexture);
            Vec3 vec3 = camera.m_90583_();
            float x = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
            float y = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
            float z = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
            Quaternionf quaternion = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f).mul((Quaternionfc)Axis.f_252392_.m_252961_((float)(this.angleToShore - 1.5707963267948966))).mul((Quaternionfc)Axis.f_252529_.m_252977_(90.0f));
            Vector3f[] avector3 = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
            float quadSize = this.m_5902_(partialTicks);
            for (int i = 0; i < 4; ++i) {
                Vector3f vector3 = avector3[i];
                vector3.rotate((Quaternionfc)quaternion);
                vector3.mul(quadSize);
                vector3.add(x, y, z);
            }
            float u0 = 0.0f;
            float u1 = 1.0f;
            float v0 = 0.0f;
            float v1 = 1.0f;
            double dayTime = (double)this.f_107208_.m_46468_() * (Double)Config.COMMON.waveBioluminescenceFrequency.get();
            double speed = new Vec3(this.f_107215_, 0.0, this.f_107217_).m_82553_() * 10.0;
            double skyBrightness = WaveHelpers.getSkyBrightness((Level)this.f_107208_, partialTicks);
            double bioluminescenceNoise = Mth.m_14008_((double)(WaveHelpers.bioluminescenceNoise((Level)this.f_107208_, 10L, (Integer)Config.COMMON.waveBioluminescenceChange.get()).noise(dayTime + this.f_107212_, dayTime + this.f_107214_) * speed), (double)0.0, (double)1.0) * (1.0 - skyBrightness);
            bioluminescenceNoise = bioluminescenceNoise < 0.05 ? 0.0 : bioluminescenceNoise;
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            int j = 0xF000F0;
            if (player.m_21023_(MobEffects.f_19611_) && !player.m_21023_(MobEffects.f_216964_)) {
                float nightVision = GameRenderer.m_109108_((LivingEntity)player, (float)partialTicks);
                r *= nightVision;
                g *= nightVision;
                b *= nightVision;
                j = Mth.m_14107_((double)(1.572888E7 * (double)nightVision));
            } else {
                r = (float)Mth.m_14008_((double)skyBrightness, (double)0.1, (double)1.0);
                g = (float)Mth.m_14008_((double)(skyBrightness + bioluminescenceNoise * 0.8), (double)0.1, (double)1.0);
                b = (float)Mth.m_14008_((double)(skyBrightness + bioluminescenceNoise), (double)0.1, (double)1.0);
                BlockPos posBehind = WaveHelpers.toBlockPos(WaveHelpers.getPositionOffset(wavePos, this.angleToShore, 180.0, 6.0));
                j = (int)Math.round(Mth.m_14008_((double)((double)(this.f_107208_.m_46749_(posBehind) ? LevelRenderer.m_109541_((BlockAndTintGetter)this.f_107208_, (BlockPos)posBehind) : this.m_6355_(partialTicks)) + 1.0E7 * bioluminescenceNoise), (double)0.0, (double)1.572888E7));
            }
            float a = Mth.m_14036_((float)this.f_107230_, (float)0.0f, (float)1.0f);
            builder.m_252986_(matrix, avector3[0].x(), avector3[0].y(), avector3[0].z()).m_85950_(r, g, b, a).m_7421_(u1, v1).m_85969_(j).m_5752_();
            builder.m_252986_(matrix, avector3[1].x(), avector3[1].y(), avector3[1].z()).m_85950_(r, g, b, a).m_7421_(u1, v0).m_85969_(j).m_5752_();
            builder.m_252986_(matrix, avector3[2].x(), avector3[2].y(), avector3[2].z()).m_85950_(r, g, b, a).m_7421_(u0, v0).m_85969_(j).m_5752_();
            builder.m_252986_(matrix, avector3[3].x(), avector3[3].y(), avector3[3].z()).m_85950_(r, g, b, a).m_7421_(u0, v1).m_85969_(j).m_5752_();
            tesselator.m_85914_();
            poseStack.m_85849_();
        }
    }

    public static ParticleProvider<WaveParticleOption> provider(SpriteSet set) {
        return (type, level, x, y, z, dx, dy, dz) -> {
            WaveParticle particle = new WaveParticle(level, type.getStartPos(), type.getShorePos(), type.getDirection(), type.getScale(), type.getSize(), type.getSpeed(), type.getWaveSize(), type.getSurroundWaterBlocks());
            particle.m_107264_(type.getStartPos().f_82479_, type.getStartPos().f_82480_, type.getStartPos().f_82481_);
            return particle;
        };
    }
}

