/*
 * Decompiled with CFR 0.152.
 */
package com.spunkyinsaan.armourdurability.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("armour_durability.json");
    public int hudX = 10;
    public int hudY = 10;
    public float hudScale = 1.0f;
    public boolean showHelmet = true;
    public boolean showChestplate = true;
    public boolean showLeggings = true;
    public boolean showBoots = true;
    public boolean showElytra = true;
    public boolean showTurtleShell = true;
    public boolean horizontalLayout = false;
    public int itemSpacing = 2;

    public void setHudPosition(int x, int y) {
        this.hudX = Math.max(0, x);
        this.hudY = Math.max(0, y);
        this.save();
    }

    public void setHudX(int x) {
        this.hudX = Math.max(0, x);
        this.save();
    }

    public void setHudY(int y) {
        this.hudY = Math.max(0, y);
        this.save();
    }

    public static ModConfig load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                ModConfig config = (ModConfig)GSON.fromJson(json, ModConfig.class);
                config.validateAndFix();
                System.out.println("Armour Durability config loaded from: " + String.valueOf(CONFIG_PATH));
                System.out.println("HUD Position: (" + config.hudX + ", " + config.hudY + ")");
                return config;
            }
            catch (IOException e) {
                System.err.println("Failed to load config, using defaults: " + e.getMessage());
            }
        } else {
            System.out.println("Armour Durability config not found, using defaults");
        }
        return new ModConfig();
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)this);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
            System.out.println("Armour Durability config saved to: " + String.valueOf(CONFIG_PATH));
            System.out.println("HUD Position: (" + this.hudX + ", " + this.hudY + ")");
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    public void saveWithoutAutoSave() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)this);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    public void validateAndFix() {
        this.hudScale = Math.max(0.1f, Math.min(3.0f, this.hudScale));
        this.hudX = Math.max(0, this.hudX);
        this.hudY = Math.max(0, this.hudY);
        this.itemSpacing = Math.max(0, Math.min(20, this.itemSpacing));
    }
}

