/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem.fog;

import com.corosus.coroutil.util.CULog;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.client.event.ViewportEvent;
import org.joml.Vector3f;
import weather2.ClientTickHandler;
import weather2.ClientWeatherProxy;
import weather2.client.SceneEnhancer;
import weather2.datatypes.WeatherEventType;
import weather2.util.WeatherUtilEntity;
import weather2.weathersystem.fog.FogProfile;

public class FogAdjuster {
    private FogProfile fogHeatwave;
    private FogProfile fogSandstorm;
    private FogProfile fogSnowstorm;
    private FogProfile fogVanilla;
    private FogProfile targetProfile;
    private FogProfile activeProfile;
    private FogProfile activeProfileLerps;
    private int lerpTicksCur = 300;
    private int lerpTicksMax = 300;
    private boolean useFarFog = false;
    public static WeatherEventType lastWeatherType = null;
    public int randDelay = 0;
    private boolean firstUseInit = true;

    public FogAdjuster() {
        this.initProfiles(false);
        this.activeProfile = new FogProfile(this.fogVanilla);
        this.targetProfile = this.fogVanilla;
        this.activeProfileLerps = new FogProfile(new Vector3f(0.0f, 0.0f, 0.0f), 0.0f, 0.0f);
    }

    public void initProfiles(boolean spectator) {
        float distAmp = 1.0f;
        if (spectator) {
            distAmp = 4.0f;
        }
        this.fogHeatwave = new FogProfile(new Vector3f(0.5f, 0.2f, 0.1f), 0.0f, 75.0f);
        this.fogSandstorm = new FogProfile(new Vector3f(0.7f, 0.5f, 0.2f), 0.0f, 18.0f * distAmp);
        this.fogSnowstorm = new FogProfile(new Vector3f(0.7f, 0.7f, 0.7f), 0.0f, 20.0f * distAmp);
        this.fogVanilla = new FogProfile(new Vector3f(-1.0f, -1.0f, -1.0f), -1.0f, -1.0f);
    }

    public void tickGame(ClientWeatherProxy weather) {
        this.updateWeatherState();
        boolean fogDisco = false;
        if (fogDisco) {
            if (this.randDelay <= 0) {
                Random rand = new Random();
                this.randDelay = 20 + rand.nextInt(5);
                this.startRandom();
            }
            --this.randDelay;
        }
        if (SceneEnhancer.getWeatherState() == WeatherEventType.SANDSTORM || SceneEnhancer.getWeatherState() == WeatherEventType.SNOWSTORM) {
            boolean setFogFar;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            boolean isPlayerOutside = WeatherUtilEntity.isEntityOutside((Entity)player);
            boolean playerOutside = isPlayerOutside || player.m_20069_();
            boolean bl = setFogFar = !playerOutside || player.m_5833_();
            if (player != null) {
                if (setFogFar && !this.useFarFog || !setFogFar && this.useFarFog) {
                    this.initProfiles(setFogFar);
                    if (SceneEnhancer.getWeatherState() == WeatherEventType.SANDSTORM) {
                        this.startSandstorm();
                    } else if (SceneEnhancer.getWeatherState() == WeatherEventType.SNOWSTORM) {
                        this.startSnowstorm();
                    }
                }
                this.useFarFog = setFogFar;
            }
        }
        if (this.lerpTicksCur < this.lerpTicksMax) {
            float newLerpX = this.activeProfile.getRgb().x() + this.activeProfileLerps.getRgb().x();
            float newLerpY = this.activeProfile.getRgb().y() + this.activeProfileLerps.getRgb().y();
            float newLerpZ = this.activeProfile.getRgb().z() + this.activeProfileLerps.getRgb().z();
            this.activeProfile.getRgb().set(newLerpX, newLerpY, newLerpZ);
            this.activeProfile.setFogStart(this.activeProfile.getFogStart() + this.activeProfileLerps.getFogStart());
            this.activeProfile.setFogEnd(this.activeProfile.getFogEnd() + this.activeProfileLerps.getFogEnd());
            this.activeProfile.setFogStartSky(this.activeProfile.getFogStartSky() + this.activeProfileLerps.getFogStartSky());
            this.activeProfile.setFogEndSky(this.activeProfile.getFogEndSky() + this.activeProfileLerps.getFogEndSky());
            ++this.lerpTicksCur;
        }
    }

    public void onFogColors(ViewportEvent.ComputeFogColor event) {
        this.updateWeatherState();
        this.fogVanilla.getRgb().set(event.getRed(), event.getGreen(), event.getBlue());
        if (SceneEnhancer.isFogOverridding()) {
            float brightness = Mth.m_14036_((float)(Mth.m_14089_((float)(Minecraft.m_91087_().f_91073_.m_46942_(1.0f) * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
            event.setRed(this.activeProfile.getRgb().x() * brightness);
            event.setGreen(this.activeProfile.getRgb().y() * brightness);
            event.setBlue(this.activeProfile.getRgb().z() * brightness);
        }
    }

    public void onFogRender(ViewportEvent.RenderFog event) {
        this.updateWeatherState();
        if (event.getMode() == FogRenderer.FogMode.FOG_SKY) {
            this.fogVanilla.setFogStartSky(event.getNearPlaneDistance());
            this.fogVanilla.setFogEndSky(event.getFarPlaneDistance());
        } else {
            this.fogVanilla.setFogStart(event.getNearPlaneDistance());
            this.fogVanilla.setFogEnd(event.getFarPlaneDistance());
        }
        if (SceneEnhancer.isFogOverridding()) {
            if (event.getMode() == FogRenderer.FogMode.FOG_SKY) {
                event.setNearPlaneDistance(this.activeProfile.getFogStartSky());
                event.setFarPlaneDistance(this.activeProfile.getFogEndSky());
                event.setCanceled(true);
            } else {
                event.setNearPlaneDistance(this.activeProfile.getFogStart());
                event.setFarPlaneDistance(this.activeProfile.getFogEnd());
                event.setCanceled(true);
            }
        }
    }

    public void startRandom() {
        Random rand = new Random();
        int randFog = 0;
        randFog = this.activeProfile.getFogEnd() < 50.0f ? 50 + rand.nextInt(50) : rand.nextInt(50);
        randFog = rand.nextInt(100);
        this.targetProfile = new FogProfile(new Vector3f(rand.nextFloat(), rand.nextFloat(), rand.nextFloat()), 0.0f, randFog);
        this.lerpTicksMax = 20 + rand.nextInt(50);
        this.setupNewLerpRates();
        CULog.dbg((String)("startRandom: " + randFog));
    }

    public void startHeatwave() {
        CULog.dbg((String)"startHeatwave");
        this.targetProfile = new FogProfile(this.fogHeatwave);
        this.setupNewLerpRates();
    }

    public void startSandstorm() {
        CULog.dbg((String)"startSandstorm");
        this.targetProfile = new FogProfile(this.fogSandstorm);
        this.setupNewLerpRates();
    }

    public void startSnowstorm() {
        CULog.dbg((String)"startSnowstorm");
        this.targetProfile = new FogProfile(this.fogSnowstorm);
        this.setupNewLerpRates();
    }

    public void restoreVanilla() {
        CULog.dbg((String)"restoreVanilla");
        this.targetProfile = new FogProfile(this.fogVanilla);
        this.setupNewLerpRates();
    }

    public void setupNewLerpRates() {
        if (this.firstUseInit && this.fogVanilla.getFogEnd() != -1.0f && this.fogVanilla.getFogEndSky() != -1.0f) {
            this.activeProfile = new FogProfile(this.fogVanilla);
            this.firstUseInit = false;
        }
        this.lerpTicksCur = 0;
        float partialLerpX = this.getLerpRate(this.activeProfile.getRgb().x(), this.targetProfile.getRgb().x(), this.lerpTicksMax);
        float partialLerpY = this.getLerpRate(this.activeProfile.getRgb().y(), this.targetProfile.getRgb().y(), this.lerpTicksMax);
        float partialLerpZ = this.getLerpRate(this.activeProfile.getRgb().z(), this.targetProfile.getRgb().z(), this.lerpTicksMax);
        this.activeProfileLerps.getRgb().set(partialLerpX, partialLerpY, partialLerpZ);
        this.activeProfileLerps.setFogStart(this.getLerpRate(this.activeProfile.getFogStart(), this.targetProfile.getFogStart(), this.lerpTicksMax));
        this.activeProfileLerps.setFogEnd(this.getLerpRate(this.activeProfile.getFogEnd(), this.targetProfile.getFogEnd(), this.lerpTicksMax));
        this.activeProfileLerps.setFogStartSky(this.getLerpRate(this.activeProfile.getFogStartSky(), this.targetProfile.getFogStartSky(), this.lerpTicksMax));
        this.activeProfileLerps.setFogEndSky(this.getLerpRate(this.activeProfile.getFogEndSky(), this.targetProfile.getFogEndSky(), this.lerpTicksMax));
    }

    public float getLerpRate(float curVal, float endVal, float fullLerpTicks) {
        return (endVal - curVal) / fullLerpTicks;
    }

    public boolean isFogOverriding() {
        ClientTickHandler.getClientWeather();
        ClientWeatherProxy weather = ClientWeatherProxy.get();
        return weather.isHeatwave() || weather.isSandstorm() || weather.isSnowstorm() || this.lerpTicksCur < this.lerpTicksMax;
    }

    public void updateWeatherState() {
        WeatherEventType curWeather = SceneEnhancer.getWeatherState();
        if (curWeather == WeatherEventType.ACID_RAIN || curWeather == WeatherEventType.HEAVY_RAIN || curWeather == WeatherEventType.HAIL) {
            curWeather = null;
        }
        boolean match = false;
        if (curWeather != lastWeatherType) {
            if (curWeather == WeatherEventType.SANDSTORM) {
                this.startSandstorm();
                match = true;
            } else if (curWeather == WeatherEventType.SNOWSTORM) {
                this.startSnowstorm();
                match = true;
            } else if (curWeather == WeatherEventType.HEATWAVE) {
                this.startHeatwave();
                match = true;
            } else if (curWeather == null) {
                this.restoreVanilla();
                match = true;
            }
        }
        if (match) {
            lastWeatherType = curWeather;
        }
    }

    public float getLerpFraction() {
        if (this.lerpTicksMax == 0) {
            return 0.0f;
        }
        return this.lerpTicksCur / this.lerpTicksMax;
    }
}

