/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import weather2.ClientTickHandler;

public class PacketNBTFromServer {
    private final CompoundTag nbt;

    public PacketNBTFromServer(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public static void encode(PacketNBTFromServer msg, FriendlyByteBuf buffer) {
        buffer.m_130079_(msg.nbt);
    }

    public static PacketNBTFromServer decode(FriendlyByteBuf buffer) {
        return new PacketNBTFromServer(buffer.m_130260_());
    }

    public static class Handler {
        public static void handle(PacketNBTFromServer msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                try {
                    CompoundTag nbt = msg.nbt;
                    String packetCommand = nbt.m_128461_("packetCommand");
                    String command = nbt.m_128461_("command");
                    if (packetCommand.equals("WeatherData")) {
                        ClientTickHandler.getClientWeather();
                        ClientTickHandler.weatherManager.nbtSyncFromServer(nbt);
                    } else if (packetCommand.equals("ClientConfigData") && command.equals("syncUpdate")) {
                        ClientTickHandler.clientConfigData.readNBT(nbt);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

