/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import twilightforest.TFConfig;

public class SyncUncraftingTableConfigPacket {
    private final double uncraftingMultiplier;
    private final double repairingMultiplier;
    private final boolean allowShapeless;
    private final boolean disabledUncrafting;
    private final boolean disabledTable;
    private final List<String> disabledRecipes;
    private final boolean flipRecipeList;
    private final List<String> disabledModids;
    private final boolean flipModidList;

    public SyncUncraftingTableConfigPacket(double uncraftingMultiplier, double repairingMultiplier, boolean allowShapeless, boolean disabledUncrafting, boolean disabledTable, List<? extends String> disabledRecipes, boolean flipRecipeList, List<? extends String> disabledModids, boolean flipModidList) {
        this.uncraftingMultiplier = uncraftingMultiplier;
        this.repairingMultiplier = repairingMultiplier;
        this.allowShapeless = allowShapeless;
        this.disabledUncrafting = disabledUncrafting;
        this.disabledTable = disabledTable;
        this.disabledRecipes = disabledRecipes;
        this.flipRecipeList = flipRecipeList;
        this.disabledModids = disabledModids;
        this.flipModidList = flipModidList;
    }

    public SyncUncraftingTableConfigPacket(FriendlyByteBuf buf) {
        this.uncraftingMultiplier = buf.readDouble();
        this.repairingMultiplier = buf.readDouble();
        this.allowShapeless = buf.readBoolean();
        this.disabledUncrafting = buf.readBoolean();
        this.disabledTable = buf.readBoolean();
        this.disabledRecipes = buf.m_236845_(FriendlyByteBuf::m_130277_);
        this.flipRecipeList = buf.readBoolean();
        this.disabledModids = buf.m_236845_(FriendlyByteBuf::m_130277_);
        this.flipModidList = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.uncraftingMultiplier);
        buf.writeDouble(this.repairingMultiplier);
        buf.writeBoolean(this.allowShapeless);
        buf.writeBoolean(this.disabledUncrafting);
        buf.writeBoolean(this.disabledTable);
        buf.m_236828_(this.disabledRecipes, FriendlyByteBuf::m_130070_);
        buf.writeBoolean(this.flipRecipeList);
        buf.m_236828_(this.disabledModids, FriendlyByteBuf::m_130070_);
        buf.writeBoolean(this.flipModidList);
    }

    public static class Handler {
        public static boolean onMessage(SyncUncraftingTableConfigPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.uncraftingXpCostMultiplier.set((Object)message.uncraftingMultiplier);
                TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.repairingXpCostMultiplier.set((Object)message.repairingMultiplier);
                TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.allowShapelessUncrafting.set((Object)message.allowShapeless);
                TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableUncraftingOnly.set((Object)message.disabledUncrafting);
                TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableEntireTable.set((Object)message.disabledTable);
                TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableUncraftingRecipes.set(message.disabledRecipes);
                TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.reverseRecipeBlacklist.set((Object)message.flipRecipeList);
                TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.blacklistedUncraftingModIds.set(message.disabledModids);
                TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.flipUncraftingModIdList.set((Object)message.flipModidList);
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

