/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import twilightforest.init.TFRecipes;

public class UncraftingRecipeBuilder
implements RecipeBuilder {
    private final Ingredient input;
    private final int count;
    private int cost = -1;
    private final List<String> pattern = new ArrayList<String>();
    private final Map<Character, Ingredient> outputs = new HashMap<Character, Ingredient>();

    public UncraftingRecipeBuilder(Ingredient input, int count) {
        this.input = input;
        this.count = count;
    }

    public static UncraftingRecipeBuilder uncrafting(ItemLike input) {
        return UncraftingRecipeBuilder.uncrafting(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), 1);
    }

    public static UncraftingRecipeBuilder uncrafting(TagKey<Item> input) {
        return UncraftingRecipeBuilder.uncrafting(Ingredient.m_204132_(input), 1);
    }

    public static UncraftingRecipeBuilder uncrafting(ItemLike input, int count) {
        return UncraftingRecipeBuilder.uncrafting(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), count);
    }

    public static UncraftingRecipeBuilder uncrafting(TagKey<Item> input, int count) {
        return UncraftingRecipeBuilder.uncrafting(Ingredient.m_204132_(input), count);
    }

    public static UncraftingRecipeBuilder uncrafting(Ingredient input, int count) {
        return new UncraftingRecipeBuilder(input, count);
    }

    public UncraftingRecipeBuilder define(Character pSymbol, TagKey<Item> pTag) {
        return this.define(pSymbol, Ingredient.m_204132_(pTag));
    }

    public UncraftingRecipeBuilder define(Character pSymbol, ItemLike pItem) {
        return this.define(pSymbol, Ingredient.m_43929_((ItemLike[])new ItemLike[]{pItem}));
    }

    public UncraftingRecipeBuilder setCost(int cost) {
        this.cost = cost;
        return this;
    }

    public UncraftingRecipeBuilder define(Character pSymbol, Ingredient pIngredient) {
        if (this.outputs.containsKey(pSymbol)) {
            throw new IllegalArgumentException("Symbol '" + pSymbol + "' is already defined!");
        }
        if (pSymbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.outputs.put(pSymbol, pIngredient);
        return this;
    }

    public UncraftingRecipeBuilder pattern(String pattern) {
        if (!this.pattern.isEmpty() && pattern.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(pattern);
        return this;
    }

    public RecipeBuilder m_126132_(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String group) {
        return this;
    }

    public Item m_142372_() {
        return this.input.m_43908_()[0].m_41720_();
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        this.ensureValid(id);
        consumer.accept(new Result(id, this.input, this.count, this.cost, this.pattern, this.outputs));
    }

    public void m_176498_(Consumer<FinishedRecipe> consumer) {
        this.m_126140_(consumer, new ResourceLocation("twilightforest", "uncrafting/" + this.getDefaultRecipeId((ItemLike)this.m_142372_()).m_135815_()));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + id + "!");
        }
        HashSet set = Sets.newHashSet(this.outputs.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.pattern) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.outputs.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + id + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + id);
        }
    }

    private ResourceLocation getDefaultRecipeId(ItemLike item) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_());
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient input;
        private final int count;
        private final int cost;
        private final List<String> pattern;
        private final Map<Character, Ingredient> outputs;

        public Result(ResourceLocation id, Ingredient input, int count, int cost, List<String> pattern, Map<Character, Ingredient> outputs) {
            this.id = id;
            this.input = input;
            this.count = count;
            this.cost = cost;
            this.pattern = pattern;
            this.outputs = outputs;
        }

        public void m_7917_(JsonObject object) {
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            object.add("pattern", (JsonElement)jsonarray);
            JsonObject keys = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.outputs.entrySet()) {
                keys.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            object.add("key", (JsonElement)keys);
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("ingredient", this.input.m_43942_());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            object.add("input", (JsonElement)jsonObject);
            if (this.cost > -1) {
                object.addProperty("cost", (Number)this.cost);
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)TFRecipes.UNCRAFTING_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

