/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import twilightforest.block.CarminiteReactorBlock;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.entity.monster.CarminiteGhastling;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFEntities;
import twilightforest.init.TFSounds;

public class CarminiteReactorBlockEntity
extends BlockEntity {
    private int counter = 0;
    private final int secX;
    private final int secY;
    private final int secZ;
    private int terX;
    private int terY;
    private int terZ;

    public CarminiteReactorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFBlockEntities.CARMINITE_REACTOR.get(), pos, state);
        RandomSource rand = RandomSource.m_216327_();
        this.secX = 3 * (rand.m_188499_() ? 1 : -1);
        this.secY = 3 * (rand.m_188499_() ? 1 : -1);
        this.secZ = 3 * (rand.m_188499_() ? 1 : -1);
        this.terX = 3 * (rand.m_188499_() ? 1 : -1);
        this.terY = 3 * (rand.m_188499_() ? 1 : -1);
        this.terZ = 3 * (rand.m_188499_() ? 1 : -1);
        if (this.secX == this.terX && this.secY == this.terY && this.secZ == this.terZ) {
            this.terX = -this.terX;
            this.terY = -this.terY;
            this.terZ = -this.terZ;
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CarminiteReactorBlockEntity te) {
        if (!level.m_46659_() && ((Boolean)state.m_61143_((Property)CarminiteReactorBlock.ACTIVE)).booleanValue()) {
            ++te.counter;
            if (!level.m_5776_()) {
                int offset = 10;
                if (te.counter % 5 == 0) {
                    int tertiary;
                    int secondary;
                    int primary;
                    if (te.counter == 5) {
                        BlockState fakeGold = ((Block)TFBlocks.FAKE_GOLD.get()).m_49966_();
                        BlockState fakeDiamond = ((Block)TFBlocks.FAKE_DIAMOND.get()).m_49966_();
                        te.createFakeBlock(pos.m_7918_(1, 1, 1), fakeDiamond);
                        te.createFakeBlock(pos.m_7918_(1, 1, -1), fakeDiamond);
                        te.createFakeBlock(pos.m_7918_(-1, 1, 1), fakeDiamond);
                        te.createFakeBlock(pos.m_7918_(-1, 1, -1), fakeDiamond);
                        te.createFakeBlock(pos.m_7918_(0, 1, 0), fakeDiamond);
                        te.createFakeBlock(pos.m_7918_(0, 1, 1), fakeGold);
                        te.createFakeBlock(pos.m_7918_(0, 1, -1), fakeGold);
                        te.createFakeBlock(pos.m_7918_(1, 1, 0), fakeGold);
                        te.createFakeBlock(pos.m_7918_(-1, 1, 0), fakeGold);
                        te.createFakeBlock(pos.m_7918_(1, 0, 1), fakeGold);
                        te.createFakeBlock(pos.m_7918_(1, 0, -1), fakeGold);
                        te.createFakeBlock(pos.m_7918_(-1, 0, 1), fakeGold);
                        te.createFakeBlock(pos.m_7918_(-1, 0, -1), fakeGold);
                        te.createFakeBlock(pos.m_7918_(0, 0, 1), fakeDiamond);
                        te.createFakeBlock(pos.m_7918_(0, 0, -1), fakeDiamond);
                        te.createFakeBlock(pos.m_7918_(1, 0, 0), fakeDiamond);
                        te.createFakeBlock(pos.m_7918_(-1, 0, 0), fakeDiamond);
                        te.createFakeBlock(pos.m_7918_(0, -1, 0), fakeDiamond);
                        te.createFakeBlock(pos.m_7918_(1, -1, 1), fakeDiamond);
                        te.createFakeBlock(pos.m_7918_(1, -1, -1), fakeDiamond);
                        te.createFakeBlock(pos.m_7918_(-1, -1, 1), fakeDiamond);
                        te.createFakeBlock(pos.m_7918_(-1, -1, -1), fakeDiamond);
                        te.createFakeBlock(pos.m_7918_(0, -1, 1), fakeGold);
                        te.createFakeBlock(pos.m_7918_(0, -1, -1), fakeGold);
                        te.createFakeBlock(pos.m_7918_(1, -1, 0), fakeGold);
                        te.createFakeBlock(pos.m_7918_(-1, -1, 0), fakeGold);
                    }
                    if ((primary = te.counter - 80) >= offset && primary <= 249) {
                        te.drawBlob(pos, (primary - offset) / 40, Blocks.f_50016_.m_49966_(), primary - offset, false);
                    }
                    if (primary <= 200) {
                        te.drawBlob(pos, primary / 40, ((Block)TFBlocks.REACTOR_DEBRIS.get()).m_49966_(), te.counter, false);
                    }
                    if ((secondary = te.counter - 120) >= offset && secondary <= 129) {
                        te.drawBlob(pos.m_7918_(te.secX, te.secY, te.secZ), (secondary - offset) / 40, Blocks.f_50016_.m_49966_(), secondary - offset, false);
                    }
                    if (secondary >= 0 && secondary <= 160) {
                        te.drawBlob(pos.m_7918_(te.secX, te.secY, te.secZ), secondary / 40, Blocks.f_50016_.m_49966_(), secondary, true);
                    }
                    if ((tertiary = te.counter - 160) >= offset && tertiary <= 129) {
                        te.drawBlob(pos.m_7918_(te.terX, te.terY, te.terZ), (tertiary - offset) / 40, Blocks.f_50016_.m_49966_(), tertiary - offset, false);
                    }
                    if (tertiary >= 0 && tertiary <= 160) {
                        te.drawBlob(pos.m_7918_(te.terX, te.terY, te.terZ), tertiary / 40, Blocks.f_50016_.m_49966_(), tertiary, true);
                    }
                }
                if (te.counter >= 350) {
                    level.m_254877_(null, TFDamageTypes.getDamageSource(level, TFDamageTypes.REACTOR, new EntityType[0]), null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 4.0f, true, Level.ExplosionInteraction.BLOCK);
                    level.m_7471_(pos, false);
                    for (int i = 0; i < 3; ++i) {
                        te.spawnGhastNear(pos.m_123341_() + te.secX, pos.m_123342_() + te.secY, pos.m_123343_() + te.secZ);
                        te.spawnGhastNear(pos.m_123341_() + te.terX, pos.m_123342_() + te.terY, pos.m_123343_() + te.terZ);
                    }
                }
            } else if (te.counter % 5 == 0 && te.counter <= 250) {
                level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)TFSounds.REACTOR_AMBIENT.get(), SoundSource.BLOCKS, (float)te.counter / 100.0f, (float)te.counter / 100.0f, false);
            }
        }
    }

    private void spawnGhastNear(int x, int y, int z) {
        CarminiteGhastling ghast = (CarminiteGhastling)((EntityType)TFEntities.CARMINITE_GHASTLING.get()).m_20615_(this.m_58904_());
        ghast.m_7678_((double)x - 1.5 + (double)this.m_58904_().m_213780_().m_188501_() * 3.0, (double)y - 1.5 + (double)this.m_58904_().m_213780_().m_188501_() * 3.0, (double)z - 1.5 + (double)this.m_58904_().m_213780_().m_188501_() * 3.0, this.m_58904_().m_213780_().m_188501_() * 360.0f, 0.0f);
        ghast.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 200));
        this.m_58904_().m_7967_((Entity)ghast);
    }

    private void drawBlob(BlockPos pos, int rad, BlockState state, int fuzz, boolean netherTransform) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            int fuzzX = (fuzz + dx) % 8;
            for (int dy = 0; dy <= rad; dy = (int)((byte)(dy + 1))) {
                int fuzzY = (fuzz + dy) % 8;
                block12: for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                    byte dist = dx >= dy && dx >= dz ? (byte)(dx + (byte)((double)Math.max(dy, dz) * 0.5 + (double)Math.min(dy, dz) * 0.25)) : (dy >= dx && dy >= dz ? (byte)(dy + (byte)((double)Math.max(dx, dz) * 0.5 + (double)Math.min(dx, dz) * 0.25)) : (byte)(dz + (byte)((double)Math.max(dx, dy) * 0.5 + (double)Math.min(dx, dy) * 0.25)));
                    if (dist != rad || dx == 0 && dy == 0 && dz == 0) continue;
                    switch (fuzzX) {
                        case 0: {
                            this.transformBlock(pos.m_7918_(dx, dy, dz), state, fuzzY, netherTransform);
                            continue block12;
                        }
                        case 1: {
                            this.transformBlock(pos.m_7918_(dx, dy, -dz), state, fuzzY, netherTransform);
                            continue block12;
                        }
                        case 2: {
                            this.transformBlock(pos.m_7918_(-dx, dy, dz), state, fuzzY, netherTransform);
                            continue block12;
                        }
                        case 3: {
                            this.transformBlock(pos.m_7918_(-dx, dy, -dz), state, fuzzY, netherTransform);
                            continue block12;
                        }
                        case 4: {
                            this.transformBlock(pos.m_7918_(dx, -dy, dz), state, fuzzY, netherTransform);
                            continue block12;
                        }
                        case 5: {
                            this.transformBlock(pos.m_7918_(dx, -dy, -dz), state, fuzzY, netherTransform);
                            continue block12;
                        }
                        case 6: {
                            this.transformBlock(pos.m_7918_(-dx, -dy, dz), state, fuzzY, netherTransform);
                            continue block12;
                        }
                        case 7: {
                            this.transformBlock(pos.m_7918_(-dx, -dy, -dz), state, fuzzY, netherTransform);
                        }
                    }
                }
            }
        }
    }

    private void transformBlock(BlockPos pos, BlockState state, int fuzz, boolean netherTransform) {
        BlockState stateThere = this.m_58904_().m_8055_(pos);
        if (stateThere.m_60734_() != Blocks.f_50016_ && (stateThere.m_204336_(BlockTagGenerator.CARMINITE_REACTOR_IMMUNE) || stateThere.m_60800_((BlockGetter)this.f_58857_, pos) == -1.0f)) {
            return;
        }
        if (fuzz == 0 && stateThere.m_60734_() != Blocks.f_50016_) {
            this.m_58904_().m_46796_(2001, pos, Block.m_49956_((BlockState)stateThere));
        }
        if (netherTransform && stateThere.m_60734_() != Blocks.f_50016_) {
            BlockState ore = ((Block)ForgeRegistries.BLOCKS.tags().getTag(BlockTagGenerator.CARMINITE_REACTOR_ORES).getRandomElement(this.m_58904_().m_213780_()).get()).m_49966_();
            this.m_58904_().m_7731_(pos, this.m_58904_().m_213780_().m_188503_(8) == 0 ? ore : Blocks.f_50134_.m_49966_(), 3);
            if (this.m_58904_().m_46859_(pos.m_7494_()) && fuzz % 3 == 0) {
                this.m_58904_().m_7731_(pos.m_7494_(), Blocks.f_50083_.m_49966_(), 3);
            }
        } else {
            this.m_58904_().m_7731_(pos, state, 3);
        }
    }

    private void createFakeBlock(BlockPos pos, BlockState state) {
        BlockState stateThere = this.m_58904_().m_8055_(pos);
        if (stateThere.m_60734_() != Blocks.f_50016_ && !stateThere.m_204336_(BlockTagGenerator.CARMINITE_REACTOR_IMMUNE) && stateThere.m_60800_((BlockGetter)this.m_58904_(), pos) != -1.0f) {
            this.m_58904_().m_7731_(pos, state, 2);
        }
    }
}

