/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ForceFieldBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty DOWN = PipeBlock.f_55153_;
    public static final BooleanProperty UP = PipeBlock.f_55152_;
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    protected static final VoxelShape BASE_SHAPE = Block.m_49796_((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0);
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)9.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    protected static final VoxelShape DOWN_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0);
    protected static final VoxelShape UP_SHAPE = Block.m_49796_((double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)7.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0, (double)16.0);
    protected static final VoxelShape DOWN_WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)7.0, (double)7.0, (double)9.0);
    protected static final VoxelShape DOWN_EAST_SHAPE = Block.m_49796_((double)9.0, (double)0.0, (double)7.0, (double)16.0, (double)7.0, (double)9.0);
    protected static final VoxelShape DOWN_NORTH_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)7.0, (double)7.0);
    protected static final VoxelShape DOWN_SOUTH_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)7.0, (double)16.0);
    protected static final VoxelShape UP_WEST_SHAPE = Block.m_49796_((double)0.0, (double)9.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0);
    protected static final VoxelShape UP_EAST_SHAPE = Block.m_49796_((double)9.0, (double)9.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final VoxelShape UP_NORTH_SHAPE = Block.m_49796_((double)7.0, (double)9.0, (double)0.0, (double)9.0, (double)16.0, (double)7.0);
    protected static final VoxelShape UP_SOUTH_SHAPE = Block.m_49796_((double)7.0, (double)9.0, (double)9.0, (double)9.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_WEST_SHAPE = Block.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)7.0);
    protected static final VoxelShape NORTH_EAST_SHAPE = Block.m_49796_((double)9.0, (double)7.0, (double)0.0, (double)16.0, (double)9.0, (double)7.0);
    protected static final VoxelShape SOUTH_WEST_SHAPE = Block.m_49796_((double)0.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)16.0);
    protected static final VoxelShape SOUTH_EAST_SHAPE = Block.m_49796_((double)9.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0, (double)16.0);

    public ForceFieldBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter getter, BlockPos pos, Entity entity) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        VoxelShape shape = BASE_SHAPE;
        boolean down = (Boolean)state.m_61143_((Property)DOWN);
        boolean up = (Boolean)state.m_61143_((Property)UP);
        boolean north = (Boolean)state.m_61143_((Property)NORTH);
        boolean south = (Boolean)state.m_61143_((Property)SOUTH);
        boolean west = (Boolean)state.m_61143_((Property)WEST);
        boolean east = (Boolean)state.m_61143_((Property)EAST);
        if (down) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)DOWN_SHAPE);
            if (north && ForceFieldBlock.cornerConnects(getter, pos, Direction.DOWN, Direction.NORTH)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)DOWN_NORTH_SHAPE);
            }
            if (south && ForceFieldBlock.cornerConnects(getter, pos, Direction.DOWN, Direction.SOUTH)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)DOWN_SOUTH_SHAPE);
            }
            if (west && ForceFieldBlock.cornerConnects(getter, pos, Direction.DOWN, Direction.WEST)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)DOWN_WEST_SHAPE);
            }
            if (east && ForceFieldBlock.cornerConnects(getter, pos, Direction.DOWN, Direction.EAST)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)DOWN_EAST_SHAPE);
            }
        }
        if (up) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)UP_SHAPE);
            if (north && ForceFieldBlock.cornerConnects(getter, pos, Direction.UP, Direction.NORTH)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)UP_NORTH_SHAPE);
            }
            if (south && ForceFieldBlock.cornerConnects(getter, pos, Direction.UP, Direction.SOUTH)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)UP_SOUTH_SHAPE);
            }
            if (west && ForceFieldBlock.cornerConnects(getter, pos, Direction.UP, Direction.WEST)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)UP_WEST_SHAPE);
            }
            if (east && ForceFieldBlock.cornerConnects(getter, pos, Direction.UP, Direction.EAST)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)UP_EAST_SHAPE);
            }
        }
        if (north) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)NORTH_SHAPE);
            if (west && ForceFieldBlock.cornerConnects(getter, pos, Direction.NORTH, Direction.WEST)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)NORTH_WEST_SHAPE);
            }
            if (east && ForceFieldBlock.cornerConnects(getter, pos, Direction.NORTH, Direction.EAST)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)NORTH_EAST_SHAPE);
            }
        }
        if (south) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SOUTH_SHAPE);
            if (west && ForceFieldBlock.cornerConnects(getter, pos, Direction.SOUTH, Direction.WEST)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SOUTH_WEST_SHAPE);
            }
            if (east && ForceFieldBlock.cornerConnects(getter, pos, Direction.SOUTH, Direction.EAST)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SOUTH_EAST_SHAPE);
            }
        }
        if (west) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)WEST_SHAPE);
        }
        if (east) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)EAST_SHAPE);
        }
        return shape;
    }

    public static boolean cornerConnects(BlockGetter getter, BlockPos pos, Direction dir1, Direction dir2) {
        Vec3i vec31 = dir1.m_122436_();
        Vec3i vec32 = dir2.m_122436_();
        return ForceFieldBlock.fullFaceOrSimilarForceField(getter, pos.m_121955_(vec31), dir1, dir2) || ForceFieldBlock.fullFaceOrSimilarForceField(getter, pos.m_121955_(vec32), dir2, dir1);
    }

    private static boolean fullFaceOrSimilarForceField(BlockGetter getter, BlockPos pos, Direction relative, Direction similar) {
        BlockState state = getter.m_8055_(pos);
        return state.m_60783_(getter, pos, relative.m_122424_()) || state.m_60734_() instanceof ForceFieldBlock && (Boolean)state.m_61143_((Property)PipeBlock.f_55154_.get(similar)) != false;
    }

    public float m_7749_(BlockState state, BlockGetter getter, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    public boolean canConnectTo(@Nullable BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        BlockState relative = getter.m_8055_(pos.m_121945_(direction));
        if (relative.m_60713_((Block)this)) {
            return true;
        }
        int betterConnections = 0;
        if (state == null) {
            for (Direction face : Direction.values()) {
                if (!getter.m_8055_(pos.m_121945_(face)).m_60713_((Block)this)) continue;
                ++betterConnections;
            }
        } else {
            for (Direction face : Direction.values()) {
                if (!((Boolean)state.m_61143_((Property)PipeBlock.f_55154_.get(face))).booleanValue()) continue;
                ++betterConnections;
            }
        }
        if (betterConnections >= 3) {
            return false;
        }
        return !ForceFieldBlock.m_152463_((BlockState)relative) && relative.m_60783_(getter, pos.m_121945_(direction), direction.m_122424_());
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        Direction clicked = context.m_43719_();
        BlockState state = this.m_49966_();
        for (Direction dir : Direction.values()) {
            state = (BlockState)state.m_61124_((Property)PipeBlock.f_55154_.get(dir), (Comparable)Boolean.valueOf(clicked.m_122424_() == dir || (clicked != dir ? this.canConnectTo(null, (BlockGetter)level, pos, dir) : !context.m_7078_())));
        }
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState facingState, LevelAccessor accessor, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            accessor.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)accessor));
        }
        return this.canConnectTo(state, (BlockGetter)accessor, pos, direction) ? (BlockState)state.m_61124_((Property)PipeBlock.f_55154_.get(direction), (Comparable)Boolean.valueOf(true)) : state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED, NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }
}

