/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.locomotion.common.entity;

import cofh.core.common.entity.AbstractMinecartCoFH;
import cofh.lib.util.Utils;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.locomotion.init.registries.TLocEntities;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class UnderwaterMinecart
extends AbstractMinecartCoFH {
    public static final int AIR_SUPPLY_MAX = 4800;
    protected int airSupply = 4800;
    protected int respirationFactor = 1;

    public UnderwaterMinecart(EntityType<? extends UnderwaterMinecart> type, Level worldIn) {
        super(type, worldIn);
    }

    public UnderwaterMinecart(Level worldIn, double posX, double posY, double posZ) {
        super((EntityType)TLocEntities.UNDERWATER_CART.get(), worldIn, posX, posY, posZ);
    }

    public UnderwaterMinecart onPlaced(ItemStack stack) {
        super.onPlaced(stack);
        Map enchantMap = EnchantmentHelper.m_44882_((ListTag)this.enchantments);
        if (enchantMap.containsKey(Enchantments.f_44970_)) {
            int encRespiration = (Integer)enchantMap.get(Enchantments.f_44970_);
            this.respirationFactor = Math.max(1, encRespiration + 1);
        }
        return this;
    }

    protected Item m_213728_() {
        return (Item)ThermalCore.ITEMS.get("underwater_minecart");
    }

    public void m_8119_() {
        super.m_8119_();
        if (Utils.isServerWorld((Level)this.f_19853_)) {
            if (!this.f_19798_) {
                this.airSupply = Math.min(this.airSupply + 40, 4800);
            } else {
                List passengers = this.m_20197_();
                if (!passengers.isEmpty() && this.airSupply > 0) {
                    passengers.forEach(e -> {
                        if (e.m_20146_() < e.m_6062_()) {
                            e.m_20301_(e.m_20146_() + 1);
                            if (this.f_19796_.m_188503_(this.respirationFactor) <= 0) {
                                --this.airSupply;
                            }
                        }
                    });
                }
            }
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        Map enchantMap = EnchantmentHelper.m_44882_((ListTag)this.enchantments);
        if (enchantMap.containsKey(Enchantments.f_44970_)) {
            int encRespiration = (Integer)enchantMap.get(Enchantments.f_44970_);
            this.respirationFactor = Math.max(1, encRespiration + 1);
        }
    }

    protected boolean m_20073_() {
        if (this.m_20202_() instanceof Boat) {
            this.f_19798_ = false;
        } else if (this.m_204031_(FluidTags.f_13131_, 0.014)) {
            if (!this.f_19798_ && !this.f_19803_) {
                this.m_5841_();
            }
            this.f_19789_ = 0.0f;
            this.f_19798_ = true;
            this.m_20095_();
        } else {
            this.f_19798_ = false;
        }
        return this.f_19798_;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_() || this.m_20160_()) {
            return InteractionResult.PASS;
        }
        if (!this.f_19853_.f_46443_) {
            return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6025_(int x, int y, int z, boolean receivingPower) {
        if (receivingPower) {
            if (this.m_20160_()) {
                this.m_20153_();
            }
            if (this.m_38176_() == 0) {
                this.m_38160_(-this.m_38177_());
                this.m_38154_(10);
                this.m_38109_(50.0f);
                this.m_5834_();
            }
        }
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ThermalCore.ITEMS.get("underwater_minecart"));
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.RIDEABLE;
    }
}

