/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumextras;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.longs.LongLongMutablePair;
import it.unimi.dsi.fastutil.longs.LongLongPair;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import toni.sodiumextras.SodiumExtras;

public class EmbyTools {
    private static final Marker IT = MarkerManager.getMarker((String)"Tools");
    private static final LongLongPair[] BENCHTIMES = new LongLongPair[100];
    private static int BENCH_POS = 0;

    public static <T> T getLastValue(T[] value) {
        return value[value.length - 1];
    }

    public static Pair<String, String> resourceLocationPair(String res) {
        String[] r = res.split(":");
        try {
            Pair pair = Pair.of((Object)r[0], (Object)r[1]);
            return pair;
        }
        finally {
            r[0] = null;
            r[1] = null;
        }
    }

    public static void setValueInField(Class<?> clazz, String fieldName, Object from, Object value) {
        try {
            Field field = clazz.getField(fieldName);
            field.setAccessible(true);
            field.set(from, value);
        }
        catch (Exception e) {
            SodiumExtras.LOGGER.error("Cannot set value of '{}' from {}", (Object)fieldName, (Object)clazz.getName(), (Object)e);
        }
    }

    public static void invokeMethod(Class<?> clazz, String methodName, Object from, Object ... values) {
        try {
            Class[] types = new Class[values.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = values[i].getClass();
            }
            Method field = clazz.getMethod(methodName, types);
            field.setAccessible(true);
            field.invoke(from, values);
        }
        catch (Exception e) {
            SodiumExtras.LOGGER.error("Cannot invoke method '{}' from {}", (Object)methodName, (Object)clazz.getName(), (Object)e);
        }
    }

    public static ChatFormatting colorByLow(int usage) {
        return usage < 9 ? ChatFormatting.DARK_RED : (usage < 16 ? ChatFormatting.RED : (usage < 30 ? ChatFormatting.GOLD : ChatFormatting.RESET));
    }

    public static ChatFormatting colorByPercent(int usage) {
        return usage >= 100 ? ChatFormatting.DARK_RED : (usage >= 90 ? ChatFormatting.RED : (usage >= 75 ? ChatFormatting.GOLD : ChatFormatting.RESET));
    }

    public static String tintByLower(int usage) {
        return (usage < 9 ? ChatFormatting.DARK_RED : (usage < 16 ? ChatFormatting.RED : (usage < 30 ? ChatFormatting.GOLD : ChatFormatting.RESET))).toString() + usage;
    }

    public static String tintByPercent(long usage) {
        return (usage >= 100L ? ChatFormatting.DARK_RED : (usage >= 90L ? ChatFormatting.RED : (usage >= 75L ? ChatFormatting.GOLD : ChatFormatting.RESET))).toString() + usage;
    }

    public static boolean isWhitelisted(ResourceLocation entityOrTile, ForgeConfigSpec.ConfigValue<List<? extends String>> configValue) {
        for (String item : (List)configValue.get()) {
            Pair<String, String> resLoc = EmbyTools.resourceLocationPair(item);
            if (!((String)resLoc.key()).equals(entityOrTile.m_135827_()) || !((String)resLoc.value()).equals("*") && !((String)resLoc.value()).equals(entityOrTile.m_135815_())) continue;
            return true;
        }
        return false;
    }

    public static int getColorARGB(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static long ramUsed() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static long bytesToMB(long input) {
        return input / 1024L / 1024L;
    }

    public static boolean isModInstalled(String modid) {
        return FMLLoader.getLoadingModList().getModFileById(modid) != null;
    }

    public static boolean isEntityWithinDistance(Player player, Entity entity, int maxHeight, int maxDistanceSquare) {
        if (Math.abs(player.m_20186_() - entity.m_20186_() - 4.0) < (double)maxHeight) {
            double z;
            double x = player.m_20185_() - entity.m_20185_();
            return x * x + (z = player.m_20189_() - entity.m_20189_()) * z < (double)maxDistanceSquare;
        }
        return false;
    }

    public static boolean isEntityWithinDistance(BlockPos bePos, Vec3 camVec, int maxHeight, int maxDistanceSquare) {
        if (Math.abs((double)bePos.m_123342_() - camVec.f_82480_ - 4.0) < (double)maxHeight) {
            double z;
            double x = (double)bePos.m_123341_() - camVec.f_82479_;
            return x * x + (z = (double)bePos.m_123343_() - camVec.f_82481_) * z < (double)maxDistanceSquare;
        }
        return false;
    }

    public static boolean isEntityWithinDistance(Entity entity, double cameraX, double cameraY, double cameraZ, int maxHeight, int maxDistanceSquare) {
        if (Math.abs(entity.m_20186_() - cameraY - 4.0) < (double)maxHeight) {
            double z;
            double x = entity.m_20185_() - cameraX;
            return x * x + (z = entity.m_20189_() - cameraZ) * z < (double)maxDistanceSquare;
        }
        return false;
    }

    public static void benchStart() {
        EmbyTools.BENCHTIMES[EmbyTools.BENCH_POS] = new LongLongMutablePair(Util.m_137569_(), -1L);
    }

    public static void benchEnd() {
        BENCHTIMES[BENCH_POS].right(Util.m_137569_());
        SodiumExtras.LOGGER.debug("Current method takes RIGHT NOW {} nanoseconds", (Object)(BENCHTIMES[BENCH_POS].rightLong() - BENCHTIMES[BENCH_POS].leftLong()));
        if (BENCH_POS == BENCHTIMES.length - 1) {
            long totalStart = 0L;
            long totalEnd = 0L;
            for (int i = 0; i < BENCHTIMES.length; ++i) {
                totalStart += BENCHTIMES[i].firstLong();
                totalEnd += BENCHTIMES[i].secondLong();
            }
            SodiumExtras.LOGGER.info("Current method takes AVG {} nanoseconds", (Object)((totalEnd - totalStart) / (long)BENCHTIMES.length));
            BENCH_POS = 0;
        } else {
            ++BENCH_POS;
        }
    }
}

