/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.blocks;

import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.moonlight.api.block.IWashable;
import net.mehvahdjukaar.moonlight.api.block.MimicBlock;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.common.blocks.IModBed;
import net.mehvahdjukaar.sleep_tight.common.entities.BedbugEntity;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundParticleMessage;
import net.mehvahdjukaar.sleep_tight.common.network.NetworkHandler;
import net.mehvahdjukaar.sleep_tight.common.tiles.InfestedBedTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true)
public class InfestedBedBlock
extends MimicBlock
implements IWashable,
EntityBlock,
IRotatable,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<BedPart> BED_PART = BlockStateProperties.f_61391_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public InfestedBedBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, BED_PART, WATERLOGGED});
    }

    public boolean tryWash(Level level, BlockPos pos, BlockState state, Vec3 hitPos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof InfestedBedTile) {
            InfestedBedTile tile = (InfestedBedTile)blockEntity;
            BlockState oldBlock = tile.getHeldBlock();
            return true;
        }
        return false;
    }

    public Optional<BlockState> getRotatedState(BlockState blockState, LevelAccessor levelAccessor, BlockPos blockPos, Rotation rotation, Direction axis, @Nullable Vec3 vec3) {
        if (axis.m_122434_().m_122478_()) {
            return Optional.of(this.m_6843_(blockState, rotation));
        }
        return Optional.empty();
    }

    public void onRotated(BlockState newState, BlockState oldState, LevelAccessor world, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        super.onRotated(newState, oldState, world, pos, rotation, axis, hit);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof InfestedBedTile) {
            InfestedBedTile tile = (InfestedBedTile)blockEntity;
            tile.setHeldBlock(tile.getHeldBlock().m_60717_(rotation));
        }
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        BlockEntity blockEntity = blockGetter.m_7702_(blockPos);
        if (blockEntity instanceof InfestedBedTile) {
            InfestedBedTile tile = (InfestedBedTile)blockEntity;
            BlockState heldBlock = tile.getHeldBlock();
            return heldBlock.m_60651_(blockGetter, blockPos, collisionContext);
        }
        return Shapes.m_83040_();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new InfestedBedTile(pos, state);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
        if ((double)random.m_188501_() < 0.3) {
            float x = (float)pos.m_123341_() + level.f_46441_.m_188501_();
            float z = (float)pos.m_123343_() + level.f_46441_.m_188501_();
            float y = (float)pos.m_123342_() + 0.5625f;
            level.m_7106_((ParticleOptions)SleepTight.BEDBUG_PARTICLE.get(), (double)x, (double)y + 0.01, (double)z, 0.0, 0.0, 0.0);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (IModBed.tryExploding(level, pos)) {
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof LingeringPotionItem || stack.m_41720_() instanceof SplashPotionItem) {
            return InteractionResult.PASS;
        }
        player.m_5661_((Component)Component.m_237115_((String)"message.sleep_tight.bedbug"), true);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (projectile instanceof ThrownPotion) {
            ThrownPotion tp = (ThrownPotion)projectile;
            Potion p = PotionUtils.m_43579_((ItemStack)tp.m_7846_());
            for (MobEffectInstance e : p.m_43488_()) {
                if (e.m_19544_() != MobEffects.f_19602_) continue;
                InfestedBedBlock.restoreBed(level, state, hit.m_82425_());
                return;
            }
        }
        super.m_5581_(level, state, hit, projectile);
    }

    private static Direction getNeighbourDirection(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.m_122424_();
    }

    public void m_213646_(BlockState state, ServerLevel level, BlockPos pos, ItemStack stack, boolean bl) {
        InfestedBedTile tile;
        BlockState bedState;
        super.m_213646_(state, level, pos, stack, bl);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof InfestedBedTile && (bedState = (tile = (InfestedBedTile)blockEntity).getHeldBlock()).m_61143_((Property)BedBlock.f_49440_) == BedPart.FOOT && level.m_46469_().m_46207_(GameRules.f_46136_)) {
            BedbugEntity entity = (BedbugEntity)((EntityType)SleepTight.BEDBUG_ENTITY.get()).m_20615_((Level)level);
            entity.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
            level.m_7967_((Entity)entity);
            entity.m_21373_();
        }
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof InfestedBedTile) {
            InfestedBedTile tile = (InfestedBedTile)blockEntity;
            return tile.getHeldBlock().m_60734_().m_5456_().m_7968_();
        }
        return this.m_7397_(level, pos, state);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_205070_(FluidTags.f_13131_) && fluidstate.m_76186_() == 8));
    }

    public void m_142072_(Level level, BlockState blockState, BlockPos blockPos, Entity entity, float f) {
        super.m_142072_(level, blockState, blockPos, entity, f * 0.5f);
    }

    public void m_5548_(BlockGetter blockGetter, Entity entity) {
        if (entity.m_20162_()) {
            super.m_5548_(blockGetter, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    private void bounceUp(Entity entity) {
        Vec3 vec3 = entity.m_20184_();
        if (vec3.f_82480_ < 0.0) {
            double d = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(vec3.f_82479_, -vec3.f_82480_ * (double)0.66f * d, vec3.f_82481_);
        }
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        if (direction == InfestedBedBlock.getNeighbourDirection((BedPart)blockState.m_61143_((Property)BedBlock.f_49440_), (Direction)blockState.m_61143_((Property)FACING))) {
            return blockState2.m_60713_((Block)this) && blockState2.m_61143_((Property)BedBlock.f_49440_) != blockState.m_61143_((Property)BedBlock.f_49440_) ? blockState : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public void m_5707_(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        BlockPos blockPos2;
        BlockState blockState2;
        BedPart bedPart;
        if (!level.f_46443_ && player.m_7500_() && (bedPart = (BedPart)blockState.m_61143_((Property)BedBlock.f_49440_)) == BedPart.FOOT && (blockState2 = level.m_8055_(blockPos2 = blockPos.m_121945_(InfestedBedBlock.getNeighbourDirection(bedPart, (Direction)blockState.m_61143_((Property)FACING))))).m_60713_((Block)this) && blockState2.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD) {
            level.m_7731_(blockPos2, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, blockPos2, Block.m_49956_((BlockState)blockState2));
        }
        super.m_5707_(level, blockPos, blockState, player);
    }

    public static void restoreBed(Level level, BlockState myInfested, BlockPos blockPos) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof InfestedBedTile) {
            InfestedBedTile tile = (InfestedBedTile)blockEntity;
            BlockState heldBedState = tile.getHeldBlock();
            Direction dir = InfestedBedBlock.getNeighbourDirection((BedPart)heldBedState.m_61143_((Property)BedBlock.f_49440_), (Direction)myInfested.m_61143_((Property)FACING));
            BlockPos otherBedPos = blockPos.m_121945_(dir);
            BlockState otherInfested = level.m_8055_(otherBedPos);
            BlockEntity blockEntity2 = level.m_7702_(otherBedPos);
            if (blockEntity2 instanceof InfestedBedTile) {
                InfestedBedTile neighborTile = (InfestedBedTile)blockEntity2;
                BlockState otherHeldBedState = neighborTile.getHeldBlock();
                if (otherHeldBedState.m_61138_((Property)WATERLOGGED)) {
                    otherHeldBedState = (BlockState)otherHeldBedState.m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)otherInfested.m_61143_((Property)WATERLOGGED)));
                }
                level.m_7731_(blockPos, otherHeldBedState, 18);
                BlockEntity newOtherTile = level.m_7702_(blockPos);
                if (newOtherTile != null && tile.getInner() != null) {
                    newOtherTile.m_142466_(tile.getInner().m_187482_());
                }
            }
            if (heldBedState.m_61138_((Property)WATERLOGGED)) {
                heldBedState = (BlockState)heldBedState.m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)myInfested.m_61143_((Property)WATERLOGGED)));
            }
            level.m_7731_(blockPos, heldBedState, 18);
            BlockEntity newTile = level.m_7702_(blockPos);
            if (newTile != null && tile.getInner() != null) {
                newTile.m_142466_(tile.getInner().m_187482_());
            }
            level.m_5594_(null, blockPos, SoundEvents.f_12420_, SoundSource.BLOCKS, 1.0f, 1.3f);
            if (!level.f_46443_) {
                NetworkHandler.CHANNEL.sendToAllClientPlayersInRange(level, blockPos, 32.0, (Message)ClientBoundParticleMessage.bedbugInfest(blockPos, dir));
            }
        }
    }

    public static boolean infestBed(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (BedbugEntity.isValidBedForInfestation(state)) {
            InfestedBedTile tile;
            Direction dir = (Direction)state.m_61143_((Property)BedBlock.f_54117_);
            BlockPos neighborPos = pos.m_121945_(state.m_61143_((Property)BedBlock.f_49440_) == BedPart.FOOT ? dir : dir.m_122424_());
            BlockEntity oldTile = level.m_7702_(pos);
            BlockEntity oldNeighborTile = level.m_7702_(neighborPos);
            BlockState oldNeighborState = level.m_8055_(neighborPos);
            level.m_7731_(pos, SleepTight.INFESTED_BED.get().m_152465_(state), 18);
            level.m_7731_(neighborPos, SleepTight.INFESTED_BED.get().m_152465_(level.m_8055_(neighborPos)), 2);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof InfestedBedTile) {
                tile = (InfestedBedTile)blockEntity;
                if (state.m_61138_((Property)WATERLOGGED)) {
                    state = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
                }
                tile.setBed(state, oldTile);
                oldTile.m_142339_(level);
            }
            if ((blockEntity = level.m_7702_(neighborPos)) instanceof InfestedBedTile) {
                tile = (InfestedBedTile)blockEntity;
                if (oldNeighborState.m_61138_((Property)WATERLOGGED)) {
                    oldNeighborState = (BlockState)oldNeighborState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
                }
                tile.setBed(oldNeighborState, oldNeighborTile);
                oldNeighborTile.m_142339_(level);
            }
            return true;
        }
        return false;
    }
}

