/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSVColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.sleep_tight.STPlatStuff;
import net.mehvahdjukaar.sleep_tight.SleepTightClient;
import net.mehvahdjukaar.sleep_tight.common.blocks.DreamEssenceBlock;
import net.mehvahdjukaar.sleep_tight.common.blocks.ISleepTightBed;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.common.items.NightBagItem;
import net.mehvahdjukaar.sleep_tight.configs.ClientConfigs;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.InBedChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public abstract class SleepGuiOverlay<T extends Gui> {
    public void render(T gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        Options options = mc.f_91066_;
        BedData bedData = SleepTightClient.getLayingBedData();
        LocalPlayer player = mc.f_91074_;
        if (bedData != null) {
            PlayerSleepData playerData = STPlatStuff.getPlayerSleepData((Player)player);
            SleepGuiOverlay.renderBar(graphics, width, height, bedData, playerData, mc, (Player)player, partialTicks);
            return;
        }
        HitResult hit = mc.f_91077_;
        boolean cooldown = ClientConfigs.INSOMNIA_COOLDOWN.get();
        boolean timer = ClientConfigs.INSOMNIA_TIMER.get();
        if (!timer && !cooldown) {
            return;
        }
        this.renderCooldownCrossAir(gui, graphics, width, height, options, mc, hit, (Player)player, cooldown, timer);
    }

    private void renderCooldownCrossAir(T gui, GuiGraphics graphics, int width, int height, Options options, Minecraft mc, HitResult hit, Player player, boolean cooldown, boolean timer) {
        PlayerSleepData playerData;
        float insomniaPerc;
        BlockHitResult bh;
        boolean laying;
        if (options.m_92176_().m_90612_() && (mc.f_91072_.m_105295_() != GameType.SPECTATOR || gui.m_93024_(hit)) && ((laying = player.m_20202_() instanceof BedEntity) || cooldown && (hit instanceof BlockHitResult && mc.f_91073_.m_8055_((bh = (BlockHitResult)hit).m_82425_()).m_60734_() instanceof ISleepTightBed || player.m_21205_().m_41720_() instanceof NightBagItem)) && (insomniaPerc = 1.0f - (playerData = STPlatStuff.getPlayerSleepData(player)).getInsomniaCooldownPercentage(player)) < 1.0f) {
            if (laying && timer) {
                graphics.m_280488_(mc.f_91062_, "" + playerData.getInsomniaCooldown(player) / 20L, 2, 2, 0xE0E0E0);
            }
            if (cooldown) {
                this.setupOverlayRenderState(gui, true, false, SleepTightClient.ICONS);
                graphics.m_280168_().m_85836_();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                int j = height / 2 - 7 + 16;
                int k = width / 2 - 6;
                if (mc.f_91066_.m_232120_().m_231551_() == AttackIndicatorStatus.CROSSHAIR && player.m_36403_(0.0f) != 1.0f) {
                    j += 8;
                }
                int l = (int)(insomniaPerc * 11.0f);
                graphics.m_280163_(SleepTightClient.ICONS, k, j, 3.0f, 18.0f, 11, 5, 48, 48);
                graphics.m_280163_(SleepTightClient.ICONS, k, j, 19.0f, 18.0f, l, 5, 48, 48);
                graphics.m_280168_().m_85849_();
                RenderSystem.defaultBlendFunc();
            }
        }
    }

    protected abstract void setupOverlayRenderState(T var1, boolean var2, boolean var3, ResourceLocation var4);

    public static void renderBedScreenOverlay(InBedChatScreen s, GuiGraphics graphics, int mouseX, int mouseY) {
        int dx;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        BlockPos sleepingPos = player.m_21257_().orElse(null);
        if (sleepingPos == null) {
            return;
        }
        PlayerSleepData playerData = STPlatStuff.getPlayerSleepData((Player)player);
        BedData bedData = STPlatStuff.getBedData(player.m_9236_(), sleepingPos);
        if (bedData == null) {
            return;
        }
        boolean hasDreamerEssence = DreamEssenceBlock.isInRange(sleepingPos, player.m_9236_());
        boolean isBedFamiliar = playerData.isBedFamiliar();
        if (ClientConfigs.SHOW_TIME.get().booleanValue()) {
            graphics.m_280430_(mc.f_91062_, SleepGuiOverlay.getCurrentTime(player.m_9236_()), 2, 2, 0xE0E0E0);
        }
        int y = s.f_96544_ - 39;
        int iconSize = 18;
        int bx = s.f_96543_ / 2 - 120;
        int bh = isBedFamiliar ? 0 : 28;
        graphics.m_280163_(SleepTightClient.ICONS, bx, y, 0.0f, (float)bh, iconSize, iconSize, 48, 48);
        if (hasDreamerEssence) {
            int x = s.f_96543_ / 2 + 120 - iconSize;
            graphics.m_280163_(SleepTightClient.ICONS, x, y, (float)iconSize, 0.0f, iconSize, iconSize, 48, 48);
        }
        if (MthUtils.isWithinRectangle((int)bx, (int)y, (int)iconSize, (int)iconSize, (int)mouseX, (int)mouseY)) {
            double nightmare = playerData.getNightmareChance((Player)player, sleepingPos);
            byte bedLevel = bedData.getBedLevel((Player)player);
            MutableComponent title = isBedFamiliar ? Component.m_237115_((String)"gui.sleep_tight.home_bed") : Component.m_237115_((String)"gui.sleep_tight.bed");
            ArrayList lines = new ArrayList(mc.f_91062_.m_92923_((FormattedText)title, 200));
            if (!isBedFamiliar) {
                String percent = String.format("%1f", Float.valueOf(playerData.getBedFamiliarity() * 100.0f)) + "%";
                lines.addAll(mc.f_91062_.m_92923_((FormattedText)Component.m_237110_((String)"gui.sleep_tight.familiarity", (Object[])new Object[]{percent}), 200));
            }
            lines.addAll(mc.f_91062_.m_92923_((FormattedText)Component.m_237110_((String)"gui.sleep_tight.bed_level", (Object[])new Object[]{(int)bedLevel}), 200));
            lines.addAll(mc.f_91062_.m_92923_((FormattedText)Component.m_237110_((String)"gui.sleep_tight.nightmare", (Object[])new Object[]{nightmare}), 200));
            graphics.m_280245_(mc.f_91062_, lines, mouseX, mouseY);
        }
        if (hasDreamerEssence && MthUtils.isWithinRectangle((int)(dx = s.f_96543_ / 2 + 120 - iconSize), (int)y, (int)iconSize, (int)iconSize, (int)mouseX, (int)mouseY)) {
            graphics.m_280245_(mc.f_91062_, mc.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)"gui.sleep_tight.dreamer_essence"), 200), mouseX, mouseY);
        }
    }

    private static void renderBar(GuiGraphics graphics, int screenWidth, int screenHeight, BedData bedData, PlayerSleepData playerData, Minecraft mc, Player player, float partialTicks) {
        ResourceLocation texture = new ResourceLocation("minecraft:textures/gui/bars.png");
        int xpBarLeft = screenWidth / 2 - 91;
        float familiarity = playerData.getBedFamiliarity();
        boolean hasDreamerEssence = DreamEssenceBlock.isInRange(player.m_20183_(), player.m_9236_());
        double nightmareChance = playerData.getNightmareChance(player, player.m_20183_());
        int barColor = hasDreamerEssence ? 13185173 : 14461959;
        HSVColor color = new RGBColor(barColor).asHSV();
        if (!hasDreamerEssence) {
            float desaturation = (float)(1.0 - nightmareChance * 0.5);
            color = color.withSaturation(color.saturation() * desaturation).withValue(color.value() * desaturation);
        }
        RGBColor rgb = color.asRGB();
        RenderSystem.setShaderColor((float)rgb.red(), (float)rgb.green(), (float)rgb.blue(), (float)1.0f);
        int k = (int)(familiarity * 183.0f);
        int xpBarTop = screenHeight - 32 + 3;
        int baY = 60;
        graphics.m_280218_(texture, xpBarLeft, xpBarTop, 0, baY, 183, 5);
        graphics.m_280218_(texture, xpBarLeft, xpBarTop, 0, baY + 5, k, 5);
        graphics.m_280218_(texture, xpBarLeft, xpBarTop, 0, 85, 182, 5);
        byte power = bedData.getBedLevel(player);
        Color c = new Color(57855);
        Color c1 = new Color(1598581);
        int textCol = hasDreamerEssence ? (playerData.isBedFamiliar() ? 12338943 : 6301312) : (playerData.isBedFamiliar() ? 57855 : 1598581);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String bedLevelStr = String.valueOf(power);
        int cx = (screenWidth - mc.f_91062_.m_92895_(bedLevelStr)) / 2;
        int cy = screenHeight - 31 - 4;
        graphics.m_280056_(mc.f_91062_, bedLevelStr, cx + 1, cy, 0, false);
        graphics.m_280056_(mc.f_91062_, bedLevelStr, cx - 1, cy, 0, false);
        graphics.m_280056_(mc.f_91062_, bedLevelStr, cx, cy + 1, 0, false);
        graphics.m_280056_(mc.f_91062_, bedLevelStr, cx, cy - 1, 0, false);
        graphics.m_280056_(mc.f_91062_, bedLevelStr, cx, cy, textCol, false);
    }

    private static Component getCurrentTime(Level level) {
        int time = (int)(level.m_46468_() + 6000L) % 24000;
        int m = (int)((float)time % 1000.0f / 1000.0f * 60.0f);
        int h = time / 1000;
        String a = "";
        if (!ClientConfigs.TIME_FORMAT_24H.get().booleanValue()) {
            String string = a = time < 12000 ? " AM" : " PM";
            if ((h %= 12) == 0) {
                h = 12;
            }
        }
        return Component.m_237113_((String)(h + ":" + (m < 10 ? "0" : "") + m + a));
    }
}

