/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.mixin;

import com.leclowndu93150.particular.Main;
import com.leclowndu93150.particular.Particles;
import com.leclowndu93150.particular.ParticularConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Block.class})
public class InjectBlock {
    @Unique
    private static boolean isValidBiome(Holder<Biome> biome) {
        Optional key = biome.m_203543_();
        return key.map(biomeRegistryKey -> !((List)ParticularConfig.COMMON.caveDustExcludeBiomes.get()).contains(biomeRegistryKey.m_135782_())).orElse(true);
    }

    @Inject(at={@At(value="TAIL")}, method={"animateTick"})
    public void spawnParticles(BlockState state, Level world, BlockPos pos, RandomSource random, CallbackInfo ci) {
        Block block = state.m_60734_();
        if (ParticularConfig.fireflies()) {
            double val = random.m_188500_();
            if (block == Blocks.f_50440_ && val < (Double)ParticularConfig.COMMON.fireflyGrassFrequency.get() || block == Blocks.f_50359_ && val < (Double)ParticularConfig.COMMON.fireflyTallGrassFrequency.get() || block instanceof FlowerBlock && val < (Double)ParticularConfig.COMMON.fireflyFlowersFrequency.get() || block instanceof TallFlowerBlock && val < (Double)ParticularConfig.COMMON.fireflyTallFlowersFrequency.get()) {
                Main.spawnFirefly(world, pos, random);
                return;
            }
        }
        if (ParticularConfig.caveDust() && (block == Blocks.f_50016_ || block == Blocks.f_50627_) && random.m_188503_(((Integer)ParticularConfig.COMMON.caveDustSpawnChance.get()).intValue()) == 0 && pos.m_123342_() < world.m_5736_() && InjectBlock.isValidBiome((Holder<Biome>)world.m_204166_(pos))) {
            float lightChance = 1.0f - (float)Math.min(8, world.m_45517_(LightLayer.SKY, pos)) / 8.0f;
            float depthChance = Math.min(1.0f, (float)(world.m_5736_() - pos.m_123342_()) / 96.0f);
            if (random.m_188501_() < lightChance * depthChance) {
                double x = (double)pos.m_123341_() + random.m_188500_();
                double y = (double)pos.m_123342_() + random.m_188500_();
                double z = (double)pos.m_123343_() + random.m_188500_();
                world.m_7106_((ParticleOptions)Particles.CAVE_DUST.get(), x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }
}

