/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.StructureTemplatePoolAccessor;
import dev.worldgen.lithostitched.worldgen.LithostitchedCodecs;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.ModifierPredicate;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public record AddTemplatePoolElementsModifier(ModifierPredicate predicate, HolderSet<StructureTemplatePool> templatePools, List<Pair<StructurePoolElement, Integer>> elements) implements Modifier
{
    public static final Codec<AddTemplatePoolElementsModifier> CODEC = RecordCodecBuilder.create(instance -> Modifier.addModifierFields(instance).and(instance.group((App)LithostitchedCodecs.registrySet(Registries.f_256948_, "template_pool").forGetter(AddTemplatePoolElementsModifier::templatePools), (App)Codec.mapPair((MapCodec)StructurePoolElement.f_210468_.fieldOf("element"), (MapCodec)Codec.intRange((int)1, (int)150).fieldOf("weight")).codec().listOf().fieldOf("elements").forGetter(AddTemplatePoolElementsModifier::elements))).apply((Applicative)instance, AddTemplatePoolElementsModifier::new));

    @Override
    public ModifierPredicate getPredicate() {
        return this.predicate;
    }

    @Override
    public Codec<? extends Modifier> codec() {
        return CODEC;
    }

    @Override
    public Modifier.ModifierPhase getPhase() {
        return Modifier.ModifierPhase.ADD;
    }

    @Override
    public void applyModifier() {
        this.templatePools.m_203614_().map(Holder::m_203334_).forEach(this::applyModifier);
    }

    private void applyModifier(StructureTemplatePool templatePool) {
        StructureTemplatePoolAccessor poolAccessor = (StructureTemplatePoolAccessor)templatePool;
        ArrayList<Pair<StructurePoolElement, Integer>> rawTemplates = new ArrayList<Pair<StructurePoolElement, Integer>>(poolAccessor.getRawTemplates());
        rawTemplates.addAll(this.elements());
        poolAccessor.setRawTemplates(rawTemplates);
        ObjectArrayList vanillaTemplates = new ObjectArrayList(poolAccessor.getVanillaTemplates());
        for (Pair<StructurePoolElement, Integer> pair : this.elements()) {
            for (int i = 0; i < (Integer)pair.getSecond(); ++i) {
                vanillaTemplates.add((Object)((StructurePoolElement)pair.getFirst()));
            }
        }
        poolAccessor.setVanillaTemplates((ObjectArrayList<StructurePoolElement>)vanillaTemplates);
    }
}

